<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns:clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001" xmlns:clm5639="urn:un:unece:uncefact:codelist:specification:5639:1988" xmlns:clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001" xmlns:clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="cac cbc ccts clm54217 clm5639 clm66411 clmIANAMIMEMediaType fn link n1 qdt udt xbrldi xbrli xdt xlink xs xsd xsi">
	<xsl:decimal-format name="european" decimal-separator="," grouping-separator="." NaN=""/>
	<xsl:output version="4.0" method="html" indent="no" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="senaryo" select="translate(//n1:Invoice/cbc:ProfileID,'abcçdefgğhıijklmnoöpqrsştuüvwxyz','ABCÇDEFGĞHIİJKLMNOÖPQRSŞTUÜVWXYZ')"/>
	<xsl:variable name="hasAnyFalseChangeIndicator">
		<xsl:for-each select="//n1:Invoice/cac:InvoiceLine">
			<xsl:for-each select="(cac:AllowanceCharge[translate(cbc:ChargeIndicator,'abcçdefgğhıijklmnoöpqrsştuüvwxyz','ABCÇDEFGĞHIİJKLMNOÖPQRSŞTUÜVWXYZ') = 'TRUE']/cbc:Amount)[string(number())!='NaN']">
				<xsl:text>TRUE</xsl:text>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="logoImageMultiplierValue">100</xsl:variable>
	<xsl:variable name="base64Image" select="'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAAXNSR0IArs4c6QAAIABJREFUeF7snQecVFW29Xfl0JkowYyKWcecxTGnERXJQQQUs+PoBCehjjlnFJScxIA6jhFEwBzGMM5TMYBKpnNXDt9/n9tldxV0VZeEhvnqvB+Pka6+de+556yzw9pr26QwCjNQmIHCDGwlM2DbSu6zcJuFGSjMQGEGpABYhUVQmIHCDGw1M1AArK3mVRVutDADhRkoAFZhDRRmoDADW80MFABrq3lVhRstzEBhBgqAVVgDhRkozMBWMwMFwNpqXlXhRgszUJiBAmAV1kBhBgozsNXMQAGwtppXVbjRwgwUZqAAWIU1UJiBwgxsNTNQAKyt5lUVbrQwA4UZKABWYQ0UZqAwA1vNDBQAa6t5VYUbLcxAYQYKgFVYA4UZKMzAVjMDBcDaal5V4UYLM1CYgQJgFdZAYQYKM7DVzEABsLaaV1W40cIMFGagAFiFNVCYgcIMbDUzUACsreZVFW60MAOFGSgAVmENFGagMANbzQwUAGureVWFGy3MQGEGCoBVWAOFGSjMwFYzAwXA2mpeVeFGCzNQmIECYBXWQGEGCjOw1cxAAbC2mldVuNHCDBRmoABYhTVQmIHCDGw1M1AArK3mVRVutDADhRkoAFZhDRRmoDADW80MFABrq3lVhRstzEBhBgqAVVgDhRkozMBWMwMFwNpqXlXhRgszUJiBAmAV1kBhBgozsNXMQAGwtppXVbjRwgwUZqAAWIU1UJiBwgxsNTOwWQErGAwmN/bMJMUuNkmIjSvrwyQcCYnHE+JyOCSZSIrNbpNwnJ+4PbKqOiIffPxf+fena+TjLxbL6rqwRJIOCSVKxOl0STK50W/v58fVa9vtdkkkEht7Csx92208o/7ZSMOWupbOSZ7Tkvc82vXlZXyJLZ71SRK8WzvvVv82I2lP+7yN69kab9w8i/mKzAex5it1v8lkgms6zDrSYbPXSdjeSUpCX8sbk38vfk9SkkGPxD2Vcuv4d+XJ138UsUf5fNx8lz5CXPy8hojYkwHpUFEshx62i1z5m+PE7w9KzJEUX9QjYVdA7OFSsXuq5OpbX5f5n67gHvT16TtMStzulpJ4rcyffJUkYhGxOfWf3eJh7Rw25FZpcJSnvZOQwy/by9fy4qTrhaUv3phNKlnXvYbdzn10lrizjs9zEb1Hm66/pDicSSnhz2H77SgjB58kO5a4RJxVEo0Vm7m028L87dhIq+mXX8bn86Ut6o23wltxT5sCsOK8ZAUs8zL4Oxljwbl8UhcTWbx0rfzt9lmyoiYucZtHQjG7eHwlLA5dGHaJ8XYTrBSvI24Wbd4brRXPnPqILsZNdX3r2jx7nsCS7fY3BLDsjnTwyD1N3LiC1s9DASbX0rSe2Tqm9C9rDaSG3abAY92Hfk4/pQdY85Gar0yc//k9JWMcaCXS1b1YXnriKq4WFHusTGLuahl61TPyf2s8AAprSDgc9R3otwBWutFdDq/EIrwTiYk3EZFf/aqdPHjdyeIOxyXoDomtoVicJTE5bsBDUhnv/POdK9AmEzZ+p0oWTLtY/M6YJCNcxRGVhphHTr90tlTVp8+NzeORw7pWyUNjBhnAc8RjsizhltMufILfLQEAYxZ4mznVObFJVIGZ/3bys2SiXjq6G+SVSVeKN9ggEbsXzOJ3NuaCyr0I1vuJ/znA8rhiEgolJBR3iq/YLxNf/FQmznhR6qIVEpYOvBpOO/4kWFAJFrEuKruepGqVmT9JQMv9C6fzf//XzNbYiEC4vhlLZlpXBl7yBb10wNJNacuwunJiYMbNObBK4vy5+NwdZPQ5e0okGgSa/BJ1huXUwTNlOYegI4l1lfSyhvgbsHLZSyUcDYjLY5NgsE4cPjc/c4kdABl3zbFyRM+OEvbUiDNcJhGW3RF975OQp6IJqhW746Xillp5e+ZQccbqxRFzSojpGHn9k/Le116xOwHFtJfik5tHHi5nHt4RCy/GzMVl0fcOGX39c2LTQ5m7jkWqxOfzcy8WyLsB41jCxUHOTrBzoPONu7hWyHOPXMI+4QDn39VybOvxPwdYARZDJZ7m6D88LstqvRKNevH+eBGxEO9FT4nGU1ZPLrXE1CJLeMxhY+1DtdB0ARTG+mZg8wCW9R6axi9FyPRrZNpoGC55jSTWk9ftkom3nih7dHJLNOEUJ3AQdiXk2HOmSXWZQxxRtzjjLnElAhKPrhaHHVfKXoxrpn98Ync7cDPrAYoK6dnpJ5l8x6Vic1SKO1Im9R67HD94sjQkmlwvc4DyLU7W5MJpg8QXaRCnxyn1IZ+ccuUc+WFltRR7M8Acb+/J23vLbuBekkMZk0l+f+88efFDAJTvSsaL8FUdAG6D+PzAGRZfHE/E4Szi25wAFmEU3NWyREhemDREyuLVQJyPa/3S95DXNGf98FYGWICMAZZUnIr/JjblTQQlSNzpjf+ukmtue8X47eropz6XmoGm9amLQF+y3VwPg9hYWhjP5r8d5tRpGg4WZmG0dgZ0Ued5EnPIpAEUB4seLhs0jPnUHJH0cNqwDVeLpVEOYLzxxKVShssUE4+4sK4a2OiH9R2HmwYgJexYP0XSMbZc3pgwjPXpxlYJyNJ6u5x6yUwJO0qkY2SVVDvbyc7tK+WZOy/gzAyLE/d0TaJUjr9ggkSTReK01Rr3ze4kVOGo5VAtkql3nSv7ltfg0vnltpkLZOrz2ErOZRJxsNYjPnE6LEvLhnexcEZfKQtFJUZ8LMH1Tj7/UVlq84s37jGWn675GTeOkD26JyTqIHYbccjx598nVfYdWf+4qGZPeOXua46QE/bpSGxQ98eGzd8Gvc/GX97KAAugAjzUxCWcbiBG/9eH39fJ6L9NlqBzGyEQJQ5iJi25205epgnGExyN2yPWqWECkE3L285LbT6ixuQujNbNwHoC5rl+UYO5af6Z/veGHhKZgKWbbcM2XIzgd3lsmcyfNppAdj1rrJjbrpWApxTAmkCQmrWFaxV12KQDn5s38UJcLdw/3MMqW7kcNfARibrLxJ2ISb2rRE7bMy53X3WaccEcANb738dkxJg5uJ1+rLBqsWFFOUgaRQlzJDmQrxq4mww/bjuJ+8rl8D73Sp27K0dsWHbaqUyWfFtneQzMoyuelAUAVkkY2HE2AFhlclifeyRQ3h7X02XWvpODfuHkAVIUrTUWnCaA/jHpU5n+6ndWrIrn4Epy40X7yhmH7mhiclZcsG3HVgZYahfhT5MdiXOq1ZH9OOfC+2R5iCwJmRJfjBOFYGS2kSCYqzkc0TgVi0kDsXrisMYwDKJkQwAzTGEd+hI12GyPAovGErPGL8nspYLWPwevf8F7/6XbLU/PJ+3Ofg44t5BxXPfaOoHpgP/zBVMfzjxNjDXV7Ok4SEywOsvInMfUfab+3SRS0kYzAMv4/tQ3m8yqjsa/4/G4lW1tHE4nMZ+ar+XNOX8hQxfkOcvYyAFcrSr50wMLeALWXsLL74flqL22l8sH7yVhgGhtVYPccv+L8kNdKTZZTMJY/w5nSF57aJh08ZItZNHxLzL22U/kgTlfSgKX0uaoFnvQJiXuhNQSG0skymWfbitlys0XyMzX/yO3Pv6NBLx14mNpXnlJb7n7/qfJiCs4ihRhBb4+o78U4frF7LimUiJH9n9CGvwucWJJJQig+6L1Mm/mRXwG4OVzDZwRZ134gKwMtTP7AjzDyI3LxBtPl/239+H+6kFUAKy89qBaQ5q6DoSd8tS8r+S+ya9L0LUNLzguThahk1NBg4bZBqFFzPik+HlpiUC1tCt2y957dZX9dt9N9t2zp3Trwkvn5w4QTI0vwhYsJrXjmkxiBbJ8R9OGyvc3N+Ln9eDM83KpR43pRKxnmO3cuKmtZ8Ty1bhNPiPh59PN5lTvM8eNZuKnRh51pNyW1H+v7zZaen2ZoKfJTQ0vpO5Fp8CvG1kPNNwmwRLSRXLFTXNk7lcKOdAFAKwkAJwMqbVVJd7SUmkI6przm6yknZ/ZbXVyUe99ZNgZ+4sbEIizpm1YlIOvnSCfriFrzeeSAFZHp1cqPFH5ppYVmGhPxu4teXvWzdJryMOAVSfcuIi4676Wgw7dS97/PAzlglhXMiyl4ZUy76nh4oqUcoAH+d0SOXrYU1KTqMPJcwFiuJKxoHQpSkgpD7S6qlaq6gjG+wnSk810YhHGuU8fLvDCKcPFH68DsDQRle/qyWcRtO6zW7SFpS/RZPE4NlwENoOReqlxVMgZA+4nKtCJybVSxjiAFomBVcwBwumHpRSJidNdhHmOqUz6xYXfr2no7SricvtfhsqOnckV8rkYv+M1gIeVFWsgSKqxjhIrk8If/dsFuHHE8UeBS7/LSgX//zhSm7oJtNX6bB6zUus1A9BNjEpxrYU5M7Glps1gLBVmf0NGGivi5wtlf2frRN4aeUep+47ZsY/YuApIgoXk5LkiEpJfDxzHuuxiHWk8e9zmZrP7JAhw20E7GzSEqM0lXttaaBA+Ylyr5J3Zl0sZllAUS9IfqpCAOyjHDB0rASc8KSwbBfCDd7HL9qVlMvuDGkAuIcX2FTL+rt/KgEunSRgqRJzF/vgN58qf73hV1gRqWMtek6U8bMeQ3DOmt3giUCmIPS0NxOXcy59nq0CrwF1U4zOOreeIu/EsoGbwGZtdfx8XlGs4+UBl/Wo5YGenTL79fPEkG0zWcEsYWzRgxclwuMhg4HWTOfFJPVyRs4aMk1p7O5YzfrhNsy2+tHl0J/Sk8XFqaeqYxcAL7NYuKQ/f3Ec6F7EpAB6HA7JfJCouFoEushipaQUu3SJOl13c8SpSyXViq/lJQqt/lPCyzyUMHyUaDhrqQ9KOO2C4Xv//Drv6DGZovCkHobDRvWu1O2wAb8NIiuzNvA2CJDGotJEC3pQFCe4W791bHJ0PAYjIqmF7N3gjcmjvhyXm78B6c7DuOPyAsaN6thO7F1IBRtfqNSvkqyoOX2JeNsw7bHvxBL8hzvRnDuI6KQ5U4K7F5PABj0l90kN8yW1itRedt4t0Yj1eP+3/lNtAPKxBOpc5ZWkNoMlhbg9VymvTL5GTh06XiJM1CeA4Wd9/HbW/nHzYNgBcsfoTuKxL5M/3v20ezQpnaEhFiaAaEFET0imxZKk58OOhBmlX5BB38Ft5cfqfpZjvVEBTClDeE7oJtscWDVhhPQdw84STYNHiern6lqdYCu34w6mgy4UAugYsdZh4A4uBqZYIJ7Yrtlqu6HeU9D9rL/4tQFAToCJ17MJMj7scUu8s5bRJCN67OKMrpearhRL9egEgtYTP1kMexcXEbHYmo1LrKjOBSJtyaxSwNjDbtAne42a/ZDr45HIVGt21XH5eOlps0DOlKh3yuUhinXBCukXmU0v83AeluuJwMtMBA9QBMnS/HjJDGohbuaKlkCxFyu2rZd6EkeJlPdr5nVC8QZ76eLXcdO+HEgMo7DHcRm7s9kt+JScc3gWqgh/Asskh50ySOCGwJJabExx57JaTZBt3qZz2uxngN9QbYrR24qwhQhbuRIX8ere43HT9uQTUp7CmcTXhfwlB9AUzRxFMh/vF7QdxAi8bM0ne+QYX9edqBWKzxH/VZXVy+MfVg2GPJJNB8QOg1/22rxy91w7iMRYinEX2lCHBFlzC7KU5SbIpQSyr5xYtlrsmvMlLKaVUoM6cZCZgri5jozuSehlOXsLAUw+Qi/sfLD78eTs8LH0hCVcUoAsz+UVYUCFxr35bGj6YLvFln0qJIwSDmc8QAzBWHRioJ0oMM17/20dgUt1Om2FIK4Ncg8r/f7qE6wCACcTmsDbzzfi15po5kEg5VrlgNPMSjnUC9elX0OB10YXPSSUB8BK4SUFoAvWQLY8dNFOS3mrxhjpCI2C9RH6QRU+ez0Ho58jVw9Ul099eLbeNX0hZGPHTWFjq3SVy2Smd5aI++7Pe7LIad/PEQc/y+xyoAI+Ltf/kQ32km9crhw8bbygTGopQiyipVlzUKR892Vd+DDjk9POnEXAHzEh2+OB4zZs8QrxhBZoGMufFcsaQe2StdP35cTVxdf+N58g+O3LA46JGAUAfiaUkyQD9mR+gSnBPqWKmpHkfW8Z637IsLAUggoQ2DWZiWdmp55s991u5edJCU4ZgpwbQpVk7FlaSTFLCpnVbMIdxFR2kmffZsaM8eP2ZUhrX00X5MTCOCXAKaV1fGIsp9L1ULbhP4qs/I6Oo3wMosVA0b+jGosIeNlaUkud0YTj0Hvg7zMK0ln/jKdMYc9EFZP2rFWxuGvq5XxCYz8cc2GI+y3NmbvR1LND84lGmhCYzDpbn85o0fM6RDki6rrKNOgLSJcPmsA4hIxMYD3GgLa4LSu8r/kX51xpAolwSbrhauHc3/fFUQntaKyryzsJvZPIL7wMeJeKGGuHCag/ifv5t8J5ydq/dTdx07mdV8tub3mUtV7J0oD7gir0+aZhUsDYPHvgYMS6fVffHwerGfevWoUGev2uA3DIZPtarP1oWkFIogivkvacvh4iqn62VoKdcevW9m+RUxybAYo2/PvF8qUjCvI8S5GfPJQCtmCYFnLiF4ah4qEfUnLxJdBlOlo7WzGnOSd+gD2xRgBVnATgpEnU5fRLAinr3mxq55vqnMLe13o8gJ+xc9bNTgW+dSh9g5YKzMvHeQbJ9mZvTi+ChlktgGWm2zxtmszT8VxY/cwP1USvEQRxK4w/5jPQgO5aYlvSYYlq9Feslrvsq//+OceUzv5mfNZtjg/dGxgU0K5/2Ra3hZaUfOlX2zlI6aI4UcQhGiRe5WVoTXl0mN03+2FglNs2k4VbGiaO63HybAgxx1BghDbVelEGu4BCHBFoUXyuvTRpFBq4a+lZC/vLwQnn+3XoOTI3BlsArXy2LJl8kXpJHxw6cLms8xcbqUnJzPFkvzz50juxa4pGDB/0ZMNrVlPpAVpeOxF5fmjLUWFtKWK2HI3YkpNZEArqCTqvuH9zZN2YMILgSotCfw94czGphKchxEbK2ahBsiWOLAqwIhZ3FwWLM21WyytVBzhw5SSobsKCYYy8ZQc1qJAAKykdZfJDtcPEqbKtk3vSrOVkAIuq1olEHi8kpnliVuEPfyXfPXycdw8ulmIxgIF5uXqr+Xj4jAZCqO6gvVa0pvb6ms01cy/ybZT43jdZshvQ7MMHP/4Vh0GbDSJ/GXt1gwEqfTL1cuuGnCJbDacyw8qq79pLSk28jRFBNNq9MvMR8hvx9inz4A+oeWPVJNnqCmI85U02oguC2oeJo/SDfpXSPWDvD4Trt0K7yl1FHSTEWTZjsc+8rJsqXVe3FAwqGKOMpSf4ob0+6iFgWWb9BN0ugdAeoElxTC6lja+SdiSMps3HLgSMnSz21hupWxgGoniUJXMlzLNCJB2WVFMspIx//mZth0zgd3siHMy4TWwA1BmJkmtjSKJaGO6zQh85/vg715lm8WxRgaQbFQUpYObtH9r1LIq6uTCITSerVpnWAcRYEp4CeMp7ESjn56J3kmguOlSLAyKMpZ049QpxSFPtefvjnnVIOR6UkWEvQvIhApU2KkqsIqPNiMzKLuabaxQlkwZX+LtdRhjzms7G0NO5l8ot6XwwTWFaXpnWbNmHqiKBicH8p+ZNc9xOLWS6WMzOrlesXN+bPs7hcmbF1e0YwO27oIU1jnexhs73S6sziOs/W7ABotK5SYWNL1UFHrkPCsrD0/rVI2Hb8GAnvcJb4EpWmtMaH9X7IwHtgrfdg/SlBU6kz6cTlJLwso2ZjyMgNrNVlcutfBshhBLVd/FsSekEQv/GkkfdJdXwbkkx1hpnuiy+VN6ZcTSbcLmdfPkm+WAtVggC/3vMNl+wnZ/9qewn6PXLMwGlSR/jDTlYxwvUH9Npb/jB8H/ZKsXgxABZ9uVIuvP5VbqAxm869+AjSLni0r/hwX8Oc4J5oDWx66gtNDBdmPXvITWxuI5i5G3PFmWu1KWCFAqFmhGSQnVKCOndUzhw1TlYGu5DehUtliv3gnPDiksS21KqhVl2uGnGQnHX0blIKkMUgecZ46S7KJCIfvyj1nz0lFeFvWChah8XnlVrFC4ghDaJ6RaRSzMtIuXWatjWAowtLi6FZnEbNwdQWKnuLwlUl1JV0lKKO3cS5zd6YfKUUoZIKJk5mJ4OTki6x3pDuuNbV05mT1+wdvafWnWop9nUK7Db6qmj1BVu63/Rnz/xUfB2me7o5ZVPdMoMlrZuP9d5uo7yMIWEa+7fpO5qumh2wlLNkvU6uADfKv/3+rIXO8PbWSpW7vVREqmXeF6s4YKET4MqxWg1zz/qdxlCBZuAghlaUFcm223Yku2jjsG0glqXaaySAsGTqOVTf+rqWVYmbifUfxCJzk1k84YCOJJmS8tW3QVkCl8rFGk/iVh67f1fxBYJS7S2Rd99fBSse9w3XLgYrfteO7WT7bbhfrC4v9JtvVoXkkx/IegNeqeGlAPvYPaFdRGqlPhCSym/+LQ14Ix077y4du+wlNk97o2ligu7mMSxFEw2NaCbV0ptrHhrhJzpHG+7H51x5bQtYDeTmjPmsL5nMBwfIY8/8Vx6Y/RnWEvo8ivL2kPHPDZGTlKsPi+uOy0+QI/emkNNWzEvHr/ciJRP6UX589nppV/NJjofWzKKCk8YD1KZR944qfOIDyqsJEyerLO4k/k77SPnOvxZHh90liaupxdRRrDglBeoC3sgeS84XVfhAYQY25Qw4SWA5oz9JZMWXsvjDD8UV/FQ67X2ilO50IpVW20uNy0Wwn2wi5OoYeyDOfnAB0tHGnIshn27KG2y8dpsCVm0oiuNEOlZBh6ddES+R3sPGSgOEN2PfxHHxHJBDFdX5mQM27j+uPklO27s9QmlrcNPRt8Kkda36WJY+/yfZOfq1NLis4GJLwwYAmuAodIkk106SBo5KqQRL95FOBw0SG0AVptqeow/rScmkkPwoQrUR3E82Mt3Tmd2b4S0VvqIwA5t4BgIU+LtifkCJEBfxXw8uou2b52T1ovFSS41S931OFP+eJ0mVc2fcRY944INpnMuFzRml1jFMJYlLy5U28WhbwAqHk24CfipHvBai7nlXT5Wf1gIkzJqaoKorpIzcJP65JxaQ0f0OlSG9tkXDR6cJrSt8veKvZkninevFU99BVpZEpDiS3RXzxEowuldKvCIhK+p2lp32HiHOfXsRcqKUQjM8uJBu4ko2TGyVoVWvJOIOGBPYCoxrJkXLFDbHebKJ337h8oUZaJwBJVfHCZkQWDHlOk7Ap9JZQfaTYupVb8uKp64nyB+QYHFn6XbsJRJqt79EcUmTSoHQ2kScyM1RvtOmgBUMBpJasBwmMPldTUwGXDkVi6YdZqaWGaguVdwEu1UU7aBdknLv9b1BcSYGgCuur5PKT8ZLxbfPUFxqY5JJJYMlWmKTbcQ89VIV20m2O/4fIl13pyaLzE2AXyQepfEOZbarJmMje4JLAVRGfcDSJLVkNlofbyrsiMIMbA0z4ILnGMHKUiK2ZhyjxI8NFxEFiBgx2lCdaoF9IjUv3yDO+hWyNoxu/FlXS6D9kRzoZEwTtWyVFlQ6NuIEtClg1QdjGE8UHAc80mv0WKmOtU+zW/xYPGtw+TrYliCadpm4sbaimJ4kgiU872bx//g6NJcMORlYwhqUV22gGFmPGMFyX6SSgDtFoJ6dpMcZ14ir/V5QHMg4cnrYASh7KzN6G3He/4culTogLCqHiQ+a1LgGZ5U5APHDFPY1DWeMBh8mwWFpK7Q2O/o/NGlb3aPoQa41ui54kvL9c1L95oPUGaL0IN1lu3MvkdrSA0h6kSwI1bOp3BBj4ffnSsL+glloU8AKBxqSEWdcagLFcsKo8ZiUxIqaPYQNP9pDCvmVccOlHeUzYVw1NxnB6PuPiu+Dh6XOh4BZoiZ9M6jFZoLjWGZMspZ//hTrIO2Pv1R8Ox3DNVTAjw1DPkapEpoxNIH3wtiAGUhVARiIIiehGiwKRpZ77sjICtpgZCs9RYXkLPE6lWIpuNgb8AI2+a8aaQDeq4r9qeqDDS7Xqtf+JtuueFkCka5S2+VX0vWky1Ct2MF0piqFKhEig76xR5sCVrChLhnH5Dzr0omyLFiOfl66taSKDH8dfqj0O3Ynnpvwt1IOvqJu6627YL9TJoEmdZS/m4+YMt/VaoImkOCUX9Px17LdKRdB9Nve1B6yOwwb2Tr0G9m9rSyjaWr/1Fio0Kryj439yjRJaX1/Ll2uTdWVJ+2JUnV/2qCBNe1BPz8WpsLfhXVr7FzNXzRVFhi1AFQ2nPreIAIbuol2atmMRMVc3K5NMW+5vjOfVbIp7i/1/S3dZ5h36GZPeSnA1ioSrbN146LEVr8uK+ddJ90CtbIKsOp0yrUS7XiQRIgVuz0bny3fpoBVE1QelkuOHDoRbSrVmk4vsvRQRPru7D9QyqCV8RDnqj6Xmjm/pah5ldJDmTzt2ZbJ+bFB7AvIaltnKTruCvHsQFpWN7dKZzDRpmcIsTGtG4tBVNXfbq3pmgkUm3LhZFvATaqa2XlKmYJ0+WyKVn82pRaqmlcKWszx8oagvPfJGvni6yXy9bdLpaG+wcQES0pKZbvttpOePbaXA/Ypky4VRSaoa6cYeHOM1s5Haz/XmnvemNdqzff90s/kuk9VbVDCdgK3T7lgKvusPRupHCLRtVS+e/pK6RD4DnkmjwQ6nyntTrgaT2fja2i1KWCFqquTLy5NyHV/X8hhuxp7qkTKo1US8rVHe6pa5o4dLJ298KMAshiuY+TBw3CPm+tf4XYoEVTLENQV4aQurg/Lf/3dZM+BN0jA9StAiep5lBYdXrecPWKy1ChrHgvslwwjlwzIeQn6e2jE6vf7pXv37rJ3z51lx+7tZJ9dEVBTNZxonYQg9hU52mNe0FWFxpVezToa8TcVvAsBm/mZy8Z1oujW7lgh197xnnwOEMSbdVcxz5MhK5wgCKrWZpQSjWfGXiulFMNGiUNsyNDyKR/rnqkOAAAgAElEQVRKAS7M/Zq6anGXo1iApfS765+VDz9bw/35Cd5mB9KUMRXltFZZoH06x2TcAxfCwOa9oAKrtZ42FyobuO7KkTNlWBpwzGO4iZMFPLTh4m8X3LrVrIMhl95NCzjmxKPvAXqLSZ40DZVRaT76nnG0DDu5vbjC3STqQx/NsL/zGxNmLpLxL30mRRCN7XYC0znZ9S1fX9ee242ufJFHdt15WznswL34uys1tEwbBNBkPEJpGjRnt1+cRSXSEKG+ERUHdckz7z2pmW6SW8loRJ5fVCNjZz2d9cESlAupmkXEFRZvg19mjj0NKRq+uHFolnDx9KHSY833Ul+uVSfF0nHITDTs2qP3FZAQQKbcxw2NV7YpYIWD0eSRI26XuvCu+MVQB5QxYAiaDuli+1ZeefwaE2dKwgOpnnWheCs/o4o8PZKndDVTC8Uu0N9bVtRDdjn7QYLsnWm/VMUFy1n2NIMk+H7YOQ9KyN+JQtD8ip/TzGT2ogOX0tJ7h/KATK0HUp0uFi10VWXUJFpEV444Vs46fkfxUzemEh4qjatpX206rYHpXMoAmavHVM3THCPEXBzb/zEAvFQCGRvOols0jThz6iZm58CKnX7fKbJrKQXhzdyz/Lae9Wm7qa9DqYBYxoqQQ/qNugXpnm2lnqa0LuR2I6E6QDI7GKcAS0uMPIBHkHlR4m55fKWMv3OEbNcZNUy+wSqlsVRf8+2J5wTgwoCrjQ1po2Tr3jkfydjZ/2HDVyD3S9xSpYqN7G/T0H6VzYcvsELenXMZjHBNHGiYweqWnM/4+2PvyjPvLkcwUguPVXCyNJ9fT/usWkG63t1elHRDqnhKYQ9s62qKoYsoqu5EJ5+RA06U44/piQhArSCxxZpD111lY7Rzc7ORAqwEoPbUvJUyZspn2e+L71LPJILSqj9cLO8+3Qcgb7qmvisPc/3Vv/rJzpXLAEu31CME2PXcp+THsg6yTYiibw7QDQ1Vtilg1UaTycMHjWWZFBuNKyWe1TnLmei18ua4C6QYgX+qnST4wwfS7qXRUuvdBm6Wqn2mhr4+Th1cwHraJzWU7ixdf/MApijSsEb5QYs4VeA/ABnVK0f1n0TTSjbwBraHX0dNhYVstQizWrEq8mplfRFtxX9/4VFy/JHdpcylfey0QaUueWgYGa3Ecq5iDVJjFby3WGTUDcjdotPtwExP33HpxD2tOHJCBoxhYexY/p08/eDlxlrdkJFA3DBGo88rbpwmH/1XtziLUNtC/ZxpzS1wuE64CuDVllKqopnAGt2pIiTT78TiwjrkXww3yMgS5zEU4FT9w8X9hrAEjup/FzJB3UyCxRT2KmBl1P2pbEzzoXM1d0J/8WP922Plplgl31ZXNz32lsxa+KMR16MbASGMPB6ihY/GKMXRJIXKI+n6t0Ow1mihumqazFCwOvvY3eX3o47he9kvHK4JDpT1AZaNwOOs11bITdMsRdKWhnoHaqnF3Kj4IlAwf/a5aMY3B8EkHo2T2l271D+NPHNouXmnMa5f1ucJCZX2ZDNuOLG0TQHr68pQ8syLXyA4W0tZQBmbqQEFR5/s5PlWnnnkcjJIdmoFV8ryxwdJGZ8xVeSZAXKTjbLJipJfyQ59biXwW0FZFTIdLEhHjJNIgYuTLYTvffSAJ+gLx8LbwD6D6yw6XDEVvjW5MnMAq+Gr5UToeNNTbp+e5TL2urNAKj2ltVA1JTmbz+JlcVIrds7oGfLfOurRolZ/ubQBe7/5MPDJyRogxVyaXCvzJ6GTtIGLJgjwn9z/RtO/Tre8C6Kt1pFpnZtaj9oBJlfGLxOwVH9dO7loRyM9aDAfqT1YKa9yv6UUmquObMzUWrZ+JB0NXKfc6Eotp9/fqRcgcmcK1i1A1QPGkdHOLWGkr5tGxBWREUfuL5eM2hE1UQUsXKhWJmhSV7lx/AKZteAnDknoOIQjhA41G5oPtagj1jDJCqo3UtlZc3ByQKm76439IPOm/V4qeI5IRhORlIWVAqxbJ2W3sPT96BqPNgLWm7P7iLuZhWVWPWsNOEMyJyo/ImBYUf8NpFIbO9cjHdD0Crt3bP0LbOGTbQpYk1/5T/KWyV/QgTaAJcBmc9UiHlYhs+8/XnqWou+Dvx56bYz4lyBBi+Xlw+RUP8yJ9dLg0PIdQkTxWlnj31M693+kUYQ/BRhWvZ/WPBH+4pQNylHnPUN8TP35/FzCzLlb1ynAPWxmdlkL0toc5m742ZF7lcgDfziFf6YWSxtl5mlhKfjUE386ZtBk41qqbaPPlo5QGSx/Y/WoBpMWryblliuPldP362hECoM6L42B1KyriE0cxa32kpGN0NTj+FETpRLApPLbWCnWc1sFsSlJEouDZcUr9H8riOkGMUBB0a/qmjUfusn0Pm3E9yzLQX8PbTPnKnl98mU0aQgphuU1ooQOimn+oIy8ax9ZIK+9g/yL6eZjNWGwVkm6tWndR9OIh+vE4/fKe48PpNKCjDRxO9OzL49x4/hFBrDsHCYKWFpMn69buc7XNbrlusAtm08tLV1nVnWsVaRMFo/59IWWykvTr5XicBXigppoKkYJQjN9qKAo0EEVmjp3hdw+5d2sT6Vy5AE0l32q74Xl9NG0PkiOp7uZKVkao7pC1nDZ00Nkm/pV0uBj7YQ7SMXwp3BNVQPaZx1srRQIaH5jbQpYo8bMSr76OXEfpfZz2jXYG6QsGJE3Zw/ndCCw7VosyydcQhfdlbh8WCtUuStXS4duQN1wyzDzdxj+sISJWak7lq6aoC6hnQ3C2ehqALCelzCN3LQz7uYeflQoZt85ULqXqlK9ag/lt/D1fv/1/lK59t53mC91kTRr07rn0FiRg6YR7egS/Nr4q1luYTq3qMtsZX6yDXUDoqpNHk3I+Bc+lQef+ZLJh0eVw622Kv0tXpbGPhS4NKKip3A8V8JBEYVkilrCB3S3ywM3n4LsSn5JigggXQKpeC3lXSeMfIAYG5w9le3IYyiPL0aM7eU7z5XuZVgXxgXL7739Y9wimakuobapB7CUx7SpR6q9vVZu2HAPe6KOPPEfg0mUAN/IjHtx06KQqm2EGLSvwTRiWLdPei/rbSn7vR7AKyYYF6Z28JOp5xEfbDm7qzFeV+W/ZfWckXQH8gq5Dqm0dZBuI2aj66VxZ7pgwaBHvS6v6WhTwDqk/13JVfGu4tGMDczzWk7A3j39csufTpBk0CWr5l0sHSls9uB/h1mA6tppJlGl+3xYVmFHqZSde7esrjhMyuH+aEYw093YUgDLhthaJ9cP8vLDl7Jx9GBr3ebRQKuCAyXYcsYlNI0lY6UcM9Wp17bo+Qw/bcvfmExzhGCACgAl1lqSIVkBi7iOjexWJU7arwc+im4SEj1ZM12NjPfGxgUJA6ymswJyQZZxYeOUzjqgSMRdEIKjHaUDQeVpj58knRtdwlzcs5+vywHnwv2uoh/g0SQpbMgTa0Yyn6GkF93Yx+zmkvv+eA6HpG7Q/By6tgAsK3vVSPLUAuVkjbwzHXVT6nHDWN0ugEzpJ5sSsHSeddU6kXpyfnYv3YDs4qdN37IOx0r7M24laeCWIo/GGfNbw20KWPv2G5usoRzHZ1fRsiL0wxrkxbsGSfuKGCL/QVkz5UyY7potUu6UvgTCpKC7pupV6yqw/1ApPfB8BPOJcZi2SxRKZ2zALQWwHFAhYrFK+XjCCCOQ5sl051rYSakMZdzpRnlyHNpLqvdt6YM58pTlTGCGX35uT1L1uwKaZAz5/VxZG3UditC/n7Rgmdw84X2j85TNykgRQO1QALSA1oXVnNBuL0ooVduOulBlQmcfqiWu4MLBBGD16IoVcGNvk5lNiRfmAp4EATVtADFqzAvy/hK0zgl4k57J9WvpP2fjG2s4slLenXE5GV/cyjzbj7UFYMXVY9GsnrYd04J+Drfrhh0m/Y7uZFxSDdabvzehhaUTGaPqxM+2/XrKAOmKqKbNAXcSCefwkb8XZ88+4KqGEbYiwNr9vMeTcVsRk4tpqhkiNvQn0y7EfXNK2XfPSujVG604jWr1aKts1bMmO+akEeVa++5SPuwhNlCF6WoTxNpCzWojAJaePuq6AIzh1dCotE23VdSpG03/LwzZSgPvzggtxOFHaamCI0fTBBV2VjB981ESCD7V/86xZU2GUwmvnPIA8oQ5H8i9T5MiRFVC+y3qi15/s9CWrxvBFWiHW/LGtBEE7dFJNdmm7NwiTXzYIOiedukkWRbGujJqpy0DjpUphdEUXEkvyGGy367tuV/rWcJg0PyFX8iYR97EUiOOAYB4aDdldWVpPnh40xEJlwxSqR8rZ+GMQcTR6gEQbZqgnKjshbYuNmsVcsMn9JtBXRucLg68fCOXmhlLQBfQzT3zljNlr0644rpOjZ6/JfiYa7QWsNSS1q7mcSU4c1GngqUqImtyQGN/WNM25kG/lCmj3yYGKEkqKzub7qbq/WnIpFEvFc9DpB0lbvOnXKhhR+5fG62oku+mcwnNftEMJgkwZ4gOQzMvIElIIoQbUIpRO8jiDfYdTBIo2kgw1RCFJqqyjTa1sHr2mYgLrRXh1lIq9wVk/kP9CJD7ZdX4c6WLLDGmbWqoiL9WlYcgr5WdNU4i7XqiBJl9Gf4SC8uh3aQB0TdnDbN2Gdk5HRpvVdDyEltZFUjKnXe9IPO/qGLitY9cDvVKgM0OwXLWHadJz04qq5x9tStAq/KEHZcqYtNGAmOIA/TItT+y/lwrCVzEdN6c2VdKuP+wm/ZlGVykzAsoEAfJsB4x6D7+7sBhkV6NkPl5nW8HB8jr9OVrDyDG6ETkwB225k87IyfJMGpLq1sl5N7BEEJzBV9VL+25R4bI9n6K2OnH50DDzGS5sgy1Pr/m1fUd+jzuJVQMuFh6nXyG0hySzlpAq0z2KF8hM+4YYQGVuYjFEssFWvkBFk1V4M79ajd0301sI8VBAzR5nrrasKxYsVrWRLX8ibhQEd17WP+p5E5Lz6Z2YlGM9Tx9MKBPMotYliorbGrAMvQdFSoghln37B+kfeUHHJKsfNbQUt9hslOfO0wc1goiWLFOq2Fry6NNAWv3vpPNu0+VBYw+Z28ZeWYPLJe1EphOX7dktTlRUkNLabz0JVxTvL8UnzfRvIQY/KZs45cAFv4LkjZr5a2pw431ZsMNSwEWYTKAh75t+N9BmgLcPeVLmfHGt7i02eMj2ktOAWvaTcfJnt1otJHDFFY9MDXn7SxcrZs8bug4mhNou7HsI6ENZX/uypzxWWbbRSfh4/fxyM2Xn2k6o1jB8JaHk1O9gVP8qMFjke4tt4KkWXapLjwvc/fupNFUA8Chww2wRy3+jb5nZWrHE1XyzBtVctOjb0Pu1ASKWbEtDuU//e2iQ+XUI7qYTezWfn+O7OU8qlh7wvC7pDq6vTnV1XJpySJVtzuVmGh+Eym+XARXtii6XObPvIT/BQATqDZFwOYdZj+oWgtYVlmqTXbpGJFJtwwhUaRAr9YcBwCF/1ZSWYP+eBnE58bN/kAeeeFrsutqcTXRHNY7iazZogjxy2lqpW4+wLK4cBx40Zi0Ty6VuqkjLBI3h3uUrH+7s+6VYNk+HPYWG1/VIDLJu5nP06aAtcs5T9AdXFt4W6v1mdtOl227omu9fJHYn71UGkijp1f6w6SmxKai9xNSXbQTaWtKdkDsjQ1YIZphenA/3p4ygkAhS5ITuvkIm9NaA/9rJUIZ0SHnPsEiyg6cKcB6+p4zZadyTe9nP0k04GtY8bg2tzz2psx4B2sojTS77lPrXOrmi2YUkac+qXGlqDPAvEVl4awLoIRo8D97AFxdqQQW7+Fw2AKU3Wj8MBtg6QZLBNbKe09eCh8HoiSA68g4NbUSIOlvJ19iQOsz5vSs+MA2ZWHZBqZ+kDiSN1xqWQlZRg33cdrwF6QG4qhmoBNs+pb4d1bVAtsrIyiv7HYfbj+EBsM3e+hPJ8uBu9J8guB7Qtt2aeA6R2q+tYDViOiyS+eQTL1jIJQEfS9KB1WaR8pN0n1C9o3vDXCvxw4eh3XfztJuyzLU5fYBWAtmqIVF2cxmsrB0bpRXl8Cw8OKGrph9qZRXfUq9IYXxzPlqmm50H/owIaCuZB+DHG6UFOUom2tTwNqr/6Sk6TpDBWWcU+vfkwfDFYlKw0s3Scevp8Lf4ERvJm6vVTnLS3eSbc+ZhqdYTZqZ+EiOll2/xMLCRuDkqpa3ZwylL1yQF5y+Imh0jwXWiex+nSxNlMlJQyewh3PUmSlnCfB5a8ogKVW/PfsasxwOYjga4zu8941SX7Ef5EWawjYb5q4M6VKPX9jsXdvL9z+uBgw1hkFgNcNs0YUfIVPowZ1YOKsfHB1iaTkCYSab6fPJoX0nY2HRbEHnO5uFZTrMEF6PfCtvzP4byRNto91IuGzkbBGZgnvXIH4f6pbMiVWm1HJMyGKmE3OJuYl/AB6EBVSaJn0o700zn3qA2eWNr1bK6Os+EHtxHdaKymFTQ5pZC6glUrhaXm9CquvU+kunHMQMYBH/8vBdrNPOySXy7KN/oNhFkx4auM6ddcwXsHbtFJUZtw0xjYAVnjT2Z5RvjSVnHexJqjWc4Uq5/+nVcucz70ux6abT8tDpLVU3feJAVjbsc55L18ImdwkbkxYukjbaoKNo7XwJP/9X48JGiFv56CFqO/Muqe16MoC1lmx4xbpk6IzHalPAOmjAw8lKiirdsAJVTeHTKWehPhqV6olsJkFXGt6VYe42xgv0VCs+g83b4XgekEA7Yn6Z5RWZry1/wGLh41I5qRF8e0Y/NjdvO8OKS+BKeSOw6Gng+iXSzAMun0FGJPvitXHv8cC38vns3yMri4XBKZN9ldEhmOzpDxSannnp0xJEOM2REW/SbJ3yY0JeGnhgRTz/yDly5tCxEvZDTMX9NOu7WUBbEwTqAioLv2enKnny1n5suuzBawcxuwbu/ZgB47ULJACnGymXTaTfYZdiGNaxhmWyX48d5aLhp8sePSC88t4cAJ+BU4BNOxTp/RgaZ6NblCJA5sD0jB/rJnCShQpIBIA6YrhavWXmIDTDkCybD+6RDGZ7TvpR5x8pN439mKB39hiXE+B9k47J2jRV+YBuavi0/CfbyB+w4jL99gHMCOVKAJVahsmMxIgCmNbPTnyTzO2kt1kX2blhMWKs7WJLZcFkqkfUfTTE3k2fJcyclwgiBDLxDHPA+pjLCPHhn8p2l13OnYrcMkXvEbiUOVz9NgWsQX98Mvn2NygpsNkcWB2fTB8ARaFeApPONSQ7iy2tAnDWaVrj6CRd2Dh1nu1x2UiXG1s4ewwmf8DSU42uuQjxvz19GCa0ZonSF6WWKSTp+xYAc44feo80wCXT4uaWhm7wED++97LD5dSDOmCxAdC5+IdG1cEl19z+T1m42C511TXipD1T+tAWZhoUV+pBPW7YADn9grGyNMiLB1S1ur45A18XilqpMRa8PbhY3pl1nfjIFGUbGtuJscDPvWqCLKtvlzNWZ11LW7KpDAmwhZUYxr3xAEwerC0fAHjEgZ1laP/jZbsOXv4dK8+4PxZZwoqpWYTTfIbG/CIcNC6IjbVkknsNo9sxLoaSJ9cHWPpOtI3ceUd3k9HDj8W9mqS5zaxf6SKWOeay/eSkgzRUoUTW3PeYP2DFZNod/Yn1MCcExjVLqa5886EJngTf3++6yfLlKly8VDuyFu5e98lBO8Rl4o39rCSIrgHCGpvawloHsOD+hf91jXiXLTIdd5xwLyt9Mel05qPSUHwAtIeaRjnyll9DmwLW2Kc+Tt4180OWN9Ib0TXywbShTGalxCf8xrQPMmCD5UKYkdPdLbXl+0q7024VB2xd9e61Aj1XtuiXAJbyVBIUjd71x5MNhQAKlRlai6bxtp+WheTt9z+TD/7zIy5WRz6rWlDrt7Cs2AiF0PFlsnDy1QRQVSlA+7rlsLCcUQkignbc4Puk1tkR85msYQbKKYVANypKU8TFVslz9/eVBd8m5OK/vmDmT60Y5a41Da24Z2OT9fMgN/3UvX1khxILBFvS9tJgtYdA0xOvfiy3TfyMuaejULZAs6nVU9lpK8OlJRglWKl671HiQPq3nXo63ZAeyn4c9N8796Q95LyzjpQKMMCv7dy1O1FLiYMW1rKS2LUcR820SS99J/dO/zCd4pJhYambpIC+YGJ/LKWYHHH+w7SMQw4o24Ar6HUsljcn/NZwssK4YhniIev8dr6A1aNTQmbcRSkQB1aMLuZqYdkaa1+1mavJqJPMWFPnkZMveIzXy/rLEWBwcij9a/wF0hlAUFeW12CqDTY7YGlH9hVvSPzFawzJW8vT7BxiNTsdJyVH3SFOr3L2sh8abQpYi1clkmde9gRWFZIb4R/k30+NRuD+OxHqlAIaQAYItG5QgSLgKpcOp2LSdj3dSIaoJImRzMjFI8qzNEfPTCeTGPJg8vN3nJ1gi1ibXivPtQuwkcDhhPB6yiXcUC1eH+5MCyRONQIdbML3p1EawWcbANsiNqkp8s0ykkijLP7BLn2unYnCBO4Vm17lc5oPdZFxCJkDv4y5eF/pc2APWclnTxz4CMH0CqMV1tx9s6xV4kecrrrTdipaK3MeGAlYKdiu31rQ4Ggx01xJp6Ij+mO12EqyBpoVRJWr5DanvtYRktimjlNpBjQcNk1tY9pqjc2eJI4RoeQn7iwizLVaOjrXylnH7SmXn3+qcYkabS6F0+xAwk9dgKrGZpKUe/Qa9KBUSyeLh5Ia6wAW1inu9KIJZ0iZ1yW/+cPT8tXS7N+jLrUH93vuvedD2WggKaTfmz15kj9gcTjc3M80WNWmnfqdauHq0OLjn5avkQnPfCXvfvyd/IRggF+7SuWYnnJPQP758AhiXSSJyNpq3NDUe25iHtY6L03rV6M/SGTyOdQGk/FOrqRAuot8V8JaHPQcSxDOYw6rtU0Bqy4STx42bDJpTq90CC2Tl2deLK7V8yX6/B/JHBC4JaPhIqYV5lTRdG7psOcllKee0C+xsHLujhwfsGq51L6xy7bFK2XGA5dKsSoBmFo0q7O0VWeXBj+NoGH9uwNdrX5Xz5LP15RStlTJkQi1IlOdwVhqSigMy7uPDwf4o1JGvG3fYdRWqiQ0wc5sa1lld14fP1zKbDXcGvr5pMgjGfV2KopoR6Im7KmUyXOWyn2zvgCAuUdT/a9Fths6W+v+vhNA791rZ7mk/5HSjnUdw+KyqyljOHnauVM149Nd8BgbuwizchmxpV8PmQ6SqAZ5tnCBXY7Z1y33X3UG6ysoyytRdLh0ikQJsBcTn9RAf2ZQ3Qsy1PL9V/XdTy45fTcOHXhDOfh3eQFWjqlsURU0g3ir0kZhkjVBDo1yWS7zpl+JWgd8PuKymkk2/LHNQBxd53Eg8HqJxf44/jQpRzqqiIRWNR13ium44xz8DCKe29PpmlCQEmRbGG0KWIFILHksLk+VvbO0C66R12deKPLTq5J8+W8GsFRCxYNLFgCZY7yA8iFzYJjnVwTbFoBleNBq/hKX69erq1wz9NfsHayMxiJgdWPjmXQMYylq3MpyLVXTq9fgeyjF6crSgm+GG2e5f03D1AhrN97ESlk49WpchxgnfkBumvmpTHnxG8PjyQZYyql64LoT5bBdyrk/0uVqpWS4nZqNc0ZL+P5aCRBTueCqZ+U/q6skWoRbF4W4qF4Y8bKNOWJh4m9Iwvi9ywz3ydcAPcIUIqbQcV3+k/KynDGv3DblbZn68ioQXwGt5afXeRt/81lyYBefBGjQK/YK6CkII5a0g+dlPU9KfSL1bE4sxzCXLE5+J29MuZb5qgNIsyctNiZgtSiNnQFYUd6hjWSWWvIP/vUE2X8Xv7LXDLhatZhtA1hJja2E6Xc4a5Dp1F6CMRIAxJzEo6v3HCU/FB8l++y9hx6DZsotucL0d9imgBWmkeoz85bInye/I8V1VbJg1ijaP89FluAvBrDckNx8BFFDuAwRzzbi7UchZQ4aQ+bGaQvAUja0bogIBNQEBbgOsp1TbhkoPbuXwOHB6tHsT2ZGSnu6mZgc1gSm8aIvquWSW55kI8GzwXIKMx+Z7odhA/D/hp+4nVwx+FADWGigyhqs0NOHPw5nScG95U2rv9/NVyXPPTjaxNY022QlMpqGZpWUDW/0vrDkQgR7R147Xd7/3k2VkGrjq9RwbkJrXoAGeEdR10hSflPWUC9znxxluE96a0kD2haNo/lQayfOvR0z8EEJuukIbky/9ZM69ScuLLSFU4eQrEiglaZkUJ/0vuwx+bYeqgxWgIljZliPpsmocZ/r5cVxI2Rbj0oFZY9FbkzAanEOmwFWLEZ0isPdLYtlxkOjpaufjCLzmVSNpZ9H2wCWkZRhLQWfv0hsaz+RIoyRqJEeSpJIo4rjLPqMlpcg70XJkdaNEjbREEbz0aaAFWqoT9aGi+SQS55AbYHSgWnnpwMWATg/pLOAvYRW8ruK8+wJqJDmp1rYNoBlTbEpPGUBubB0fJ6E/PXCg+XEA7czGcJMLSZjPRjJY14qQek+xPa+QrEiGSbzhbXW4K3H4kwPSKbA5V93nS3dOqhED0FtU+dYIkf0fQCgR/sqS4Bc6zRLbFUEkUcBkpo9srSV0oZuXOrBTCmHZhex4BKkyaf861O5d9ongHKFKR/auEOL6FSBFDCJLJOuZS6Z+8goCrY1VsgCVis0I3apGmHV0aScOHwGhxvPAhu+JcBSK6MMXbTXHjkZTSdqGsm++iMumf3+f+Uvjyi9wVIPySx5IQZuusaEEZk8/aByue3CIw0FJtvY3IClVtSV5/WUgaccwgFHHR8xzaiWv6UV27cVYHEgooXlWXS91C1+BWOEvaz1ohzsHthttYPnGiuwHSVd+u4iZOu10fIWA1gN4bqkM1oshw65kZvrKh9BqrSv/kRsz/eDVY0EMFwiO76uWiqR7c+QkmPhMLUilZxuIeSvh6XxpTAcIs63vrsAACAASURBVE8QwiEnk3WqNo24lhAgf6xqjQLDXdvb68RbJSYau1qXAa0BVHFVy6v3jJIKaiZdqC80H+qO1RLQrQh5Jchm2q/vNHPKZBtxYjTO6Cr594zR5ru13iwOi9nGyXTBdU/LR0uU49RykMloywOqYy46Ws4+2E/8AGuOOs2sw2iDq9KoCijaZPrLX8p9k+dLHbs5TgG6grRmWN0E2x3EnjQkptJAFm3BikERKcsP37jPW67qJWfuiww2rrLV5SjdcnRjxV58z4fyxr/R8VdJG20J14zgqqU0GrODAWToMn8dfbD0PnS79PdKycvBw2YJzTIBIqUVpN9mjA0Uc1VSFN/O6M+/Musi4qxWJlZpOGqJZnZx2iyAlTGbETLue23rlwevHyKdS6g7JFZkM+p6NDHROlmHNhYu2+xBd81Qh0kQyWd3ieP9p9g78LK0FwMHIUQicQ5/Vh5/ISYXnIS+MImscrhAoQyXu00trEgDbb6IkSym7XXfkRPlw6nnixtZ1fBMAqGAlNMQSlG8pLrb3rOvuA65jM2Q31r/JRaWqsAniNmcst+2zGetkXRpPkL1NJFcuUrW1FBOgM5SAndCm7NaYlyWavu6WTcFD6d0j/8oz02/CjBOPznUugmh6OhHvP+Z976U6x7+0JSLZBsOyKe7dYjKpH+cBUVAm8MSoMbCUtmOD5fEZeRfn1vXYsq4YDgSl208a+XVJy6ms4tLwsSPsg/r2ZSQqYkQtUaSgG8tbuw9E+bLC69+xON30Nyl4ZvFMfn91JJp4bUmGzRYrqdsfoNrBH+Q+dOvwcrCNTQWavrcqIV16MC7KT3qZgGWAmMzwNK5p7CHt+OBQlMjc6deJBUZ1noEq+2YYY9A0u0ABinJNmOxqU6XE+Ir9Ac3lRDT7h8su5Srpqm60hovXFervy0AywVHMIpl4nCskZHn7CsjemNtoYllGnoAGCofbceC3NxZQlMvqAKcn90mjvfmkCmmiN2sWdxW1EPcI5+XI9B/nz/jarwDYoUcBpGMQ7tNAStWj2IOVkeUOE2vAXfInIeuYvNUSe20k4ygvkcBi6WvgOXYAzLdwZeSrs8PsX4JYClh0xmvlkXTRuGGUcqSIZQXo7YwwakQRUVBufin9L2frFx7NqhaTVrISRPXDGVJratKwuNxQ/CcN2MA/nu61aaSH+pyqdX066H3STUk2VwSNCpBMvavJ8u+PfxwpZRdTgQLcp4TNzriKZND+hJEZoOm1DAyQUI3vdbDuSgyf2v6hVhD5MBy8GAsoq5+k4KPEhj1mVVvilo9LCfVwwrCMP9icYPcdO90WboCsUBvJ6w31QyAN0bg1UXGan3Fxi2CGHPiZQP+cwJt31BqiAIOmVC+EmWFk4Y/xiVUM12b7qaLOSpg6T0qsJSgbz9vMhlpE/NrGlrfOebB1+hyQ1bWsMHTY2DK29K4liWBEpNDe3jlwb+cgjVJ6UmcRsCAqVI3mo+2ACwVutQyqjCE03JqKa8Z0kv6nLAdyiaaJChlP6HyC1l7cwOWegHa+Nj24d8k+eHLZCwtXbcoh62fwLur/xTpddXr8vy4yy1FYSgjmSVYbQpYwUAEdZgIm9clr31ZKbaGBjli322kftrx+NxBzG1MbTaBSrIme/QW7xG/ZZPkJ/iVP2ARB6Jpgwrsvz1jiNFgitjSLSz1AJ26OSEP2qnr+ilE+QybhWZLyK8AAGyETCVFQ9ZTN4MOLrcO301OOnTntIUdcSLfH8KPp4/hMYNnEQhWpnr2Z02i4Pjp7AuhhdRzn1Ztm7rPPty2Burtjhk5hXZLbNQWXEuFuJgSNdmEI3rtKJecfwBgl2N+TRbTcoOsuFvjptfatEZGNurzBni1TsHtpW8hj/3m+9/J+OmvyMrqOHLFZSa9nosSkJogA6xYZzdceZT02a8UeWcFpXQwOY3u4T/RDwBil9p/6wCWvjGcU6OwcPph28tto/cltpPulsdIkPxY6ZYzf/ckhwcbWtuzNxtWXV9jDR5g7Q9H5fUZI6DtVuNGVhALU7me9CD8LwGslizrfBr3msSPBrkBAxdVG69Pvgj6CtlW1omReOGg2fyApQKc6JS9drGUfYOSMORobUEWYS2URtn/Zz0mAx/+Ue657jzj0yRIaBjd+WajbQErGDRGt0MZ29z0H2+bLX+/orcsn9JHuiWWsDDdmIVBmi9Qblq+p3j7jIfxvemD7gncKhfB7rdm9qNmULNj6VadpaWufol2EiHTQVbmqH4Po3ndnWdB7J/SkMwaR638dwIiERbLiT2L5O7f05Ci2YirYipCZ4+8vFrumfVvmoqqyFp28HDTGKHPb/bVzq2NhEzrgiZ5yJ+PvsX6/uKbRu5N+smv/2XcJsBNOWO+SAOmOJYfsTS1TjSgr2n9ItzdsDbcJI7ngjaQanOwPqKp1Y1GazG5Hza2VgAknUgEETuxfs9w72VVTUQu+O0D8n1yZ6YwZJEkszyrAqoePKfs305uu/xIbFjiHY2SKtpuVav8Dxw4Oes1jHwf36NUkxOP2lsqinivGVwuNd5VdWP2Sx8bZVsH2mHrjtTsmloLeWLMWXLETqTnkf7xkPQwbPtmIy/AYjd0KbfJ70YeCaMeIUmlkvGc6szWwqFaXhWQGU/Ok8oQSSh7GZr1EdacKotmvg3LCrYaUmg+1SE3XXOCnLQPoZWoZtyrYH1AAN7MxFHKrunBUCzOWafCCtD2Y6uworxQGzTkThPeU8fKn56tkhOPP1qO25GYLtaglnNtUYClN5Pih3y3KiA9OtLqetHt4vvqSTrj+KSErEzQWSxBf3dxnjPDFJ7mM/K3sDRu3gRYHgNY6d9oldZg/cEYdnCiNpC9OnbIA5AKO5HR0zgJfRZNFKdpKAtbN3yUvw+hKcD4f/RJ+7nqWOmGOWbQw6hU7MKkqDJD9hhWgAXt9/AZAEv13VNahqkTWpue6v9uyZIxPBfdtEpoxSR/c+YoKUP3Wy0JBQmz2DnhPlqMq+hXLSx16rLrP2ncaPvOFTCwqQujE5LKMmfq7MdUn59FeuLwR2R1EAVRc2xlSw5o/WMSbXWfPPynkwAsbV5gtetSG+nz5Q3S7/cvZV0WqeSDcnxUwVO5r6GM6ALbGddVFWQBW/632ojZRow539G/Qp5+YAR1nspjUxZ/etYwX8DapWOM4uf+HEC0g4MuYpXmAPxatUCoQguhl9fH5TdXUHUQoZSI95NLS1UpGl2Kl8oLj1zBoamUEZUq2vwxLC+hgHoPXsQjx8BlU41/6mNxTQOEUooQO7Cf+pjc+Eq9VNVUyO0X9YDaVNJYMdH0Ftrcwmq+IDQgWqS1hA2L0cMajZYRkhRk4xp4UXGad/r60yYIEzefseGApe5F+ibV4mgnvCAPrdXDuCq1xLKO7v8gAWbamrPbtZwl0534GbBYeAd2SciEm/umPYYb4Pgu4JOzR03CHcQgxqrJ3OjrPrd1fqo8iwJFpjdnaTW1HPNTUDKBcDaBCznhQ3ZyykPX9QM4AyY+pTLFIeKIpw65VyodPTDPG0xZR3MV2Mx7UlXP0YP3kCG/QU2UNluJpFqb6YH8BmIp5bzHmejE3zjhQ+KS2bvR6H0qv+i4PdzyIJpUKP5bvDDmLAZX6/jz75SaZPccy8ICRaPXZTKVVuuztPUHN06tEiXoGmDOUfal4OGJr5E3pl8MW7va0D1AmLRr5g1YnbT4eUBj8bOl1qBy0Gqxmz6TenrCX3r567D87tYFptms5ae0DPhx1mSp7QcakPzOELGV+2RXd2szW1guQ5wmRj2pH89DvE8TA1q8jwinhySG54wn5IbXG+RZhAnfR3hAe2S5M0qftijA0hPTCzcjzAPEx/XCfbJRbqHEUVKzrNp2F/xTQmRA8hkbAliLZvQlNqTdmjOsChamdn6JaqC72CfnnD9OVqhIHCYObrmhRGRqLzVZWDHpBfP4/j+dmvYYDnho103/TJ6bu9JqhaUKpTn6J6rIn24qY/gbWkW6KajPni1FkbIUlcwXd9MYo57O0rNGGsUMh+rUs1HinIK/vftVee0TTdtzfa0VzGb5cZoXEcN6acJoYEWD340NRJo9rY0MI3cr1z74urz+sbqMORpbaPaNtfDbAXvK0OO7ER+DfqHyK1jbQTKOhw+biOXR2goIi1Cq/39dwEpt/MZZaybPvf41x5HAOnjiHwM5hJBh9tJvICP7mz9g0ScQwGouL6NqDak5N4619uXkXR85bLpp/26qmbMMXQde6C8Lp11B8qLWAL4eZpsbsNTH9TZ8JsEnr0KeGyFGeIV6OATdAD8hCSWG/3bKF/LSvGr5CA3/OAaBQ6v4m40tCrCU2epHPrfWVi5104dKp8AXnAZarInmI5NeqlYMHZ4TNHBUspmmr3OpHvwSwNJ4kxY+j7vzAvHr6Z6R+akLJeTzz76S5/65SFbV6tlHJEWLpPWcM6UqCiQZhEKC1Wpp1MEj+uNpO8vI3vtbp31KZpf3csSgx7AmCRxT6qLyIZn8r/WvycasnQmGp5+ymRbaOkBjwjEWR0qzlCpV8xyaWj2KCIxzxruxIuvQMA4RZzjuslkSI9fsoQQmW/2gWgCadKjwrpV/or/kI2YUR/tIh7qn+qeaYvJ/fxuXy65/2uhKpUoxWtpzGktzoFbx3P39pVs51hj8Hbe2e8MSfOmTn+RP935kLLDcQzd20yxk1nNa89UckLMDgVqnEeJnFQm0psZdRLIGt58SquYjX8DatRN6WMjLUBZumP5xJweFxtLMQWENDUZr6dEBvR+TaDEJjEyyb8ZExFmURVBd5k4ZjCWIIoLRUd/0An5pNZ8E+YNqzb93qxT/Z7aRxlYqj9JRNAYX8sNB7P2C9LnhJfl8qU3eQ84ZfWGePX0fbVGApTcPXxl9p3ZSUvWGRJ65kgydkt20rRdCctufJEVHX0tchReJWWvaeuVoRvBLAEvT1naVtVFpGQ0RZTZYhpJgKuk1OG1S3NZGyDbUfXEBCGGXR16Bmb5NmeWupSiV39Uk5NxLn+S5lCKgmpzEGHLIhmTqsWcKgWa6pbmC+Hr/e3QNyOx/DIG4axEthfS4DV9zv6FQJJzbYEFY3JmWB4tQvRbejgcKR5eipBxy8K6y/fZdOGBj8sknX8oXn64g7ldsQFFdSMu+atml0QSAE4lf1SdzKVnWuKxku/j9E0feI2uCcK9y6bw0znRuUGv+iRzxOsPG9gMGa1CSvZBngTaQ4UbmC1i7AFiqh6WApWz/+Hr0sMzag9B8eJ8pEi7BsozkaMTCAernHc6dPtC0bNNschLLdJNbWDoXpnpDs8ocgBzE30zsKztEl5DNtta5yWrzqCtoA7Rt/7nSa/QUWUn1y9sAlot3Ts497ZVtUYCl/myCIGKYmFBpYpksmzqQv5XwRk0R5mQNMaIO/cZJ0LutyfZY7aE2ftccnSGrgFmVEIgREUdLX8baieLnT7Ui1qRWF9uLImIPLUnnTxnO4cNpTPGnuiUaExt98yuy6P8aTDsz1bXWBp5ZdafUFshwAVsCLA1qK+Cn4DHbpvVTCLzgidEGLLV1PIQSE+y95PY58jpuoaXP3jJkGdjhvlQC1wYnTN1WlQNKJQKMlaVSxzZadbl4VjKnOoGZcs7p96jNGaLy5H0opLLhPKgpxL1hqSU8cPSgsdATyskyZw+Qax9LlSnSkYuQm/puq64ze69nK4cXkr+MOkp+c2S3jB4EIpsCsHTxxbGwDu8zWQL+lrKZTTOoWW4/8eC50/pBTNZ9oxnozcHDasxW6qHPWvfjMa2Z8wfkimDamzpBejKoZA+6+T+VVMi2fV+QAwY+DIG6A/0UzpMirbvNoIlsUYCl5SkR/HEXqeUELbZDn0+R+EfT8XXrON1VPwcxOLSOalz7UekdgPagwciN34RCa9Ual7Yub6PJ1XxYfdTY/txPKkqU3eqw0vLqKp13FOoNww/nwOE5la9FfCJMr8HD+j6K1DHyG5j/GkSPQn/IpkpqQCjj2dcBrMZ/SPGwrP2aPfOoHXcm3XiS7NsFCgagqWllPRjCNKI44rx7+btjViPFig1ZAjsqTaNApFmq5kMJljaNhymnyVgk2S1UJeI++0Af6erl6j5Vj0CeOtkgjz//ldz/7HeNBbI53gCgaOoQ8wAsrXjINvQbdUsql8gZ/hY35ne4hOnrcVMAlk2tS5I3R/Sh7wE6ZeunXzTdeUIBCzdBAUtjwmrta351k1tYuta0+TGHjIO4bvilMeJYPpdDj3gvc2vUQchYuuh3ubxjTyn/zQQ5YcR0qaSu890pvcm1Y0lnWKxbFGCpyFsMwNJ4hTLdnfZKWf34COmEWmeVqwJOEGUyO+AW9voHwcM6w0VRPzfb0IyQk+sG2SRH950NKBADydXiXUl1ZqNZXJaIM30zmIwN/2RoA8Y1TDFemu7EnMu6IY2FgmgesZpS2xKZN+EqXCUIp0YuBasLFv/naxPS/3KE+siLu8jKKc9Lm7mmx1K14SjWCgHyPXZwy47dkVqmyWhzCMoELAUntVrrsRAXfbjGdLDJBVhCjeCOxZQP3TPUlEyo6oFKGMdZ8DPf+EZuRVlDO207NMVumVNp06+Jkyinv7KU7RoQNin59Hek7rYSM9WCTNCHzwK0xjnkmhrcV5DU9lUqB7xNcVKef6gPVnUR4K7Bf+VUOenVeJvUeHdjtmjFlgGKem/63lUWWiHEQ/jg6IN3JAZn0WjUNm8Ruht/MP/db+hOQ0bS/LfV3KL5sOR9VEtem5askgUTLkGPjHfCRxNYfEoivWH8Qpm16EfOQHTsobxkVkCkXzAprXEJtT+Azs3hVDIEvOyBHKJk+mP6bMDu789BHzZqtOq6bnrASun1J8TrJDZNpYI/8RMMfNxY9o72KIi6ajiD/BI4/BJx7jNUfnXe47zadrJw4lnE26D2ZLACtijAygSeECvC+x8Cix88YRjKWim/Am7WdgNfQI4CwTmCJbmaSCpZUd2sILv/6P7jSaGWm62xaYeCi3J9VLRPU90+XlhQXhjbXzpgWZnmTWxkDdLaIf+d87vp8m01XZWz3Ja6f1rY7Ir6WHiY9sSS3I09GVviWWkVgbapqkWa5pj+s3h2lcfN7kLbaOzhCK8irax9IQENU9JCppagdgjQvfKm5+XdT5aJp6gDbokCt4JPDrnnHJOtJS/68AqoVtGyVZunZT9F4W/khYmjpSMVBc1HBB2lXkMm0vNOuV7r9iAyjQ5g+Qf4WQLXtEcxsblHR4nbdB9WJdR1pUsyb3PK/MVy+7hPTYG4Sv9ovDJ97eiG1DUI8ZbZ6XfywXJl3x5UGtj4Xt4V7u6YJxbIrIUAFmtAAUvVWFscPHerAIv7UKmWQ867hXe6K81KsnMTNUjvgR7x6riB0onGJgF7saX3v4lpDabNFzOTQIIo+s4D4v4/KgiaZdztJBVi7As3Hotn0AvsAZ+c9oeZkqgtkjdZ4+VKWLZOi5/HFg1YBDpYDJWyhDbXPcNf04SiK5bVGrHtNkACR14n5fB5wjl4WW0BWBYzW7V/iG9QDmG318rLYy+UTj6sCgLRUTJJlmWYkKpIKTVwKIRiLeYCUt3MxfB+5mr2zY1pr0oBaim0UCRtxfhwW3Htzhj1sHwfaKcppqzwoWRIPxbhzVcfLsftTfG3blbtEgMwqVSvA6by6L9MlPd/sILeKgLYvMj4lxwEjc3ZDe9L4VzJl0pZKI1Vojt1mXTwrcLCQ0a72Rgzdq78831S9OxVq81ZJqcKq4q4ZxDFDw8W8t8vOkROOLgDnXwsC9YkVloghqYOgLDHK0cPmGRq8lRhIhOwNLupz67vMxIKSAlKF3Mnny9lWP8x7bGHJTjm8U0BWNrENSbHnX+/rEnsjLVkZWFbGno4Jmip9TJZwu7mXZaaTPamBizl7KmOv9+1SqoePcdo56cPTaCEZJV3Z+nW/wkZ+qdZ8t5q6niJUc59oi+qpCTVMuIiWzRguVkM9chLFFUtkPoX/sZmx3ykiLbe5ZN2g2fDHaKQM5orztAGFpbGCNhJ7eydZLftonLbLedIub4sGOnqZOrpqG6Rujvzl9jk8htpp46RkA2wjMVGpf3BO1bJI38ZzrMToM9MX2YsB3UHGyCE+gOkiX+okZE3zGsUwMtyyGtGDneuXelaeeVBdLK4zziLRsHP6LI70TLHTXruzSVy9zgyucgARbC+NE6WT61b8zvQWBcNKY0r5WBDubiHHt2j8sitA1GmJDysLdIas4AKJgrQBw8ZB5enCxanWj6WRdt8qNaXC52NEPGuEketvDH1QvSXdGOnIk+WVZdtRHn2o7HiAnS8NkTVVElWs1+yrqKRTI1nxuRfjw9C2K9GwiRYHGy468e/tdEtLHMIoTxx7f2L5MWP1EXObmFp6kP7T1498ljpc0gHLBrlx236GFaS9emxrZYlz/1ZOq1ZxMvVBiZNQ5UYSpjj6gMvFs/eQ+TIQRPo3UA2EX7W/CmacFMKTfo72qIBS2gJry6Vk9hNzVt3iOcbWjEldiL+s1wayk8Vz9l/Jh6Eqa2bynThXTcyYVlYkNPwhI6hiUKQWFiu7FtuK0GDiemr1sS7dHK1Ewj3c1qv3eXKkQfRwLIKkEVcX3XpdeNp3AY3Rd0ova8TLx8vS+sqOH1yfStPQjnF2BuPkIO6dZQomlpaZpFtuFgwNb6QlDewdb1O5FemG9e6aawn2M0zaLzFRkOIdx8faWI/2vbdaGAxvVFqPt0kPOIEsKvcJfK7m/8lH0FTsFFqo4xqK0qWyQlLmfWp70v9t/W3UTXV8iBIw8VFQXnopqGy5zYIvRGU1baCMQDHDhdMJz3GgaWa3/uh2x4l3lYEV8zIpmTUBcbZkE4oMgk6MhXFv5d5U3/HezAcVSsWmD2KZe7LhQs+5O/z5cOvUw1s00HO4tApXFkMeY3L/HrvCrnr97/mAKJnJpUBN4x/R55c+IMJC2i51joCiWnInRTlYTUx3VugNfBt2vL9w+U2GfKHV0xGN9uwa9IEK6sYOsjjY06mPyQSL0hQG/UK5nf6vJ/ktknv51hL0IooPyriZNUkw4dT+1OXuD6gTC1k3h0Gh2vlfEm89lfT5k5VOpofy0EsaT+Hqvf86bIyuh29JJ+mZAsXkeWzYKo2HFarfgusJWxpprRJpZ6SEXupFMfWwOE4Xzraq4wZGeJELj7l7xLv0kvcCJQFUEFwk1XIXBC6nLQMIEHs68aHiH1FM+MQuYBi3Z+7iUNpl+AidM39fqy9inLp1KFE9txlGzqwEGxlozm1vo8TpKX4kpNrqDbQmLtmwDtTd9DYCS3ejJ7gbnhhY678jWFTG+WATAZ+xm9rnaO23AoBLkniFrc8OBt9/OYgp5m69ECy1bMOlzVeI8POPUJ2644bmWUoeMTgbE174T/y6Iw3TOZWOT6YRFg32CRF6C+Fa41mvCl7IQ7pgPSp3aGdxNYiyPdUkEE67vDd5LKRJ0gZIvE2PaiaBZLV7dIDQWNmGhN58V/vyFvfrEm/q4zYkFJDYlikhK/kVz3L5ewT98cSyc6rynxMF3P1yQ9VMumZtyx31QhxZTlZuE8nYH7TNecQm0SxgiL4OXPfl3e+WE6gW4UHOa6M+7q+oTElJKvLsLgHA3hkZ1tS2dA1romfBmJ8f7r9aXHTODfb2rF0vVRuJylDzjpY9txWm2yoRA/0GXiO7336ncyZ/3/ZQU/nX7OTWNPlvIc/XHI2llqmEIEmOTSmaZEXfckVsmTieXTMpoQK11APcivmZ0n3uLnWii6H05fwXnn4ibflznnf0qeymN+rlLemEm9kXzdmPH6+ty3awkqQSXIDWJptosUA8auv5KeJF0sJImohNkQRwFU84ilZ49pZSkMUHa+n0NZqHmptyhBaShp0zuVKtfTmUlwhzewpEDkaC1313I0gR2M3Er5wjvTfcWVT7sv6rqfXUIssEoGPZATntFNzy5QDMFCSbm2VxYKgDCimhNqMAuvM79EslQKWSjlE6IijXqkqgTYN3YDpp7PpW6jJAO1fB7gncrRBdyiXTC8I7STM/esZGgacvl9SJ68t+lB+WENR9Uc1qF4mpELJjntsI922L5Ejj9hfdujukyIAyq3SzFG1Opk7LbnhmEo2Y4xbgEXciWxjhOf3+4slFsg43TNkmjXRojIqKp+jqygBcTKZZ69DD52JpcgnQRIjjp8Pw5YVNBRjA5BjUe5Hd0oz3gBUGGnrkvb0XoiYAydTdij1LlQ+x3DFeCVOioG1w40L92h9Q79H42NOUp5hG0kE3OZsccRGO9a49m6sZzvJiAjqtlpRoVElG4e5A5JmtqHa6mpZ2d1ISgMkqrChVmzzoXSWMAF0FxadO1orPzw5QjrUfEuRsxf3ndpYrDy9ToqKZCfO5z5vLCVNe8ieg8eZhh5RLOJimqq8OXk098pqypjuLRqwNH2tiK097jR1XM+Gbb/2Hal/+kqj8RN0lspa1070NHuA09RnuYUZm950zlUXxzRk0LfTmhKOrO+OzcRmaVYQbbV/b4xlNBINVV0x21C+md6rgqmle5WdH2UsIX02jY9p5svUGmaP31nEUtUeWbdsx7o3iwvVfJgcpulnyLV1geXQ0LckY9QdtvoIKiXBjR+ntxrDZdPC3AOHzcZaiEj34hXy1EMwwlXwBAByUHupi1zZ3MoVMtdSbptSRjJ8butZeI6fLZyM+TU0iWaDzyeIh2nsLYmlpWU0+WrPK+XCyvLC99NiYX2n2V6Tyg2hVCskCIybqmVMUDHMsuPerSB/rphr6n21vHoUuLUZre4Ps9xzrWldn8pDQ2nU1FHqs2ggXmOHGhtV6krm/GV8vc6fRd/Ra+mXpp6n6YP6atQ694eXyNLXx0nHVXPgULrYp5ZWm3bWVtEAVcuI0VhmqW072anfI/LOtxE5/x8vi5/7auBe2ieWywJak9n0hN2aXEIPLYpFQAAAIABJREFUCFsHYVF9Wg81UJqWj/Gi3D++TCuwa4mn+DCzEavrdoL4Tr6xkUCYnrbXSncFLc06KYdJ+Tq5snHZ4UqbS6x/1SprXf8Y8MohNOhms2rsRoPJWutlFBey7AaLiKlpdFVLUA5LVoOscZNYcRXrmRVQLSBpGroB010UpRbYseDsGhPCIk2gkpp1qMyOAUUAi/lVe0YldEwKH9nkCKB6yNCp/G+v7NJBpVP6YT/xLrCG1S00ek98psnT0gC/3mvzGzV1B/xjozIFP13HUsnYtPpzvaY5OLC+rErP/JQ+lIJgdQuyiMSmB2S2yTCEWWtz6ucUUKwiYxO5tFL0OWglrepZYNa0lk0pL0/BNLura4ii5qzDdVRStAKeZvC0ikMTKVrTZ9qitTys0IquU+tzWnplxfBSQ9+b1Vm8csEj0uG7GRLGGlaPpsETFB/lNuoBaThHVS3qXO2kc987JRDeQY6g/2YCfayIg76EcK/2JI436+4BlHKxjrYmCytz+nTxqFmqp3/y6ycl9s69jdXxxHR2Hybug0eZF+PQYjY1WU1wWxdpDuslF0IVft7qGTBUCrWSACEFYnRr5MBB042rk2oia8eNpJe3nNlrV/nrqGMMaLkb2AA0MY2yCV2U7rQc62n1rRQ+uAlnILWjgCTroFWLlsxllOSYLH6BHaqyOBkuo7r7eEJOyrICe46UksMHyH9XVMh5l1NDi/dkSVh3kZFnlctVp+9jLLMMzrZs0S5h5nxb5yw+MhaXK0rb7TWfS9W830t7BM0C5cQHdr1a/PsN4eEJ8iraRyCJGpZ1fsHWTfie/+cvbQEWp7ESXdUFIuZxANlJglTGddTgexyrgMAGKcdaqAbQJ2guUUZgHt08Exdxqupptrqk//lZ3AoesNHNjFFBohUFnmhCahbdI/Gl8yn/WWv2aea+UzpPCbHKr4v2kR5UKQS9XeSUAffKyvg2VAZo7SoWVaQYxZBTEUYkmqkUwIwg1tYFWIYJTXZJTVgWdpQsTknVF/L9C6OkG6l7u2eVrMLS6rLvEAoou7Ixqo2yZcHC2nwbwGTSDGAx62QB46gZHDhwmmnMEVEg8qAiCVCpy5xQFw8Q27FTncy8eziuCUFgzewRfM+Uftl8T1D4ptbMgA3vJYqCrgdqjSv2oyx+7QbpsvYjLCvluqlOiPaFTHczbfQeiGBElA97UOqL95c5byyTWx99gxI79/9r70rAdCzb9jnv/s6+MMZYo5RIsjQU0YJSSsowtjSytaBdyx+f+g99bShpkd0MY0l9UkRahCI7RQjDmDFjVrO9+39e9zOTmfliDKp/9Dwdc8h432e5n/u+7ms5r/NkpMyKI0Nwe2Ex1i99gE4Jyf2Yv6rIplqtDFZp7klwQSpbIIyFzHGZHCn4mbJNDZ1pKj5PDrkBTfu+zGoGq0l6OHgu8++ifUYzWJJrkj5BVoaIe3Pxd4Izk3cx6aMNSFh9WL0/1RFAk2VjHnL17AdUK4bwY/lJ5auS5PRFu2H9ROc5AswnU6Al0HoMB2c8g8s8aYqzTjjtVb5M5U7Ln9rFtenX+nkENL8TeSyY3dRnMlM8bKZnHUKqwx6Gi2GuHGLm7qOHHcR5wQ2sHAyHve92ChaWOf7SZE8RRSjOc7R+/5okq0WV2EwStWObExD+G/uVGF5k2K5C/T7vckevBWceS8tWlqfJXKpqUQpGIGlQScJX3lN2ofd4SX+fu6JU+ShszVCOAgcUgfWxJG9i47SbfPjSJF3MRmABuRrpdjm5A7cZkEgOdDIulPSCWji5vyNtbjDpc52KDVPfZv7uOWMWrCPJMyWKUVTGKqTX2rwcCuRLmMZvn8GxcQqblzP4WTaJV6joCWbOTgm5U9ZQisnkYn/dzmh+4ys4SR2CB56Yj98yo1lJFnk4vm8FcTOgX5covDCwDa/B9iGK1hrd4qmdPqq9wRLMkABMxTX1pwfqLNiD1I/Hoo5zPzLJ3mnr8iJsDTtQ0CKcKF2t50rhSX7vgSth7Py7Z0g1vb5AM6TCZGS4V8xG6zU796FL+6bwEHflT/yXj6o4BhoqA+ER0kjt5c56be+ZivHBTAkwRdNMTNv3iWTD9JxSIqsaB/yZ8U7VdKiq1W07CCMSzjkLf9RB7+kU27AMzDMF5W3DyeVvIMR1jO9XmNdNXE3EclXABUq3qVAUBZGW+UDITWh8B6XwgnKRsDIPb87/VuHAjKKPKAZQQLesHq+aQ6ZhetjCbgJ2Coia9iVlsKTr3EN8iZRdjcRbmbgbEPqI3B2Uwt42nT18p5AWeC2i7xtPlks28wr7ABeIQhEzbNF60P5Sx7JaTdzKblbKIIJ/k3J2IQGIHftNpTsfwF25CAFsbWnf9lo0jCY5W/1g5DvcmDF/A1VfGAMoyAD/I7jSRE26rxMfIxcYoRBCmUsvTOvb04+/bQRUfpFrieukiCy5wrwb6DiEnK/ehSN5MxHphQQhC2OoTeEkbezsKCZYtuzh5fcC+G5/C4pB494TCeKtgUPZLsQ+ksD+TFH8YcuVXEfgRsxNW30ZWDvncQLESYnOFjCRTavInFPtPSxl/AX/ogCVgi8hyoeMAma6sDb3UaR/N5uVi/Vqt3fXvxk1bhpILFcg8yuU8xaRBoUD0g3W+S4Mpe1Hr8jCCZxPWab2fecSKS8ofE42or5N0hSt1LClC4CbA2liFKqbOCAD/25hYv6+DlF4nlp8Xr4HF8N7Ind4O1XDTJ3v/evf++MREPCvg2G9kaGhBSeQ80MSCg9+h9DiFDpbkquiB6Sq79q7FQC0xrdW5mAyPS2oGRr2/BfXWm3SHBnQnfqdBQb286rOBEnnaISVUiDrc9fVGBvblnlp+mr8d38nUfUiPlzmqPYGS7q5T5O3icckyHHpZ5ISuQwsVWU9qUhZ8wEMyRtgZ9XQ3Oxu2Fr3peEi+r2Yja3Boo0nC0/jF4c3UEPmCrBTaGLKoa71KV52BIRTX3ZiA3mWCowR6Np3KnIpyWbi7ujHRmURyXUzEStEgD56tkIXUkThWaZPEWygDmVYJua8NYLmSUIPpVesgUR1r/cCJlrFcFpgs6V5QdWXQGPETgO+E+7j6scsIhHyroh+twluyEMPinJ7KV9MhX/mbtgZ9kvFTtaXIP61ToRSOLLWqWETGnMz1w5DwCC2Qp2odT1qd5vIeUEPjKR8bQbOpOEiP5ZgtxhaikR9IBlQDUS9ewwZ+Ia8+IFUj5IzK+ERheQvD0mq9garsrdqYsOpQ5gUqNziTykrZ8oGHF77PpVOsuCo1xl17xiFDGcNBHlCiCXh5zhwoFC2aPxJL5jsGkJlrB9/PAKCdlYIaNmR/Zgwt5vw5Zo0TP5oIf2kEORQQVvpONLFL20G93dk03DlYvwz/dCZ7Ab+JtlFL7j+or+i0hFQwiwV2FHlNyWVOzEz4sUKv5ciShS5EeYYqSfN32ehaMuXOL7zM9Sw0XtS70prnNaaqMu5UL//RTYaJ3sBI5xkFGXvZFHd+2Fv9xj7HTk7+PuWcW/TZEaUqxwq5LtSGjfhilq5WPT6oEpR+5e8wRI8kCQFPTLo0usvcuJ8UdJV7z24CunrEpWSTVT7TrA36cLXWFeIBpTXZqWxk45xH/m3pHv+XMUL/kkrR7isZKxMImMv8mRsGfHQjReRUdWVwF3bwxDdRX1H8bDEaNmlZcVcpPrKTE5icER9SI/KL960KfFKtPlKVhDp3TMT3MkEuNchFXIGclRDspNc0kz6I09eOrK2JKIg9RCCnDlUASJtNftlFU0QPyyekOpTOIPBkiZ/Hzd1G3vo0v3qIarnaORZbiBxH/9uC0PP3jNYRRQV6woAbtLTFLKVK4SKOave649axkxe6+y6o5e8wZKEsJLsEjoTvgBRvRWXWCklM0noZbIwiN6Xr+AI8tP24/j+/fAPCkV0yy7whdTni+KiE6tXSTPzxZtt1e1MMv21fkUl3iFD5Q7UwkRhrlC9eOUT6B5rnsphCRxFYCVKxeVstC3VbUj+9vstMQxisPhCjOzJMxQy9VGcA9fJFOSlH4IjYyN8+elKsdrqIRmkj10hrM5Jw7iohjl9QnnE3BTzjfIjx3/7wJoXp1hJGGLmhbZA9F3jyL0WSa4sE04WFKDbY4nEV4Wwgs8EPRsDy57DRq87nxtZi8h8JL4+mEwQzHuWsOieaQgveYMlzb2yM5Ryb6sGZaU0rIke+ExSRJekoTSrCkaLS4wJPymxeja+CeO+5SQ/00vsZ5pAmm6QVHM0wyU/XqGs4ThqTKBCiVMhkGBhRBPZFAYBEaGQDeRvX+WX0A2IZ3XaZRWWBWmvFVpugR4IDz93Y1ZoGRIKoFd5vtK8Li+B/Gb0eqzIVZGJ1mJTogEqND3cZASiIpuTgScVRyCDepV1ugxGcb0eNI7sKOTvN+9MxSPvbFREgUZjKtHsAfTCJd8pdESysdERMFEpm3J+X88coUDDxfS+pRH7bMelb7DOYxpq3D9GpM97ALW8BxSTpn7oI/BPGgEtmNTsnoKuiP4iQ0hhW/Bzh6r1kWPj5n95LGrEDGWkEsKNilz21mAMe3Eeth+lWapAhCpMFoodVVrsBLBNIPfNLc14ddRdTNjzGkJ3U0mxRTdYZ5iFNm8aMhUPeDoHV/ew/kmLVX9WqbAT2EtokNDJiJfsE7iJkCLy/zPshBvUbIlG3f6HhH3BOEWSwhB2zCRn++P2+Nfh9W9MlR47+93LkwJKu5YIjAiTltDcRBrS8MmsJxEudEPsdPaQqaMy30A3WP81O7mvEEdkS1uFguUvSoReqdXXJ7g+ApfaCCgRDxZFJHFfJNJvgW6k5llRL2Y4/Jvej1Os/LqN+QjjnwUk6YsbMx/Hvf7IJYROlNJFN9TBxveyhygsOcmLJoK2EXYH81YDEB1MOiFJKbCy6SHhYWWklLrB+oOZ5mexIXP5U4hMWckB5k5RgZ7mzwkQz+Wsf36i58+/wqW2tKvn86jSU5mXXVr0UKyiKh4UPBzVENgjaIq+GiFtH4cvsC4KqL7tYwuVP3E/HmMIXnz3Cyz/8TBxXeRiZ5uNqIZ4WMySxL2FlfXyBoutOiJRT4PVPSYSrzxyO///FK/HXBk9Oh8NVmUq1rrBqjDfJDlvYlVw/8x7cBlJ9IuI9pXmz7KH8KtXdpRXba7s0yXJgko/ppuTSodI/8AfxQzlfqcgn/SMPEyQi7Ky0FKb2LHglkZ2ttoYLRRava4PQi5rRaXtmmxeZ6sVjYxoFjj4GbLN49XJy/DttmRSGodqkmGq8bmShSH6CrxuiN9xrJo1hgaNINFzWEtlb143WBVer4yfteAQjnz6HEKdJ7lTaPTFZQ8BlVZ2VJl/rjJebtXGcA4XruzGKvn3Kt/3BV5P//pfMwJlp7Bsyk62x9gJ8DT6kyAgMgqm+l3gF1Kb+aUg5pmEk4xaCPR8pIzoY2joZHi3+/BJjP33YqQ7wwkPojqSSwRUhC9f43c/q4QZH9NptyG8IAPfLRhOJ4BN0x7Bd1VtE9YN1n95WHRniQ8J4oD6OfyV6KnblFvuU+I9nXVj4L9XeeGfyxdKZ13V3nGVVoS48hd6nIHy/kJPe07f/zPhcqXP9adcQ1XjLu6hpong4sqeWIV7wq0eTEJFEerg/OZnwtiKI9AHj3hRwknPMMJFPv+d+zMwcfJyHMun8IlSaiLQVxFo8rP8rkBWlNCHgg+deUMVkV0zVc8/nzMY0cI6y/leqs9ZlafWDdYfjJaJQMdiksr5kbPJR4oLK5Voyx5C3Xo2m1EeBXNur8NXKdZLrKQG4PszEffSV3ahx/kqQP9eSr+AG6g4NhfjnKW3U/pcf8o1xLBU0duobJjK3ufv81VV/FjtE8wBfylSdV7JO1nY4nzKg09W/opF/9lIZg0PbP7BKHSyciekfGxk97EFxGIjKSYpZ0SYw0whFQGVummARMX5TBgqI+XVHMXF+Hr6fQizspfXcorpd1H9YeNzJSKwFZ9RN1haqyV/xD2VEq4bvUZOoxrzZbAYTxKly0qHxIAi1V6ie6iaG1TTdZnEpYR0ApiUPi6CIn0VdPJEp05teCXbc6kcWekk9QmYUmkEMgQl57nsWBou5QIOlqIFLyOtL7ITSm5O1HAE+a96JWWHFJkx7pjSE+jk5LUwFCjZmM/pwkIPokk/cVJz4muN4mLRpS1HFFoEqFhByajk76LLKGVsSfRqTbiiJSitPBJinJ/lLF2kXgp5iuSYLEY/tqWI3pCXboG0kPgJnzxBk2Yq+5Q7BHUvG4I8AReih/BJkzTS89suutVeimeUbYRXSjJK51IETzQOcqmEne1QWCSV0Jax0uiN5JratCg1Kxfmayl66rI3oby307+RK4rYh4EeE+U8yZhBI3QuHn4lM0Leoyb/pT2KyHRxu2erzymsmk6eK0UWemHhgW6wtOmiLbKS6di+3zTkoR471IvZXU4DZM6hi8wudBo1D5HZFremgSfagGLghM9H5blUHkpifg3xXfZgKr/c310VQi8/9m/JjqPUR4TfWuS8KpCXnZMFKfMhK8NaMSTCaSQ0HkKnI2ZAa7UQriNhXRUeMaphK1EBMRbafRvOMa7zI5hQLRAPe8W4WEWLTzE4SFisGAKklB1c7tb9yOwgrTkmH8VkBUDoR65v5kRcSvJUkO+C9ynv1Z7rs5duACJz7yQfl9tcSE4mLiNKx7tI9ihc4R4X3yWbcitKsZmVQdIMqEJ5KxFeeQ55r8JPz41EsUlo8ZuoS8sh+R0TeeiFA8zB/M/ZDhFTla4AJaiiFKC08VYb2UXysv7I3JXzCkucdWOJhpZHkO5CE3SBhyZxJxU/jRRTeBci3EVYMC0WUSHszVWjqxusCxxm+bqGtRJyPxd35huGTkcu52KgCF0I37QhhF3r9ErYrOkxm8g8kK8638lGDrJjELErfD7sV2RFkXutRk3DVoeyh6uAlLJ0h0sNwX8RgPA9siWbLRIUnhQhU654vwpl4ao+qJcULl72SRqVpybut6gLs/XCLc8g7TBcwKYQFLEh1o+tEX4Mf41CuXOWQ23E/PFKjxpdfVniwnNlp3cm3O00WUoLUGtjk35B9nKK8GyZw0c5cqHykbBCdmRVYJLmdBkUESRW9fbz87BKL+O2ko652EQCRw/WLBiARQs244rWUbjyimh077MC+QHJ5FsKLXdfThoko7OAisuSEjBSYRocGzFswtlE5gLFUlv2KxSmchJcSY/NZuVcKCrmXKjkLREm4CV3mEE8aIZYRhXmX9izVrxiZSkJeQTpqdVSDPIj7WoXyj8mJlgmhpglGkAycEgVcFXiUIQ66J1y0/cpMeMLKxzpHpZ623xpMhM52MlHc9Hrf75UjAMWh5Vsi9xZuVtf29CA6FBOXKrxfLXpuOqnCuPW3fzKSHhsNnyzYS9DrhC1SJVXU8FD8ZMcAP+TRS4HlePLHXbu0DHXNuCEN+CbTcm8filVcFXN1OnPy/7dtnk9tj1kq71N7MKh1BycyKeQJaXem11RG1HBbny/XcQ7wtQQCHjvbEdZuIaLkk1Gek92Grobr4+kTLsZ23YdQ6smtVVot3X3USZ0SZaopNZOHzGNudsGRGDT9sNKmtxBj6+2fwGurh+K5DwzDqTRyF5YVEQDw3dVkIxuna7C+u17keelqAGzyjc2D1ckgt9vLSL/U3mckIseVsuG4YgMNvHe9uK65pdh294MqlcHlPRKyjOUuTF6rlYqkN/csi72HcvFb1mVi/QqcVVfJlo1b4QgtqZ8tyOF4VhlVq5qc+Bc+jK1p5BdpcS8qXTE+R8yt4XlxCzc/Uyu1422I+nNWIb59DxFyJgK2JpIrO5hnf8oq29KxYMeB3ukxC14Y94ezFt9oNw5Rb1286I+pHAtRlGRHR0emok8pwl7EgYxtDiB3KxauGnMTO7GLNvy5RQKHYcrGFZ7Lkx59eEO2I61Mx9Htz5zqBbCfixvLeZPGAYJDxR5592OUzRURhxI6oWpi47jtcXrEExvTVSUZdc3MJQJ5tLOFWn3YgsCqbtYSECriYkfcuAxz8YkppUMCTR6ZQ8/Xmvb3OH0ArLY4xWOIM4XiycfX+12YuSbn2PZxLvRoHYw2g5IgIMW1Mzr2Iw2OMjN7qYAgB8pp638fw+7+N3Cv01ArZETz2nIQnCBB3NnPIB+8VNRYI7C7sX9sP6wG08/mYgN/P9Vu4/j6fGb4GdjFoPkbQWubBp5EaowoQ4VK76c1xVPvLoVK3el4xTL5vtnxMPJe2g74F16OOEcH3q0DC2LuahtzDXJri2hrXgCmcKwQcofSdh6OY7Sx+YqJlVKYBDvN5sejD+czFuN7dUS8ffVR9u75yOPJI2WQiu2f3wXCul5tRy4EIF0h1xmJxPCpB3yoxdt5TO91A25DI+WLdyB/32uM27g/RR7atPISLjHGhm56g28/2Jez58tKrXNXnw1dwDuH56ELVSp92dSzklv1eYM4BjynumJO+mGB7CkX5hNBqqQNI7vZdi19C7s+CUbQ//1ufJCq9uhHG3hQhPWDXVI4p45UG5iL8THoHeHUBqwSlTDz+OhdQ+rxGBJG4KA4rpQMy0HUeWG0sSK4cb58Vj73Tru2B3RalAS6pApc/XUh5HN0OaTFYcwJWE7fI4c9lSxumi1ICvDhXybEREUmvyECcfQkFDc0mcWHFQ3duc5UT8ygDLd6cjLY1+WIRw2WyHWze6HW/t9gFRTDbY3MCShQQr18jNMHGd56yLU5iUFWgo9hBCkFNKYeE7yvGw6pVeUWxBIIGCFvJmjEJs+HopZi7fhrfnbEGiz4suZA2ClSOUt936I9UuGYc8JB/o9uZDCtBmoWzNC0RdnpJyEO6imSv7nWzMRzVyQjYvqSKYFAUGEevC8H708AG2a2XBr/0lId9VBE6RiS5EZ4fT6dyWOwpCJX2DLDoqj2ihUQCPn8EYoAyQ8SwaTHT/M7kWDC3SOnYlXHm+Pm2Oa4oYhHHsaH/+iNHLA10Ly4SMUrQgnFo6UulRCCrMUID8rD5dfGYVjh6nGEtBA5QujaUAtwWak5AWT1oRVK6Pk0oD1swYiiJQl7WNnI4/5mlDmatYt6osly37Gy0m/IIS9bJ4sEwLDwmikcuCgYalJ7zjVR3wSN4Zw9z5kBDSigclHOMPX4BA7igvdqBkZjBQan0J3BG69yo13JtyDdr3fp+EOg6/4CCLCaNgpC5/iCoCNdCkB5myeOwf5lJ1rUa8udqemINx3EvmFdeANFRzTxfWwzsMOVPkrks8VRl4/I/O7wsnuCaLq0XGsXjwaZmch3IX+rCiWCFhU+exn/oJusKR6JFU0uq7F5gC06z+ToVP5PE6QOQ8/zhuJh8fNwJRxQ9Cq7xx8s3AQju9NxlXNGuC20VwQqen4PukZYc9SnraIht7SdyYmvhqLrtEksOPCSVh9AvsPH8PoIc3o6dgQYHHgwEkL7hq9AHHtovDc6Ftw0/0fkPyMyWj+O80FNiY8hD0H89Fn3Bo0th3Bshmj8dxbq/Fb8mEseWsojRarWPSMUhnmdR2x4PcqpLzyK8KMWDj1LnTu9RqKg2+AJ3cbti4bg6M5QN/HF+K7eUPw7sxNmLVkE9aveFTJglsVNa0X1z7wgUp87/hoCA05s3uSA6cn0vuZJeh+Rwweup1qvbzHnSnUGpwyC4lvxqFZ3Cw0i6yJeW/3ROt7nqKn9Ra9EQM6932DBiuKaetA5qkKabT90LG+A7NfjsXYVxbilWcH4fW5G7F4QwrGx3dCz5go5NDw2O28/1W/YvzcbUgY1wExTeowJc975I+DhuDm4VNQlB+In5IewrpdhXh03GJYTKx4scdNmmt3LIhHNiPcTg/OVvFwPXs+/jNnOO4bkkCD78IPHNvNm79Bq5ibcVe/N/FpwjDs3OdF/ITFqEvj+PnsONwZvxYegh3XLIxHeq4bAaE0qMyLbfolHUNeWov3X+qE61vUxY1x0zH4vs4Yee8VfPfkXvNQa3FjNp6iDuOHT3dAh2ZhyHPQKwwCHh35Ad5+byhzaVOQ66upih3V7eC2QENrRZCxFg3WYTw8Igaxna8m6Fryl1xLZPcVRZyLfegGSxkswZCQ14chUOfhn9K7Kd9l3qKxGQsn3Im+Yz9D4hux6DsqAfMnx+K23q/hm6XPoXXPaYzX41G3TgBi4t5gSBNJNO89GPfqt1i7IxPbuasP5He2pzM5TS+5vjUXe9Pt+M+0h1Av3Iqb+s/CjPF3o85VEegQO58MqKyXsRLpY2J8xXtxDH9cuHHwEnpg96OYC/CeYXPxbVI8Dh1JQyzvyeRLx46Ep9F8wCJYLGaq62qh4fCeDTHm/nZqkbvNzC2wqcLksaBd7NvUjSjCtjlPoduwKUjLiUa9qGQc+ZUmJaQYGxeOxy3DFuJyalxOm9gLT761HF9uTkV0iA0puezM99XCl4ndsXTFUbwxZzNeeDgG/Ts3wZVUeJ42tjtuvSYCx0nMFsoduOPQuSgs8oeB1Mlu/k7ECoQu2eOXjZ9oIGzsSztyyoL7Ry1hWOqPWmZ6kNQxPJLP+1gwlhg4oM3gRdiaGAvke9Bm0Dwa83zs+nQoXl+4CZ8v24+1SYPRI34GDhVzcKUYIBzl5CDfPr8HXnh7JxZtPUZ+cg+G9WyKYQNbU8BzEVpfH4XJj3XE9M9+pgf6Az0nA/Z8Mhj/mrYFCT+k4JFuDfBo/+vQtucc3NShHt56/Dbc+dA0qr7wvItHISXdjR5PrsBPi7pT0syMtve+hp3/eQLPvrYQK3/0odv1Rkx8Lg4xfLeb6J1baMQ6xE5BOi3WW/GdccedTdCm52w4maxXzJ7V7JCqptWQj9ZXBGDyuIF8PhZuWOl2kzFUcmjC0S/Uyxf7+McbLMEBaao5Hsz7fh/eeP8gDYUs+JJEPA3a5DG3o03bCDw4aiaWTo2HK8ODbe5cbPsqAw8OaECuJBJwAAAMpElEQVQj9RG2zBtFSg0nsrjrBHOhnqIR/N9Ja3H00F7MnfIw2t/N3TSwNtZOvgfhUcwRsbIWzsT9nkw74h9L4m7fG5vT8jHoCcqTScKYq46ZDwxoH4hnh3bFU1M+w2tP3YmOg+cwJEum9zCO5UkPmP3ioua90hC0oOdnCmE5udhMGmITvppOXu1AI16c9BmrQgE4fiwD+46eYOanMR7s6Y+n+nVGTOxU9LilMZ4bcgdzEEy9MQcUzEXViiGOh8ngT8kEGXWZlyq8dnz7YzpGT/qKlbdDWJn0PO4b/g7259fC9sT7QSZp3DjsE6ybebcKvUwEKOTQk7o1boES7dKSrYrrlYIpLhRYDJj1Yie0o4fasv8EekztEO7Yja+WPgorQYz51NiNNGbhhUUHsHzJL9i4dDDmL9qEd5afgK/oGHYtegjTkvZg2/EMejA3oN2gFTglVTpWG+W4vHY+kibFo/MD7yPNWQ9h9Fa/nBUHO8P0a3vNxYx/daZnVB/t4z6kQbchxHwU3895nt5YIvKKjPh2Rl9EBvjQsN9iLHj5RjRvEIWYAXNgo9e3fk4/JC7ZhdcXr8dPC4dg0cfp+Hbffsx7siOryEJ9JxVmbhL0stv1fRvbFj2CpO/244V3fmS6wIR1b8fS0zKi04APWRWWSuXfb7AEZiPQFsGuyZ9ezmWp+ilSS8kfqooMwZ58s36kMm7XPADvjI2jly088KKZINVUyWvJe2bbtIiOnEv2v4oWTTdYCrRIB5el6wEvzsLuA0xesySuGSyt3CzJ9T1pxXiSIcfq6bF0+a3U35uCNQmjSfEK3Dboc2xc0h3rvj+Ap97YRW9tN+rVjMKhU0F4dODVGNnjCrRgqHlTi0Z4+5FOaB03lYADF9YsfRYPT1iGrb9kMgnbD6/M3IXElUfV5DBxwhSTtvbKkBNY/u4g5DPP8cW3RzB+xmb4s+r3Q9JIdB/8FsOURoislYGThalUWm7ENiJOKZaPTY5j2JIwAr/mONBzzDK66ZSAdxKWYWFCGDWwYua9iCIBW8e4D7By4UOYP3cdpiw9ig2z+sIcZuFCTkDTunZWFQ/TQARjwqiu6NipPprHTcGtjf0xfcIQ3DZgMvvKIrGLSfaVG07gmckr8fOSgfjxkAMvvDIDK2aMQvPur8AUdFm5aSmkkjYWG76e0Y2gTiNujU1gGGfGaxM6ov3VtXHL3f9Gjdq18MXUgbhxxCRYWOhYmzgYi9dswcTpuWh45TF8/PJAdB2eiCcf6ILb21+Ga+IS1TVKgbktG3mQ8Go/3Dv0FewvbsAcVBbWzBqNb3bk4ol/r8CPc/sjN9+Lmx9OUubikXub4LHY69G+9xQhHMAPS0bh0FGGwGOXYtv8vjiYkoueT69EcHEaNiwdirvj5yOLIfM3Hw1Ah96TENwwCF9NGoSm9KJcvN51l7txLPUEgv0jsYIbR9dBiThGsRMLoZTbF/fHFxsP45kp23nDAl69sMpZFdf8H37cTCyeksoTVXTCagyMNgSTJyh2+THQMFlYOOnV+Uo8//DtnEsEiAqffwly/mLcw7mc4x9vsJQAK+NxB6tjN3Axui11iQvSEOeCryoqKsK+pYOYv/oEP+0/ga2UIvoxNQvDhqzGxlV98eq0DVj5Uw56tA/GmIduwrGTOSp5fTizAPc98i6mPj8Y3ZoG4ARL47EjXsJnM8bSQyKIkeF9EPm0ezw4k/M1CJ/M6I9ug99DDitIkkRnIyN7uULoY6Xh6znDEMxcULs+85BL8QArQ6s5k3rgujo27E8uZILahKRPj+L1pB+UCrafk+V2115sXjoWrxN/9OGXKZqUk/R9mfLg7zAzlB2M/T+nY+iElfhm7kBehwRs9OAb0OvLpnd2I72Q75f0R6DZgl8OFqNpIy/S863oMmIhRnS9AmNir0G21R939p2A1QkvoefwfyOTSfetcx7Fvc8kYd9JH3Z92A8rdmdh7JuryxsswiBMLBpsXxaHtVsO4/E3NtJomPHM4Dboe1tDYnYYPhI9Hs6NpEW/jzBsQA8M6xGJfN6XBBlkTsKeZBf6v7QEPzHPlJnrxO0jPy53DbcrE1uWjkIwzyFc4gIjKXZ40SnuPSqM2bFxXjwSlm7C658cp35iEQZ0qonxI9vjSDYrvaGsmDoy8PQ7m+hV/oKtzE1+sGQLpny6DQ93bYMxD16L1r0m47ZurTB++A1o1fNDmPz57LOHUlwUSMlh40mwE0NGL8PNt8dgyD0NcFPfJOQTHOvJOYIdn4/EiJfWYN3eYoZVfNf0qP/uQ/BjQlssFMgewj+kDmByU67LkI0adhfmvfs4Oz/4O788LSJhQcZ7EdDxVX3uf7zBEkS5gXAFhy0I7eLmE0YgrSoyjCxB8w2JWk5k0AmcTAtBnh/xM0wqHyrIh8cRiZoRx3H0GNVIgusz70VxMG8KWreIwq/JmUjNqkFqGnJje5IR05QIeV897EzmuSIKER3EkPLIQdQ1R+CIy82dKxRh9jwcKaQ+IsMwQaJTHYv5Jsk7ORBkJTK80MtQI5weEs9JdRITSf2ja/GaNb04uD0HWe5wtViczP/4UcGGNUiEBBbxPgh2tPKDCgVGY2bM5mIMQr1o/lsqsUimurz+fnRu1hD70ugdGprTSPmwO5f5NoaWjUIPIaR2E8o3Eld1MBUOLvZAVxGuoxF2sziw/ecjqB8Wgt/SiyTFhCbBXlbrGPZRkr5pFPFehHkkp5UvYtgYKhVYi1CHlbl8irDmypbhC0MYx6JpAyLBme/ZdzgPjaJsOEBBi6SJ3VArpBZu44bSoVU4DhzKRcqpcOKovMy9MXzPB47llk/wulnVNPql4ToqTtcItCP5ZBaSj9NoGSM5DnmoH+JEZoFoTEfw78wZ0gO7OposBIRdJB9JoVSlHUfyCADmoDa0e3EiywlPRG00ohiomXLre1OCUJ9jD08KkjPqEzRbTEEHF5pdRQCKJQfbf8qGM6QJdRdZYSQGb2c2z0WiOx89lWtqObCXhrGIakI25k5L0e5VXbwX8/PSumTns4knVXgqi2rdfnh13Gg0rmlmYp1zh5VhsVNi+L3cFNVGX4F26WLez5nOpRssjoyZntQPB4sQ/9LnJUjmUuSxkqlQdLEmlm69XHxGJsNFXNVHoJ0mZaEhht3SM8eqmUH691hVFKFvHz0CIUETmQYPP29hKOklYtpNbJHkCYwEpjqt+Ty3eA7UT+R5jaqPTiaGNJZKr6KkZHkNovL8iIUSjTgKN3FRk9RfKjW0lAZ3EHvdclTeyMOSvvQlihC8oqKlh6GyOgRBqacSTBPzUW6FtvZXWSX1XLw3oQrx8DwWYogcVilJuxhahhFaQIMpfXjSUsm8mVK6kTBGpaXEwBOtzms5pSNf5ZAEUEqUlBgNFgxklkvoUFoLM7qISSJGzC7XE1UWhiFqTAXlzrGRLj4nr2MmjYCFUIP1Cx7Exu378ezbO4h1Yx1WmCl5RUGeu4ihs8i74ZiobaakV5N8mapXUjoQtC4GQeBz7FRbEsU7RVqM1zGqP1UfEcdEeybpNlC/oAEV9L5qEhJcMUG/dj5XkfA4MainxjgfXySueH15/7KQeQ0/4uEsLoKI7ZRcF6k4gikdzIsKmFWJX4uGo3g0CsektXOdPk5XDM+3yV31aIrYCp9NcpvSfiW99R4mxs0svojMpof3aRF1ZYZ/7uJctGhgR78+d6DVNXURyEqHicZXA8lKq5nMcRlxmcsylhoIukLH4l9hr+gcq4bE34+/tL7KcOtvD95VOwFf3gvvfo7PiPwzMxSpKOHyO890yRq9kEGSHIv8iA5J2UNTuC0zHKUI5JLlpj4rSU3V9nI+dyAtNNKaU7V5pRKwcl3+J38qoaYqvjUtz3GaatpQkhhX0vWamSl3U7IoPDQEouASRgN8583R2PZzGnYf45jRCNloAF00aH90lJ7TIChVHqKDeK7HafYe7b6kP1TGrPQcpeN+VjaKMhQrSstSsCJVOcpRtFTxZZVcx49tAj7ZRGiZpGPALI37DO9qRdhxVaN6uPrK+rimRU3UZZ4w0MKNl5TGJlb3XGzRYk1CpUhKe0qrcut/xWf/VoP1Vzygfg19BPQRuHRH4PxM+qU7HvqT6SOgj8D/4xHQDdb/45ej35o+AvoIlB8B3WDpM0IfAX0Eqs0I6Aar2rwq/Ub1EdBHQDdY+hzQR0AfgWozArrBqjavSr9RfQT0EdANlj4H9BHQR6DajIBusKrNq9JvVB8BfQR0g6XPAX0E9BGoNiOgG6xq86r0G9VHQB8B3WDpc0AfAX0Eqs0I6Aar2rwq/Ub1EdBH4P8AQ1iDV5sv/OwAAAAASUVORK5CYII='"/>
	<xsl:template match="/">
		<html>
			<head>
				<title/>
				<script type="text/javascript">
					<![CDATA[var QRCode;!function(){function a(a){this.mode=c.MODE_8BIT_BYTE,this.data=a,this.parsedData=[];for(var b=[],d=0,e=this.data.length;e>d;d++){var f=this.data.charCodeAt(d);f>65536?(b[0]=240|(1835008&f)>>>18,b[1]=128|(258048&f)>>>12,b[2]=128|(4032&f)>>>6,b[3]=128|63&f):f>2048?(b[0]=224|(61440&f)>>>12,b[1]=128|(4032&f)>>>6,b[2]=128|63&f):f>128?(b[0]=192|(1984&f)>>>6,b[1]=128|63&f):b[0]=f,this.parsedData=this.parsedData.concat(b)}this.parsedData.length!=this.data.length&&(this.parsedData.unshift(191),this.parsedData.unshift(187),this.parsedData.unshift(239))}function b(a,b){this.typeNumber=a,this.errorCorrectLevel=b,this.modules=null,this.moduleCount=0,this.dataCache=null,this.dataList=[]}function i(a,b){if(void 0==a.length)throw new Error(a.length+"/"+b);for(var c=0;c<a.length&&0==a[c];)c++;this.num=new Array(a.length-c+b);for(var d=0;d<a.length-c;d++)this.num[d]=a[d+c]}function j(a,b){this.totalCount=a,this.dataCount=b}function k(){this.buffer=[],this.length=0}function m(){return"undefined"!=typeof CanvasRenderingContext2D}function n(){var a=!1,b=navigator.userAgent;return/android/i.test(b)&&(a=!0,aMat=b.toString().match(/android ([0-9]\.[0-9])/i),aMat&&aMat[1]&&(a=parseFloat(aMat[1]))),a}function r(a,b){for(var c=1,e=s(a),f=0,g=l.length;g>=f;f++){var h=0;switch(b){case d.L:h=l[f][0];break;case d.M:h=l[f][1];break;case d.Q:h=l[f][2];break;case d.H:h=l[f][3]}if(h>=e)break;c++}if(c>l.length)throw new Error("Too long data");return c}function s(a){var b=encodeURI(a).toString().replace(/\%[0-9a-fA-F]{2}/g,"a");return b.length+(b.length!=a?3:0)}a.prototype={getLength:function(){return this.parsedData.length},write:function(a){for(var b=0,c=this.parsedData.length;c>b;b++)a.put(this.parsedData[b],8)}},b.prototype={addData:function(b){var c=new a(b);this.dataList.push(c),this.dataCache=null},isDark:function(a,b){if(0>a||this.moduleCount<=a||0>b||this.moduleCount<=b)throw new Error(a+","+b);return this.modules[a][b]},getModuleCount:function(){return this.moduleCount},make:function(){this.makeImpl(!1,this.getBestMaskPattern())},makeImpl:function(a,c){this.moduleCount=4*this.typeNumber+17,this.modules=new Array(this.moduleCount);for(var d=0;d<this.moduleCount;d++){this.modules[d]=new Array(this.moduleCount);for(var e=0;e<this.moduleCount;e++)this.modules[d][e]=null}this.setupPositionProbePattern(0,0),this.setupPositionProbePattern(this.moduleCount-7,0),this.setupPositionProbePattern(0,this.moduleCount-7),this.setupPositionAdjustPattern(),this.setupTimingPattern(),this.setupTypeInfo(a,c),this.typeNumber>=7&&this.setupTypeNumber(a),null==this.dataCache&&(this.dataCache=b.createData(this.typeNumber,this.errorCorrectLevel,this.dataList)),this.mapData(this.dataCache,c)},setupPositionProbePattern:function(a,b){for(var c=-1;7>=c;c++)if(!(-1>=a+c||this.moduleCount<=a+c))for(var d=-1;7>=d;d++)-1>=b+d||this.moduleCount<=b+d||(this.modules[a+c][b+d]=c>=0&&6>=c&&(0==d||6==d)||d>=0&&6>=d&&(0==c||6==c)||c>=2&&4>=c&&d>=2&&4>=d?!0:!1)},getBestMaskPattern:function(){for(var a=0,b=0,c=0;8>c;c++){this.makeImpl(!0,c);var d=f.getLostPoint(this);(0==c||a>d)&&(a=d,b=c)}return b},createMovieClip:function(a,b,c){var d=a.createEmptyMovieClip(b,c),e=1;this.make();for(var f=0;f<this.modules.length;f++)for(var g=f*e,h=0;h<this.modules[f].length;h++){var i=h*e,j=this.modules[f][h];j&&(d.beginFill(0,100),d.moveTo(i,g),d.lineTo(i+e,g),d.lineTo(i+e,g+e),d.lineTo(i,g+e),d.endFill())}return d},setupTimingPattern:function(){for(var a=8;a<this.moduleCount-8;a++)null==this.modules[a][6]&&(this.modules[a][6]=0==a%2);for(var b=8;b<this.moduleCount-8;b++)null==this.modules[6][b]&&(this.modules[6][b]=0==b%2)},setupPositionAdjustPattern:function(){for(var a=f.getPatternPosition(this.typeNumber),b=0;b<a.length;b++)for(var c=0;c<a.length;c++){var d=a[b],e=a[c];if(null==this.modules[d][e])for(var g=-2;2>=g;g++)for(var h=-2;2>=h;h++)this.modules[d+g][e+h]=-2==g||2==g||-2==h||2==h||0==g&&0==h?!0:!1}},setupTypeNumber:function(a){for(var b=f.getBCHTypeNumber(this.typeNumber),c=0;18>c;c++){var d=!a&&1==(1&b>>c);this.modules[Math.floor(c/3)][c%3+this.moduleCount-8-3]=d}for(var c=0;18>c;c++){var d=!a&&1==(1&b>>c);this.modules[c%3+this.moduleCount-8-3][Math.floor(c/3)]=d}},setupTypeInfo:function(a,b){for(var c=this.errorCorrectLevel<<3|b,d=f.getBCHTypeInfo(c),e=0;15>e;e++){var g=!a&&1==(1&d>>e);6>e?this.modules[e][8]=g:8>e?this.modules[e+1][8]=g:this.modules[this.moduleCount-15+e][8]=g}for(var e=0;15>e;e++){var g=!a&&1==(1&d>>e);8>e?this.modules[8][this.moduleCount-e-1]=g:9>e?this.modules[8][15-e-1+1]=g:this.modules[8][15-e-1]=g}this.modules[this.moduleCount-8][8]=!a},mapData:function(a,b){for(var c=-1,d=this.moduleCount-1,e=7,g=0,h=this.moduleCount-1;h>0;h-=2)for(6==h&&h--;;){for(var i=0;2>i;i++)if(null==this.modules[d][h-i]){var j=!1;g<a.length&&(j=1==(1&a[g]>>>e));var k=f.getMask(b,d,h-i);k&&(j=!j),this.modules[d][h-i]=j,e--,-1==e&&(g++,e=7)}if(d+=c,0>d||this.moduleCount<=d){d-=c,c=-c;break}}}},b.PAD0=236,b.PAD1=17,b.createData=function(a,c,d){for(var e=j.getRSBlocks(a,c),g=new k,h=0;h<d.length;h++){var i=d[h];g.put(i.mode,4),g.put(i.getLength(),f.getLengthInBits(i.mode,a)),i.write(g)}for(var l=0,h=0;h<e.length;h++)l+=e[h].dataCount;if(g.getLengthInBits()>8*l)throw new Error("code length overflow. ("+g.getLengthInBits()+">"+8*l+")");for(g.getLengthInBits()+4<=8*l&&g.put(0,4);0!=g.getLengthInBits()%8;)g.putBit(!1);for(;;){if(g.getLengthInBits()>=8*l)break;if(g.put(b.PAD0,8),g.getLengthInBits()>=8*l)break;g.put(b.PAD1,8)}return b.createBytes(g,e)},b.createBytes=function(a,b){for(var c=0,d=0,e=0,g=new Array(b.length),h=new Array(b.length),j=0;j<b.length;j++){var k=b[j].dataCount,l=b[j].totalCount-k;d=Math.max(d,k),e=Math.max(e,l),g[j]=new Array(k);for(var m=0;m<g[j].length;m++)g[j][m]=255&a.buffer[m+c];c+=k;var n=f.getErrorCorrectPolynomial(l),o=new i(g[j],n.getLength()-1),p=o.mod(n);h[j]=new Array(n.getLength()-1);for(var m=0;m<h[j].length;m++){var q=m+p.getLength()-h[j].length;h[j][m]=q>=0?p.get(q):0}}for(var r=0,m=0;m<b.length;m++)r+=b[m].totalCount;for(var s=new Array(r),t=0,m=0;d>m;m++)for(var j=0;j<b.length;j++)m<g[j].length&&(s[t++]=g[j][m]);for(var m=0;e>m;m++)for(var j=0;j<b.length;j++)m<h[j].length&&(s[t++]=h[j][m]);return s};for(var c={MODE_NUMBER:1,MODE_ALPHA_NUM:2,MODE_8BIT_BYTE:4,MODE_KANJI:8},d={L:1,M:0,Q:3,H:2},e={PATTERN000:0,PATTERN001:1,PATTERN010:2,PATTERN011:3,PATTERN100:4,PATTERN101:5,PATTERN110:6,PATTERN111:7},f={PATTERN_POSITION_TABLE:[[],[6,18],[6,22],[6,26],[6,30],[6,34],[6,22,38],[6,24,42],[6,26,46],[6,28,50],[6,30,54],[6,32,58],[6,34,62],[6,26,46,66],[6,26,48,70],[6,26,50,74],[6,30,54,78],[6,30,56,82],[6,30,58,86],[6,34,62,90],[6,28,50,72,94],[6,26,50,74,98],[6,30,54,78,102],[6,28,54,80,106],[6,32,58,84,110],[6,30,58,86,114],[6,34,62,90,118],[6,26,50,74,98,122],[6,30,54,78,102,126],[6,26,52,78,104,130],[6,30,56,82,108,134],[6,34,60,86,112,138],[6,30,58,86,114,142],[6,34,62,90,118,146],[6,30,54,78,102,126,150],[6,24,50,76,102,128,154],[6,28,54,80,106,132,158],[6,32,58,84,110,136,162],[6,26,54,82,110,138,166],[6,30,58,86,114,142,170]],G15:1335,G18:7973,G15_MASK:21522,getBCHTypeInfo:function(a){for(var b=a<<10;f.getBCHDigit(b)-f.getBCHDigit(f.G15)>=0;)b^=f.G15<<f.getBCHDigit(b)-f.getBCHDigit(f.G15);return(a<<10|b)^f.G15_MASK},getBCHTypeNumber:function(a){for(var b=a<<12;f.getBCHDigit(b)-f.getBCHDigit(f.G18)>=0;)b^=f.G18<<f.getBCHDigit(b)-f.getBCHDigit(f.G18);return a<<12|b},getBCHDigit:function(a){for(var b=0;0!=a;)b++,a>>>=1;return b},getPatternPosition:function(a){return f.PATTERN_POSITION_TABLE[a-1]},getMask:function(a,b,c){switch(a){case e.PATTERN000:return 0==(b+c)%2;case e.PATTERN001:return 0==b%2;case e.PATTERN010:return 0==c%3;case e.PATTERN011:return 0==(b+c)%3;case e.PATTERN100:return 0==(Math.floor(b/2)+Math.floor(c/3))%2;case e.PATTERN101:return 0==b*c%2+b*c%3;case e.PATTERN110:return 0==(b*c%2+b*c%3)%2;case e.PATTERN111:return 0==(b*c%3+(b+c)%2)%2;default:throw new Error("bad maskPattern:"+a)}},getErrorCorrectPolynomial:function(a){for(var b=new i([1],0),c=0;a>c;c++)b=b.multiply(new i([1,g.gexp(c)],0));return b},getLengthInBits:function(a,b){if(b>=1&&10>b)switch(a){case c.MODE_NUMBER:return 10;case c.MODE_ALPHA_NUM:return 9;case c.MODE_8BIT_BYTE:return 8;case c.MODE_KANJI:return 8;default:throw new Error("mode:"+a)}else if(27>b)switch(a){case c.MODE_NUMBER:return 12;case c.MODE_ALPHA_NUM:return 11;case c.MODE_8BIT_BYTE:return 16;case c.MODE_KANJI:return 10;default:throw new Error("mode:"+a)}else{if(!(41>b))throw new Error("type:"+b);switch(a){case c.MODE_NUMBER:return 14;case c.MODE_ALPHA_NUM:return 13;case c.MODE_8BIT_BYTE:return 16;case c.MODE_KANJI:return 12;default:throw new Error("mode:"+a)}}},getLostPoint:function(a){for(var b=a.getModuleCount(),c=0,d=0;b>d;d++)for(var e=0;b>e;e++){for(var f=0,g=a.isDark(d,e),h=-1;1>=h;h++)if(!(0>d+h||d+h>=b))for(var i=-1;1>=i;i++)0>e+i||e+i>=b||(0!=h||0!=i)&&g==a.isDark(d+h,e+i)&&f++;f>5&&(c+=3+f-5)}for(var d=0;b-1>d;d++)for(var e=0;b-1>e;e++){var j=0;a.isDark(d,e)&&j++,a.isDark(d+1,e)&&j++,a.isDark(d,e+1)&&j++,a.isDark(d+1,e+1)&&j++,(0==j||4==j)&&(c+=3)}for(var d=0;b>d;d++)for(var e=0;b-6>e;e++)a.isDark(d,e)&&!a.isDark(d,e+1)&&a.isDark(d,e+2)&&a.isDark(d,e+3)&&a.isDark(d,e+4)&&!a.isDark(d,e+5)&&a.isDark(d,e+6)&&(c+=40);for(var e=0;b>e;e++)for(var d=0;b-6>d;d++)a.isDark(d,e)&&!a.isDark(d+1,e)&&a.isDark(d+2,e)&&a.isDark(d+3,e)&&a.isDark(d+4,e)&&!a.isDark(d+5,e)&&a.isDark(d+6,e)&&(c+=40);for(var k=0,e=0;b>e;e++)for(var d=0;b>d;d++)a.isDark(d,e)&&k++;var l=Math.abs(100*k/b/b-50)/5;return c+=10*l}},g={glog:function(a){if(1>a)throw new Error("glog("+a+")");return g.LOG_TABLE[a]},gexp:function(a){for(;0>a;)a+=255;for(;a>=256;)a-=255;return g.EXP_TABLE[a]},EXP_TABLE:new Array(256),LOG_TABLE:new Array(256)},h=0;8>h;h++)g.EXP_TABLE[h]=1<<h;for(var h=8;256>h;h++)g.EXP_TABLE[h]=g.EXP_TABLE[h-4]^g.EXP_TABLE[h-5]^g.EXP_TABLE[h-6]^g.EXP_TABLE[h-8];for(var h=0;255>h;h++)g.LOG_TABLE[g.EXP_TABLE[h]]=h;i.prototype={get:function(a){return this.num[a]},getLength:function(){return this.num.length},multiply:function(a){for(var b=new Array(this.getLength()+a.getLength()-1),c=0;c<this.getLength();c++)for(var d=0;d<a.getLength();d++)b[c+d]^=g.gexp(g.glog(this.get(c))+g.glog(a.get(d)));return new i(b,0)},mod:function(a){if(this.getLength()-a.getLength()<0)return this;for(var b=g.glog(this.get(0))-g.glog(a.get(0)),c=new Array(this.getLength()),d=0;d<this.getLength();d++)c[d]=this.get(d);for(var d=0;d<a.getLength();d++)c[d]^=g.gexp(g.glog(a.get(d))+b);return new i(c,0).mod(a)}},j.RS_BLOCK_TABLE=[[1,26,19],[1,26,16],[1,26,13],[1,26,9],[1,44,34],[1,44,28],[1,44,22],[1,44,16],[1,70,55],[1,70,44],[2,35,17],[2,35,13],[1,100,80],[2,50,32],[2,50,24],[4,25,9],[1,134,108],[2,67,43],[2,33,15,2,34,16],[2,33,11,2,34,12],[2,86,68],[4,43,27],[4,43,19],[4,43,15],[2,98,78],[4,49,31],[2,32,14,4,33,15],[4,39,13,1,40,14],[2,121,97],[2,60,38,2,61,39],[4,40,18,2,41,19],[4,40,14,2,41,15],[2,146,116],[3,58,36,2,59,37],[4,36,16,4,37,17],[4,36,12,4,37,13],[2,86,68,2,87,69],[4,69,43,1,70,44],[6,43,19,2,44,20],[6,43,15,2,44,16],[4,101,81],[1,80,50,4,81,51],[4,50,22,4,51,23],[3,36,12,8,37,13],[2,116,92,2,117,93],[6,58,36,2,59,37],[4,46,20,6,47,21],[7,42,14,4,43,15],[4,133,107],[8,59,37,1,60,38],[8,44,20,4,45,21],[12,33,11,4,34,12],[3,145,115,1,146,116],[4,64,40,5,65,41],[11,36,16,5,37,17],[11,36,12,5,37,13],[5,109,87,1,110,88],[5,65,41,5,66,42],[5,54,24,7,55,25],[11,36,12],[5,122,98,1,123,99],[7,73,45,3,74,46],[15,43,19,2,44,20],[3,45,15,13,46,16],[1,135,107,5,136,108],[10,74,46,1,75,47],[1,50,22,15,51,23],[2,42,14,17,43,15],[5,150,120,1,151,121],[9,69,43,4,70,44],[17,50,22,1,51,23],[2,42,14,19,43,15],[3,141,113,4,142,114],[3,70,44,11,71,45],[17,47,21,4,48,22],[9,39,13,16,40,14],[3,135,107,5,136,108],[3,67,41,13,68,42],[15,54,24,5,55,25],[15,43,15,10,44,16],[4,144,116,4,145,117],[17,68,42],[17,50,22,6,51,23],[19,46,16,6,47,17],[2,139,111,7,140,112],[17,74,46],[7,54,24,16,55,25],[34,37,13],[4,151,121,5,152,122],[4,75,47,14,76,48],[11,54,24,14,55,25],[16,45,15,14,46,16],[6,147,117,4,148,118],[6,73,45,14,74,46],[11,54,24,16,55,25],[30,46,16,2,47,17],[8,132,106,4,133,107],[8,75,47,13,76,48],[7,54,24,22,55,25],[22,45,15,13,46,16],[10,142,114,2,143,115],[19,74,46,4,75,47],[28,50,22,6,51,23],[33,46,16,4,47,17],[8,152,122,4,153,123],[22,73,45,3,74,46],[8,53,23,26,54,24],[12,45,15,28,46,16],[3,147,117,10,148,118],[3,73,45,23,74,46],[4,54,24,31,55,25],[11,45,15,31,46,16],[7,146,116,7,147,117],[21,73,45,7,74,46],[1,53,23,37,54,24],[19,45,15,26,46,16],[5,145,115,10,146,116],[19,75,47,10,76,48],[15,54,24,25,55,25],[23,45,15,25,46,16],[13,145,115,3,146,116],[2,74,46,29,75,47],[42,54,24,1,55,25],[23,45,15,28,46,16],[17,145,115],[10,74,46,23,75,47],[10,54,24,35,55,25],[19,45,15,35,46,16],[17,145,115,1,146,116],[14,74,46,21,75,47],[29,54,24,19,55,25],[11,45,15,46,46,16],[13,145,115,6,146,116],[14,74,46,23,75,47],[44,54,24,7,55,25],[59,46,16,1,47,17],[12,151,121,7,152,122],[12,75,47,26,76,48],[39,54,24,14,55,25],[22,45,15,41,46,16],[6,151,121,14,152,122],[6,75,47,34,76,48],[46,54,24,10,55,25],[2,45,15,64,46,16],[17,152,122,4,153,123],[29,74,46,14,75,47],[49,54,24,10,55,25],[24,45,15,46,46,16],[4,152,122,18,153,123],[13,74,46,32,75,47],[48,54,24,14,55,25],[42,45,15,32,46,16],[20,147,117,4,148,118],[40,75,47,7,76,48],[43,54,24,22,55,25],[10,45,15,67,46,16],[19,148,118,6,149,119],[18,75,47,31,76,48],[34,54,24,34,55,25],[20,45,15,61,46,16]],j.getRSBlocks=function(a,b){var c=j.getRsBlockTable(a,b);if(void 0==c)throw new Error("bad rs block @ typeNumber:"+a+"/errorCorrectLevel:"+b);for(var d=c.length/3,e=[],f=0;d>f;f++)for(var g=c[3*f+0],h=c[3*f+1],i=c[3*f+2],k=0;g>k;k++)e.push(new j(h,i));return e},j.getRsBlockTable=function(a,b){switch(b){case d.L:return j.RS_BLOCK_TABLE[4*(a-1)+0];case d.M:return j.RS_BLOCK_TABLE[4*(a-1)+1];case d.Q:return j.RS_BLOCK_TABLE[4*(a-1)+2];case d.H:return j.RS_BLOCK_TABLE[4*(a-1)+3];default:return void 0}},k.prototype={get:function(a){var b=Math.floor(a/8);return 1==(1&this.buffer[b]>>>7-a%8)},put:function(a,b){for(var c=0;b>c;c++)this.putBit(1==(1&a>>>b-c-1))},getLengthInBits:function(){return this.length},putBit:function(a){var b=Math.floor(this.length/8);this.buffer.length<=b&&this.buffer.push(0),a&&(this.buffer[b]|=128>>>this.length%8),this.length++}};var l=[[17,14,11,7],[32,26,20,14],[53,42,32,24],[78,62,46,34],[106,84,60,44],[134,106,74,58],[154,122,86,64],[192,152,108,84],[230,180,130,98],[271,213,151,119],[321,251,177,137],[367,287,203,155],[425,331,241,177],[458,362,258,194],[520,412,292,220],[586,450,322,250],[644,504,364,280],[718,560,394,310],[792,624,442,338],[858,666,482,382],[929,711,509,403],[1003,779,565,439],[1091,857,611,461],[1171,911,661,511],[1273,997,715,535],[1367,1059,751,593],[1465,1125,805,625],[1528,1190,868,658],[1628,1264,908,698],[1732,1370,982,742],[1840,1452,1030,790],[1952,1538,1112,842],[2068,1628,1168,898],[2188,1722,1228,958],[2303,1809,1283,983],[2431,1911,1351,1051],[2563,1989,1423,1093],[2699,2099,1499,1139],[2809,2213,1579,1219],[2953,2331,1663,1273]],o=function(){var a=function(a,b){this._el=a,this._htOption=b};return a.prototype.draw=function(a){function g(a,b){var c=document.createElementNS("http://www.w3.org/2000/svg",a);for(var d in b)b.hasOwnProperty(d)&&c.setAttribute(d,b[d]);return c}var b=this._htOption,c=this._el,d=a.getModuleCount();Math.floor(b.width/d),Math.floor(b.height/d),this.clear();var h=g("svg",{viewBox:"0 0 "+String(d)+" "+String(d),width:"100%",height:"100%",fill:b.colorLight});h.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),c.appendChild(h),h.appendChild(g("rect",{fill:b.colorDark,width:"1",height:"1",id:"template"}));for(var i=0;d>i;i++)for(var j=0;d>j;j++)if(a.isDark(i,j)){var k=g("use",{x:String(i),y:String(j)});k.setAttributeNS("http://www.w3.org/1999/xlink","href","#template"),h.appendChild(k)}},a.prototype.clear=function(){for(;this._el.hasChildNodes();)this._el.removeChild(this._el.lastChild)},a}(),p="svg"===document.documentElement.tagName.toLowerCase(),q=p?o:m()?function(){function a(){this._elImage.src=this._elCanvas.toDataURL("image/png"),this._elImage.style.display="block",this._elCanvas.style.display="none"}function d(a,b){var c=this;if(c._fFail=b,c._fSuccess=a,null===c._bSupportDataURI){var d=document.createElement("img"),e=function(){c._bSupportDataURI=!1,c._fFail&&_fFail.call(c)},f=function(){c._bSupportDataURI=!0,c._fSuccess&&c._fSuccess.call(c)};return d.onabort=e,d.onerror=e,d.onload=f,d.src="data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHElEQVQI12P4//8/w38GIAXDIBKE0DHxgljNBAAO9TXL0Y4OHwAAAABJRU5ErkJggg==",void 0}c._bSupportDataURI===!0&&c._fSuccess?c._fSuccess.call(c):c._bSupportDataURI===!1&&c._fFail&&c._fFail.call(c)}if(this._android&&this._android<=2.1){var b=1/window.devicePixelRatio,c=CanvasRenderingContext2D.prototype.drawImage;CanvasRenderingContext2D.prototype.drawImage=function(a,d,e,f,g,h,i,j){if("nodeName"in a&&/img/i.test(a.nodeName))for(var l=arguments.length-1;l>=1;l--)arguments[l]=arguments[l]*b;else"undefined"==typeof j&&(arguments[1]*=b,arguments[2]*=b,arguments[3]*=b,arguments[4]*=b);c.apply(this,arguments)}}var e=function(a,b){this._bIsPainted=!1,this._android=n(),this._htOption=b,this._elCanvas=document.createElement("canvas"),this._elCanvas.width=b.width,this._elCanvas.height=b.height,a.appendChild(this._elCanvas),this._el=a,this._oContext=this._elCanvas.getContext("2d"),this._bIsPainted=!1,this._elImage=document.createElement("img"),this._elImage.style.display="none",this._el.appendChild(this._elImage),this._bSupportDataURI=null};return e.prototype.draw=function(a){var b=this._elImage,c=this._oContext,d=this._htOption,e=a.getModuleCount(),f=d.width/e,g=d.height/e,h=Math.round(f),i=Math.round(g);b.style.display="none",this.clear();for(var j=0;e>j;j++)for(var k=0;e>k;k++){var l=a.isDark(j,k),m=k*f,n=j*g;c.strokeStyle=l?d.colorDark:d.colorLight,c.lineWidth=1,c.fillStyle=l?d.colorDark:d.colorLight,c.fillRect(m,n,f,g),c.strokeRect(Math.floor(m)+.5,Math.floor(n)+.5,h,i),c.strokeRect(Math.ceil(m)-.5,Math.ceil(n)-.5,h,i)}this._bIsPainted=!0},e.prototype.makeImage=function(){this._bIsPainted&&d.call(this,a)},e.prototype.isPainted=function(){return this._bIsPainted},e.prototype.clear=function(){this._oContext.clearRect(0,0,this._elCanvas.width,this._elCanvas.height),this._bIsPainted=!1},e.prototype.round=function(a){return a?Math.floor(1e3*a)/1e3:a},e}():function(){var a=function(a,b){this._el=a,this._htOption=b};return a.prototype.draw=function(a){for(var b=this._htOption,c=this._el,d=a.getModuleCount(),e=Math.floor(b.width/d),f=Math.floor(b.height/d),g=['<table style="border:0;border-collapse:collapse;">'],h=0;d>h;h++){g.push("<tr>");for(var i=0;d>i;i++)g.push('<td style="border:0;border-collapse:collapse;padding:0;margin:0;width:'+e+"px;height:"+f+"px;background-color:"+(a.isDark(h,i)?b.colorDark:b.colorLight)+';"></td>');g.push("</tr>")}g.push("</table>"),c.innerHTML=g.join("");var j=c.childNodes[0],k=(b.width-j.offsetWidth)/2,l=(b.height-j.offsetHeight)/2;k>0&&l>0&&(j.style.margin=l+"px "+k+"px")},a.prototype.clear=function(){this._el.innerHTML=""},a}();QRCode=function(a,b){if(this._htOption={width:256,height:256,typeNumber:4,colorDark:"#000000",colorLight:"#ffffff",correctLevel:d.H},"string"==typeof b&&(b={text:b}),b)for(var c in b)this._htOption[c]=b[c];"string"==typeof a&&(a=document.getElementById(a)),this._android=n(),this._el=a,this._oQRCode=null,this._oDrawing=new q(this._el,this._htOption),this._htOption.text&&this.makeCode(this._htOption.text)},QRCode.prototype.makeCode=function(a){this._oQRCode=new b(r(a,this._htOption.correctLevel),this._htOption.correctLevel),this._oQRCode.addData(a),this._oQRCode.make(),this._el.title=a,this._oDrawing.draw(this._oQRCode),this.makeImage()},QRCode.prototype.makeImage=function(){"function"==typeof this._oDrawing.makeImage&&(!this._android||this._android>=3)&&this._oDrawing.makeImage()},QRCode.prototype.clear=function(){this._oDrawing.clear()},QRCode.CorrectLevel=d}();]]>
				</script>
				<script language="JavaScript1.2">
					function GetDocumentWidth() { <xsl:choose>
						<xsl:when test="contains($hasAnyFalseChangeIndicator,'TRUE')">
							<xsl:if test="not($senaryo = 'IHRACAT' or $senaryo = 'İHRACAT' )"> document.getElementById("malHizmet").style.width = "13%"; document.getElementById("birimFiyat").style.width = "13%"; document.getElementById("digerVergiler").style.width = "14%"; </xsl:if>
							<xsl:if test="$senaryo = 'IHRACAT' or $senaryo = 'İHRACAT'"> document.getElementById("malHizmet").style.width = "10%"; document.getElementById("miktar").style.width = "6%"; document.getElementById("birimFiyat").style.width = "7%"; document.getElementById("iskontoOrani").style.width = "6%"; document.getElementById("iskontoTutari").style.width = "7%"; </xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="not($senaryo = 'IHRACAT' or $senaryo = 'İHRACAT' )"> document.getElementById("malHizmet").style.width = "17%"; document.getElementById("birimFiyat").style.width = "14%"; </xsl:if>
						</xsl:otherwise>
					</xsl:choose>
					var logoImageElement = document.getElementById("logoImage");
					if(logoImageElement.width == logoImageElement.height){
					logoImageElement.style.width = (<xsl:value-of select="$logoImageMultiplierValue"/>/100)*150 + 'px';
					logoImageElement.style.height = (<xsl:value-of select="$logoImageMultiplierValue"/>/100)*150 + 'px';
					}
					else if(logoImageElement.width > logoImageElement.height){
					logoImageElement.style.width = (<xsl:value-of select="$logoImageMultiplierValue"/>/100)*150 + 'px';
					logoImageElement.style.height = (<xsl:value-of select="$logoImageMultiplierValue"/>/100)*75 + 'px';
					}
					};
				</script>
				<style type="text/css"> body { background-color: #FFFFFF; font-family: 'Tahoma', "Times New Roman", Times, serif; font-size: 11px; color: #666666; -webkit-print-color-adjust: exact; } h1, h2 { padding-bottom: 3px; padding-top: 3px; margin-bottom: 5px; text-transform: uppercase; font-family: Arial, Helvetica, sans-serif; } h1 { font-size: 1.4em; text-transform:none; } h2 { font-size: 1em; color: brown; } h3 { font-size: 1em; color: #333333; text-align: justify; margin: 0; padding: 0; } h4 { font-size: 1.1em; font-style: bold; font-family: Arial, Helvetica, sans-serif; color: #000000; margin: 0; padding: 0; } hr { border: 2px solid #000000; } p, ul, ol { margin-top: 1.5em; } ul, ol { margin-left: 3em; } blockquote { margin-left: 3em; margin-right: 3em; font-style: italic; } a { text-decoration: none; color: #70A300; } a:hover { border: none; color: #70A300; } #budgetContainerTable { border-width: 0px; border-spacing: 0px; border-style: inset; border-color: black; border-collapse: collapse; margin-left:auto; } #despatchTable { border-collapse:collapse; float:right; border-color:black; max-width:270px; } #despatchDocumentReferenceTable{ border-collapse:collapse; } div.divContainer { width:800px; } #ettnTable { border-collapse:collapse; border-color:black; } #lineTable { border-width:2px; border-style: inset; border-color: black; border-collapse: collapse; } .lineTableTd { border-width: 1px; padding: 1px; border-style: inset; border-color: black; background-color: white; } #lineTableTr { border-width: 1px; padding: 0px; border-style: inset; border-color: black; background-color: white; } #lineTableBudgetTd { border-width: 2px; border-spacing:0px; padding: 1px; border-style: inset; border-color: black; background-color: white; } #notesTable { border-width: 2px; border-style: inset; border-color: black; border-collapse: collapse; } #notesTableTd { border-width: 0px; border-style: inset; border-color: black; border-collapse: collapse; } table { border-spacing:0px; } td { border-color:black; } .fixedTableCss{ table-layout:fixed; overflow-wrap:break-word; word-wrap:break-word; -ms-word-wrap:break-word; } #SGK_Table td{ max-width:400px; white-space: pre-wrap; white-space: -moz-pre-wrap; white-space: -pre-wrap; white-space: -o-pre-wrap; word-wrap: break-word; }</style>
				<title>e-Fatura</title>
			</head>
			<body onload="javascript:GetDocumentWidth()" style="margin-left=0.6in; margin-right=0.6in; margin-top=0.79in; margin-bottom=0.79in">
				<xsl:for-each select="$XML">
					<table border="0" cellspacing="0px" width="800" cellpadding="0px">
						<tbody>
							<tr valign="top">
								<td width="40%" align="left" class="tdLeft">
									<br/>
									<table id="supplierPartyTable" class="fixedTableCss" align="center" border="0" width="100%">
										<tbody>
											<hr/>
											<tr align="left">
												<xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party">
													<td align="left">
														BAŞARI METAL - 
														<xsl:if test="cac:PartyName/cbc:Name!=''">
															<xsl:value-of select="cac:PartyName/cbc:Name"/>
															<br/>
														</xsl:if>
														<xsl:for-each select="cac:Person">
															<xsl:if test="cbc:Title!='' or cbc:FirstName!='' or cbc:MiddleName!='' or cbc:FamilyName!='' or cbc:NameSuffix!=''">
																<xsl:for-each select="cbc:Title">
																	<xsl:if test=". != ''">
																		<xsl:apply-templates/>
																		<xsl:text>&#xA0;</xsl:text>
																	</xsl:if>
																</xsl:for-each>
																<xsl:for-each select="cbc:FirstName">
																	<xsl:if test=". != ''">
																		<xsl:apply-templates/>
																		<xsl:text>&#xA0;</xsl:text>
																	</xsl:if>
																</xsl:for-each>
																<xsl:for-each select="cbc:MiddleName">
																	<xsl:if test=". != ''">
																		<xsl:apply-templates/>
																		<xsl:text>&#xA0;</xsl:text>
																	</xsl:if>
																</xsl:for-each>
																<xsl:for-each select="cbc:FamilyName">
																	<xsl:if test=". != ''">
																		<xsl:apply-templates/>
																		<xsl:text>&#xA0;</xsl:text>
																	</xsl:if>
																</xsl:for-each>
																<xsl:for-each select="cbc:NameSuffix">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:if>
														</xsl:for-each>
													</td>
												</xsl:for-each>
											</tr>
											<tr align="left">
												<xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party">
													<td align="left">
														<xsl:for-each select="cac:PostalAddress">
															<xsl:for-each select="cbc:StreetName">
																<xsl:if test=". != ''">
																	<xsl:apply-templates/>
																	<xsl:text>&#xA0;</xsl:text>
																</xsl:if>
															</xsl:for-each>
															<xsl:for-each select="cbc:BuildingName">
																<xsl:if test=". != ''">
																	<xsl:apply-templates/>
																	<xsl:text>&#xA0;</xsl:text>
																</xsl:if>
															</xsl:for-each>
															<xsl:if test="cbc:BuildingNumber != ''">
																<xsl:text>No:</xsl:text>
																<xsl:for-each select="cbc:BuildingNumber">
																	<xsl:apply-templates/>
																</xsl:for-each>
																<xsl:text>&#xA0;</xsl:text>
															</xsl:if>
															<xsl:if test="cbc:StreetName !='' or cbc:BuildingName !='' or cbc:BuildingNumber !=''">
																<br/>
															</xsl:if>
															<xsl:for-each select="cbc:PostalZone">
																<xsl:if test=". != ''">
																	<xsl:apply-templates/>
																	<xsl:text>&#xA0;</xsl:text>
																</xsl:if>
															</xsl:for-each>
															<xsl:for-each select="cbc:District">
																<xsl:apply-templates/>
																<span>
																	<xsl:text>&#xA0;</xsl:text>
																</span>
															</xsl:for-each>
															<xsl:for-each select="cbc:CitySubdivisionName">
																<xsl:apply-templates/>
															</xsl:for-each>
															<xsl:if test="cbc:CitySubdivisionName!='' and cbc:CityName!=''">
																<xsl:text>/ </xsl:text>
															</xsl:if>
															<xsl:for-each select="cbc:CityName">
																<xsl:if test=". != ''">
																	<xsl:apply-templates/>
																	<xsl:text>&#xA0;</xsl:text>
																</xsl:if>
															</xsl:for-each>
														</xsl:for-each>
													</td>
												</xsl:for-each>
											</tr>
											<tr align="left">
												<xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party">
													<xsl:if test="cac:Contact/cbc:Telephone !='' or cac:Contact/cbc:Telefax !=''">
														<td align="left">
															<xsl:for-each select="cac:Contact">
																<xsl:if test="cbc:Telephone != ''">
																	<xsl:text>Tel: </xsl:text>
																	<xsl:for-each select="cbc:Telephone">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:if>
																<xsl:if test="cbc:Telefax != ''">
																	<xsl:text> Fax: </xsl:text>
																	<xsl:for-each select="cbc:Telefax">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:if>
																<xsl:text>&#xA0;</xsl:text>
															</xsl:for-each>
														</td>
													</xsl:if>
												</xsl:for-each>
											</tr>
											<xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cbc:WebsiteURI">
												<xsl:if test=". !=''">
													<tr align="left">
														<td>
															<xsl:text>Web Sitesi: </xsl:text>
															<xsl:value-of select="."/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
											<xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:Contact/cbc:ElectronicMail">
												<xsl:if test=". !=''">
													<tr align="left">
														<td>
															<xsl:text>E-Posta: </xsl:text>
															<xsl:value-of select="."/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
											<tr align="left">
												<xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party">
													<xsl:if test="cac:PartyTaxScheme/cac:TaxScheme/cbc:Name !=''">
														<td align="left">
															<xsl:text>Vergi Dairesi: </xsl:text>
															<xsl:for-each select="cac:PartyTaxScheme">
																<xsl:for-each select="cac:TaxScheme">
																	<xsl:for-each select="cbc:Name">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
																<xsl:text>&#xA0; </xsl:text>
															</xsl:for-each>
														</td>
													</xsl:if>
												</xsl:for-each>
											</tr>
											<xsl:for-each select="//n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyIdentification">
												<xsl:if test="cbc:ID !=''">
													<tr align="left">
														<td>
															<xsl:value-of select="cbc:ID/@schemeID"/>
															<xsl:text>: </xsl:text>
															<xsl:value-of select="cbc:ID"/>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
											<xsl:variable name="hasSenderNotes"></xsl:variable>
											<xsl:if test="$hasSenderNotes">
												<tr>
													<td>
														
													</td>
												</tr>
											</xsl:if>
										</tbody>
									</table>
									<hr/>
								</td>
								<td width="20%" align="center" valign="top" rowspan="" class="tdMid">
									<br/>
									<img style="width:91px;" align="middle" alt="E-Fatura Logo" src="data:image/jpeg;base64,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"/>
									<h1 align="center">
										<span style="font-weight:bold; ">
											<xsl:text>e-FATURA</xsl:text>
										</span>
									</h1>
								</td>
								<td width="40%" align="right" valign="middle" class="tdRight">
									<div id="qrcode" style="width:140px;"/>
<div id="qrvalue" style="visibility: hidden; height: 20px;width: 20px; ; display:none">
{"vkntckn":"<xsl:value-of select="n1:Invoice/cac:AccountingSupplierParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID = 'TCKN' or @schemeID = 'VKN']"/>",
"avkntckn":"<xsl:value-of select="n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID = 'TCKN' or @schemeID = 'VKN']"/>",<xsl:if test="$senaryo = 'YOLCUBERABERFATURA' or $senaryo = 'YOLCUBERABER'"><xsl:text>&#10;</xsl:text>"pasaportno":"<xsl:value-of select="n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:Person/cac:IdentityDocumentReference/cbc:ID"/>",<xsl:text>&#10;</xsl:text>"aracikurumvkn":"<xsl:value-of select="n1:Invoice/cac:TaxRepresentativeParty/cac:PartyIdentification/cbc:ID[@schemeID = 'ARACIKURUMVKN']"/>",</xsl:if>
"senaryo":"<xsl:value-of select="n1:Invoice/cbc:ProfileID"/>",
"tip":"<xsl:value-of select="n1:Invoice/cbc:InvoiceTypeCode"/>",
"tarih":"<xsl:value-of select="n1:Invoice/cbc:IssueDate"/>",
"no":"<xsl:value-of select="n1:Invoice/cbc:ID"/>",
"ettn":"<xsl:value-of select="n1:Invoice/cbc:UUID"/>",
"parabirimi":"<xsl:value-of select="n1:Invoice/cbc:DocumentCurrencyCode"/>",
"malhizmettoplam":"<xsl:value-of select="n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount"/><xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '0015']">"<xsl:text>,
"kdvmatrah</xsl:text>(<xsl:value-of select="cbc:Percent"/>)":"<xsl:value-of select="cbc:TaxableAmount"/>"</xsl:for-each><xsl:for-each select="n1:Invoice/cac:TaxTotal/cac:TaxSubtotal[cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode = '0015']"><xsl:text>,
"hesaplanankdv</xsl:text>(<xsl:value-of select="cbc:Percent"/>)":"<xsl:value-of select="cbc:TaxAmount"/>",</xsl:for-each>
"vergidahil":"<xsl:value-of select="n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount"/>",
"odenecek":"<xsl:value-of select="n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount"/>"}
</div>
									<script type="text/javascript">
										var qrcode = new QRCode(document.getElementById("qrcode"), {
										width : 140,
										height : 140,
										correctLevel : QRCode.CorrectLevel.M
										});

										function makeCode (msg) {
										var elText = document.getElementById("text");

										qrcode.makeCode(msg);
										}

										makeCode(document.getElementById("qrvalue").innerHTML);
									</script>
									<br/>
									<xsl:if test="$base64Image !=''">
										<img id="logoImage" style="margin:7px 0px;" align="right" alt="">
											<xsl:attribute name="src">
												<xsl:value-of select="$base64Image"/>
											</xsl:attribute>
										</img>
									</xsl:if>
								</td>
							</tr>
							<tr></tr>
							<tr valign="top">
								<td width="40%" align="left" valign="bottom" class="tdLeft">
									<table id="customerPartyTable" class="fixedTableCss" align="center" border="0" height="50%" width="100%">
										<tbody>
											<hr/>
											<tr>
												<xsl:for-each select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party">
													<td align="left">
														<b>SAYIN</b>
													</td>
												</xsl:for-each>
											</tr>
											<tr>
												<xsl:choose>
													<xsl:when test="//n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='TAXFREE']">
														<xsl:for-each select="//n1:Invoice/cac:BuyerCustomerParty/cac:Party">
															<xsl:call-template name="Party_Title">
																<xsl:with-param name="PartyType">TAXFREE</xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</xsl:when>
													<xsl:when test="//n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='EXPORT']">
														<xsl:for-each select="//n1:Invoice/cac:BuyerCustomerParty/cac:Party">
															<xsl:call-template name="Party_Title">
																<xsl:with-param name="PartyType">EXPORT</xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</xsl:when>
													<xsl:otherwise>
														<xsl:for-each select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party">
															<xsl:call-template name="Party_Title">
																<xsl:with-param name="PartyType">OTHER</xsl:with-param>
															</xsl:call-template>
														</xsl:for-each>
													</xsl:otherwise>
												</xsl:choose>
											</tr>
											<xsl:choose>
												<xsl:when test="//n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='TAXFREE']">
													<xsl:for-each select="//n1:Invoice/cac:BuyerCustomerParty/cac:Party">
														<tr>
															<xsl:call-template name="Party_Adress">
																<xsl:with-param name="PartyType">TAXFREE</xsl:with-param>
															</xsl:call-template>
														</tr>
														<xsl:call-template name="Party_Other">
															<xsl:with-param name="PartyType">TAXFREE</xsl:with-param>
														</xsl:call-template>
													</xsl:for-each>
												</xsl:when>
												<xsl:when test="//n1:Invoice/cac:BuyerCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='PARTYTYPE' and text()='EXPORT']">
													<xsl:for-each select="n1:Invoice/cac:BuyerCustomerParty/cac:Party">
														<tr>
															<xsl:call-template name="Party_Adress">
																<xsl:with-param name="PartyType">EXPORT</xsl:with-param>
															</xsl:call-template>
														</tr>
														<xsl:call-template name="Party_Other">
															<xsl:with-param name="PartyType">EXPORT</xsl:with-param>
														</xsl:call-template>
													</xsl:for-each>
												</xsl:when>
												<xsl:otherwise>
													<xsl:for-each select="//n1:Invoice/cac:AccountingCustomerParty/cac:Party">
														<tr>
															<xsl:call-template name="Party_Adress">
																<xsl:with-param name="PartyType">OTHER</xsl:with-param>
															</xsl:call-template>
														</tr>
														<xsl:call-template name="Party_Other">
															<xsl:with-param name="PartyType">OTHER</xsl:with-param>
														</xsl:call-template>
													</xsl:for-each>
												</xsl:otherwise>
											</xsl:choose>
											<xsl:variable name="hasReceiverNotes"></xsl:variable>
											<xsl:if test="$hasReceiverNotes">
												<tr>
													<td>
														
													</td>
												</tr>
											</xsl:if>
										</tbody>
									</table>
									<hr/>
								</td>
								<td width="20%" align="center" class="tdMid">
									<img style='max-width:150px;' align='center' alt='' src=''/>
								</td>
								<td width="40%" align="right" valign="bottom" class="tdRight">
									<table id="despatchTable" class="fixedTableCss" border="1" height="13" width="270px">
										<tbody>
											<tr>
												<td style="width:110px;" align="left">
													<span style="font-weight:bold; ">
														<xsl:text>Özelleştirme No:</xsl:text>
													</span>
												</td>
												<td style="width:135px;" align="left">
													<xsl:for-each select="//n1:Invoice">
														<xsl:for-each select="cbc:CustomizationID">
															<xsl:apply-templates/>
														</xsl:for-each>
													</xsl:for-each>
												</td>
											</tr>
											<tr style="height:13px;">
												<td align="left">
													<span style="font-weight:bold;">
														<xsl:text>Senaryo:</xsl:text>
													</span>
												</td>
												<td align="left">
													<xsl:for-each select="//n1:Invoice">
														<xsl:for-each select="cbc:ProfileID">
															<xsl:apply-templates/>
														</xsl:for-each>
													</xsl:for-each>
												</td>
											</tr>
											<tr style="height:13px;">
												<td align="left">
													<span style="font-weight:bold;">
														<xsl:text>Fatura Tipi:</xsl:text>
													</span>
												</td>
												<td align="left">
													<xsl:for-each select="//n1:Invoice">
														<xsl:for-each select="cbc:InvoiceTypeCode">
															<xsl:apply-templates/>
														</xsl:for-each>
													</xsl:for-each>
												</td>
											</tr>
											<tr style="height:13px;">
												<td align="left">
													<span style="font-weight:bold;">
														<xsl:text>Fatura No:</xsl:text>
													</span>
												</td>
												<td align="left">
													<xsl:for-each select="//n1:Invoice">
														<xsl:for-each select="cbc:ID">
															<xsl:apply-templates/>
														</xsl:for-each>
													</xsl:for-each>
												</td>
											</tr>
											<tr style="height:13px;">
												<td align="left">
													<span style="font-weight:bold;">
														<xsl:text>Fatura Tarihi:</xsl:text>
													</span>
												</td>
												<td align="left">
													<xsl:for-each select="//n1:Invoice">
														<xsl:for-each select="cbc:IssueDate">
															<xsl:value-of select="substring(.,9,2)"/>-<xsl:value-of select="substring(.,6,2)"/>-<xsl:value-of select="substring(.,1,4)"/>
														</xsl:for-each>
													</xsl:for-each>
												</td>
											</tr>
											<xsl:if test="//n1:Invoice/cbc:IssueDate !=''">
												<tr style="height:13px; ">
													<td align="left">
														<span style="font-weight:bold;">
															<xsl:text>Düzenleme Tarihi:</xsl:text>
														</span>
													</td>
													<td align="left">
														<xsl:for-each select="//n1:Invoice">
															<xsl:for-each select="cbc:IssueDate">
																<xsl:value-of select="substring(.,9,2)"/>-<xsl:value-of select="substring(.,6,2)"/>-<xsl:value-of select="substring(.,1,4)"/>
															</xsl:for-each>
														</xsl:for-each>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="n1:Invoice/cbc:IssueTime !=''">
												<tr style="height:13px; ">
													<td align="left">
														<span style="font-weight:bold; ">
															<xsl:text>Düzenleme Saati:</xsl:text>
														</span>
													</td>
													<td align="left">
														<xsl:for-each select="n1:Invoice">
															<xsl:for-each select="cbc:IssueTime">
																<xsl:value-of select="substring(.,0,9)"/>
															</xsl:for-each>
														</xsl:for-each>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="count(//n1:Invoice/cac:DespatchDocumentReference) = 1">
												<xsl:if test="//n1:Invoice/cac:DespatchDocumentReference/cbc:ID !=''">
													<tr style="height:13px; ">
														<td align="left">
															<span style="font-weight:bold;">
																<xsl:text>İrsaliye No:</xsl:text>
															</span>
														</td>
														<td align="left">
															<xsl:value-of select="//n1:Invoice/cac:DespatchDocumentReference/cbc:ID"/>
														</td>
													</tr>
												</xsl:if>
												<xsl:if test="//n1:Invoice/cac:DespatchDocumentReference/cbc:IssueDate !=''">
													<tr style="height:13px; ">
														<td align="left">
															<span style="font-weight:bold;">
																<xsl:text>İrsaliye Tarihi:</xsl:text>
															</span>
														</td>
														<td align="left">
															<xsl:for-each select="//n1:Invoice/cac:DespatchDocumentReference/cbc:IssueDate">
																<xsl:value-of select="substring(.,9,2)"/>-<xsl:value-of select="substring(.,6,2)"/>-<xsl:value-of select="substring(.,1,4)"/>
															</xsl:for-each>
														</td>
													</tr>
												</xsl:if>
											</xsl:if>
											<xsl:if test="//n1:Invoice/cac:OrderReference/cbc:ID !=''">
												<tr style="height:13px">
													<td align="left">
														<span style="font-weight:bold;">
															<xsl:text>Sipariş No:</xsl:text>
														</span>
													</td>
													<td align="left">
														<xsl:for-each select="//n1:Invoice/cac:OrderReference">
															<xsl:for-each select="cbc:ID">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="//n1:Invoice/cac:OrderReference/cbc:IssueDate !=''">
												<tr style="height:13px">
													<td align="left">
														<span style="font-weight:bold;">
															<xsl:text>Sipariş Tarihi:</xsl:text>
														</span>
													</td>
													<td align="left">
														<xsl:for-each select="//n1:Invoice/cac:OrderReference">
															<xsl:for-each select="cbc:IssueDate">
																<xsl:value-of select="substring(.,9,2)"/>-<xsl:value-of select="substring(.,6,2)"/>-<xsl:value-of select="substring(.,1,4)"/>
															</xsl:for-each>
														</xsl:for-each>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not(//n1:Invoice/cbc:DocumentCurrencyCode='TRY' or //n1:Invoice/cbc:DocumentCurrencyCode='TRL')">
												<tr style="height:13px; ">
													<td align="left">
														<span style="font-weight:bold;">
															<xsl:text>Döviz Kuru:</xsl:text>
														</span>
													</td>
													<td align="left">
														<xsl:value-of select="//n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate"/>
														<xsl:text> TL</xsl:text>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="$senaryo = 'YOLCUBERABERFATURA' or $senaryo = 'YOLCUBERABER'">
												<xsl:for-each select="//n1:Invoice/cac:TaxRepresentativeParty/cac:PartyIdentification/cbc:ID[@schemeID='ARACIKURUMVKN']">
													<xsl:if test=".!=''">
														<tr style="height:13px;">
															<td align="left">
																<span style="font-weight:bold;">
																	<xsl:text>Aracı Kurum VKN:</xsl:text>
																</span>
															</td>
															<td align="left">
																<xsl:value-of select="."/>
															</td>
														</tr>
													</xsl:if>
													<xsl:if test="../../cac:PartyName/cbc:Name != ''">
														<tr style="height:13px;">
															<td align="left">
																<span style="font-weight:bold;">
																	<xsl:text>Aracı Kurum Unvan:</xsl:text>
																</span>
															</td>
															<td align="left">
																<xsl:value-of select="../../cac:PartyName/cbc:Name"/>
															</td>
														</tr>
													</xsl:if>
												</xsl:for-each>
											</xsl:if>
										</tbody>
									</table>
								</td>
							</tr>
							<xsl:if test="260 >= $logoImageMultiplierValue and $logoImageMultiplierValue > 210">
								<script>
									<![CDATA[
										var hasTdLeftClass = document.getElementsByClassName("tdLeft");
										for (var i = 0; i < hasTdLeftClass.length; i++) {
											hasTdLeftClass[i].style.width="35%";
										}
										var hasTdMidClass = document.getElementsByClassName("tdMid");
										for (var i = 0; i < hasTdMidClass.length; i++) {
											hasTdMidClass[i].style.width="15%";
										}
										var hasTdRightClass = document.getElementsByClassName("tdRight");
										for (var i = 0; i < hasTdRightClass.length; i++) {
											hasTdRightClass[i].style.width="50%";
										}
									]]>
								</script>
							</xsl:if>
							<xsl:if test="$logoImageMultiplierValue > 260">
								<script>
									<![CDATA[
										var hasTdLeftClass = document.getElementsByClassName("tdLeft");
										for (var i = 0; i < hasTdLeftClass.length; i++) {
											hasTdLeftClass[i].style.width="27%";
										}
										var hasTdMidClass = document.getElementsByClassName("tdMid");
										for (var i = 0; i < hasTdMidClass.length; i++) {
											hasTdMidClass[i].style.width="15%";
										}
										var hasTdRightClass = document.getElementsByClassName("tdRight");
										for (var i = 0; i < hasTdRightClass.length; i++) {
											hasTdRightClass[i].style.width="58%";
										}
									]]>
								</script>
							</xsl:if>
							<tr align="left">
								<td align="left" colspan="3">
									<table id="ettnTable" class="fixedTableCss">
										<tr style="height:13px;">
											<td align="left" valign="top" width="35px">
												<span style="font-weight:bold; ">
													<xsl:text>ETTN:</xsl:text>
												</span>
											</td>
											<td align="left" width="240px">
												<xsl:for-each select="//n1:Invoice">
													<xsl:for-each select="cbc:UUID">
														<xsl:apply-templates/>
													</xsl:for-each>
												</xsl:for-each>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td>
									<xsl:if test="//n1:Invoice/cac:AccountingCustomerParty/cac:Party/cac:PartyIdentification/cbc:ID[@schemeID='VKN']='7750409379'">
										<table  id="SGK_Table" border="1" width="100%">
											<tbody>
												<tr>
													<td style="width:40%;" align="left">
														<span style="font-weight:bold; ">
															<xsl:text>Fatura Tipi:</xsl:text>
														</span>
													</td>
													<td style="width:60%;" align="left">
														<xsl:for-each select="n1:Invoice">
															<xsl:for-each select="cbc:AccountingCost">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</td>
												</tr>
												<tr style="height:13px; ">
													<td style="width:40%;" align="left">
														<span style="font-weight:bold; ">
															<xsl:text>Mükellef Kodu:</xsl:text>
														</span>
													</td>
													<td style="width:60%;" align="left">
														<xsl:for-each select="n1:Invoice">
															<xsl:for-each select="cac:AdditionalDocumentReference[cbc:DocumentTypeCode='MUKELLEF_KODU']/cbc:DocumentType">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</td>
												</tr>
												<tr style="height:13px; ">
													<td style="width:40%;" align="left">
														<span style="font-weight:bold; ">
															<xsl:text>Mükellef Adı:</xsl:text>
														</span>
													</td>
													<td style="width:60%;" align="left">
														<xsl:for-each select="n1:Invoice">
															<xsl:for-each select="cac:AdditionalDocumentReference[cbc:DocumentTypeCode='MUKELLEF_ADI']/cbc:DocumentType">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</td>
												</tr>
												<tr style="height:13px; ">
													<td style="width:40%;" align="left">
														<span style="font-weight:bold; ">
															<xsl:text>Dosya No:</xsl:text>
														</span>
													</td>
													<td style="width:60%;" align="left">
														<xsl:for-each select="n1:Invoice">
															<xsl:for-each select="cac:AdditionalDocumentReference[cbc:DocumentTypeCode='DOSYA_NO']/cbc:DocumentType">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</td>
												</tr>
												<tr style="height:13px; ">
													<td style="width:40%;" align="left">
														<span style="font-weight:bold; ">
															<xsl:text>Dönem:</xsl:text>
														</span>
													</td>
													<td style="width:60%;" align="left">
														<xsl:for-each select="n1:Invoice">
															<xsl:for-each select="cac:InvoicePeriod/cbc:StartDate">
																<xsl:apply-templates/>
															</xsl:for-each>
															<span>
																<xsl:text> / </xsl:text>
															</span>
															<xsl:for-each select="cac:InvoicePeriod/cbc:EndDate">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</td>
												</tr>
											</tbody>
										</table>
									</xsl:if>
								</td>
							</tr>
						</tbody>
					</table>
					<div id="lineTableAligner">
						<span>
							<xsl:text>&#xA0;</xsl:text>
						</span>
					</div>
					<table border="1" id="lineTable" class="fixedTableCss" width="800">
						<tbody>
							<tr id="lineTableTr">
								<td class="lineTableTd" style="width:4.3%;" align="center">
									<span style="font-weight:bold;">
										<xsl:text>Sıra No</xsl:text>
									</span>
								</td>
								<td id="malHizmet" class="lineTableTd" style="width:11%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>Mal Hizmet</xsl:text>
									</span>
								</td>
								<xsl:if test="count(//n1:Invoice/cac:InvoiceLine/cac:Item/cac:SellersItemIdentification/cbc:ID[. != '']) &gt; 0">
									<td class="lineTableTd" style="width:6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Satıcı Kodu</xsl:text>
										</span>
									</td>
								</xsl:if>
								<xsl:if test="count(//n1:Invoice/cac:InvoiceLine/cac:Item/cac:BuyersItemIdentification/cbc:ID[. != '']) &gt; 0">
									<td class="lineTableTd" style="width:6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Alıcı Kodu</xsl:text>
										</span>
									</td>
								</xsl:if>
								<td id="miktar" class="lineTableTd" style="width:7.2%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>Miktar</xsl:text>
									</span>
								</td>
								<td id="birimFiyat" class="lineTableTd" style="width:9.5%" align="center">
									<span style="font-weight:bold; ">
										<xsl:text>Birim Fiyat</xsl:text>
									</span>
								</td>
								<td id="iskontoOrani" class="lineTableTd" style="width:8%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>İskonto Oranı</xsl:text>
									</span>
								</td>
								<td id="iskontoTutari" class="lineTableTd" style="width:8.5%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>İskonto Tutarı</xsl:text>
									</span>
								</td>
								<xsl:if test="contains($hasAnyFalseChangeIndicator,'TRUE')">
									<td class="lineTableTd" style="width:7%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Artırım Tutarı</xsl:text>
										</span>
									</td>
								</xsl:if>
								<xsl:if test="not($senaryo = 'IHRACAT' or $senaryo = 'İHRACAT' )">
									<td class="lineTableTd" style="width:6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>KDV Oranı</xsl:text>
										</span>
									</td>
									<td class="lineTableTd" style="width:10%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>KDV Tutarı</xsl:text>
										</span>
									</td>
									<td id="digerVergiler" class="lineTableTdDiger" style="width:14%; " align="center">
										<span style="font-weight:bold;">
											<xsl:text>Diğer Vergiler</xsl:text>
										</span>
									</td>
								</xsl:if>
								<td class="lineTableTd" style="width:14.2%" align="center">
									<span style="font-weight:bold;">
										<xsl:text>Mal Hizmet Tutarı</xsl:text>
									</span>
								</td>
								<xsl:if test="//n1:Invoice/cbc:InvoiceTypeCode='OZELMATRAH' and count(//n1:Invoice/cac:InvoiceLine/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[./cbc:TaxExemptionReasonCode !='' and ./cac:TaxScheme/cbc:TaxTypeCode='0015']) > 0">
									<td class="lineTableTd" style="width:7%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Özel Matrah Nedeni</xsl:text>
										</span>
									</td>
									<td class="lineTableTd" style="width:7%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Özel Matrah Tutarı</xsl:text>
										</span>
									</td>
								</xsl:if>
								<xsl:if test="(//n1:Invoice/cbc:InvoiceTypeCode='SGK') and (//n1:Invoice/cbc:AccountingCost='SAGLIK_OPT')">
									<td class="lineTableTd" style="width:10.2%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>KDV Dahil Mal Hizmet Tutarı</xsl:text>
										</span>
									</td>
								</xsl:if>
								<xsl:if test="//n1:Invoice/cbc:ProfileID='HKS'">
									<td class="lineTableTd" style="width:11%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Künye Numarası</xsl:text>
										</span>
									</td>
								</xsl:if>
								<xsl:if
									test="//n1:Invoice/cbc:ProfileID='HKS' and /n1:Invoice/cbc:InvoiceTypeCode='SATIS'">
									<td class="lineTableTd" style="width:12%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Mal Sahibi VKN/TCKN</xsl:text>
										</span>
									</td>
									<td class="lineTableTd" style="width:10%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Mal Sahibi Ad/Soyad</xsl:text>
										</span>
									</td>
								</xsl:if>
								<xsl:if test="$senaryo = 'IHRACAT' or $senaryo = 'İHRACAT'">
									<td class="lineTableTd" style="width:6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Teslim Şartı</xsl:text>
										</span>
									</td>
									<td class="lineTableTd" style="width:7%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Eşya Kap Cinsi</xsl:text>
										</span>
									</td>
									<td class="lineTableTd" style="width:6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Kap No</xsl:text>
										</span>
									</td>
									<td class="lineTableTd" style="width:6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Kap Adet</xsl:text>
										</span>
									</td>
									<td class="lineTableTd" style="width:7%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Teslim/ Bedel Ödeme Yeri</xsl:text>
										</span>
									</td>
									<td class="lineTableTd" style="width:9%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>Gönderilme Şekli</xsl:text>
										</span>
									</td>
									<td class="lineTableTd" style="width:6%" align="center">
										<span style="font-weight:bold;">
											<xsl:text>GTİP</xsl:text>
										</span>
									</td>
								</xsl:if>
							</tr>
							<xsl:for-each select="//n1:Invoice/cac:InvoiceLine">
								<xsl:choose>
									<xsl:when test=".">
										<xsl:apply-templates select="."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:apply-templates select="//n1:Invoice"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:for-each>
				<br/>
				<div class="divContainer">
					<table width="800">
						<tr>
							<td>
								<table>
									<tr>
										<xsl:if test="//n1:Invoice/cbc:ProfileID='HKS' and //n1:Invoice/cbc:InvoiceTypeCode='KOMISYONCU'">
											<td align="left" valign="top" width="300px">
												<table border="1">
													<tbody>
														<xsl:if test="n1:Invoice/cac:AllowanceCharge">
															<tr align="left" border="1">
																<td align="left" width="200px" colspan="3">
																	<span style="font-weight:bold; ">
																		<b>Masraflar</b>
																	</span>
																</td>
															</tr>
														</xsl:if>
														<xsl:for-each select="n1:Invoice/cac:AllowanceCharge">
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSKOMISYON'">
																<tr align="left">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Komisyon - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSKOMISYONKDV'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Komisyon KDV - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSNAVLUN'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Navlun - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSNAVLUNKDV'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Navlun KDV - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSHAMMALIYE'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Hammaliye - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSHAMMALIYEKDV'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Hammaliye KDV - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSNAKLIYE'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Nakliye - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSNAKLIYEKDV'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Nakliye KDV - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSGVTEVKIFAT'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>G.V. Tevkifat - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSBAGKURTEVKIFAT'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Bağkur Tevkifat - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSRUSUM'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Rüsum - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSRUSUMKDV'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Rüsum KDV - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSTICBORSASI'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Ticaret Borsası - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSTICBORSASIKDV'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Ticaret Borsası KDV - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSMILLISAVUNMAFON'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Milli Savunma Fon - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSMSFONKDV'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Milli Savunma Fon KDV - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSDIGERMASRAFLAR'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Diğer Masraflar - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>
															<xsl:if test="cbc:AllowanceChargeReason = 'HKSDIGERKDV'">
																<tr align="right">
																	<td class="lineTableBudgetTd" align="right" width="200px">
																		<span style="font-weight:bold; ">
																			<xsl:text>Diğer KDV - %</xsl:text>
																		</span>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:Amount">
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																	<td class="lineTableBudgetTd" style="width:81px; " align="right">
																		<xsl:for-each
                                      select="cbc:MultiplierFactorNumeric">
																			<xsl:text> %</xsl:text>
																			<xsl:call-template name="Curr_Type">
																				<xsl:with-param name="valuePath" select="."/>
																				<xsl:with-param name="format" select="'###.##0,00'"/>
																			</xsl:call-template>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:if>

														</xsl:for-each>

													</tbody>
												</table>
											</td>
										</xsl:if>
									</tr>
								</table>
							</td>
							<td align="right" valign="top">
								<table id="budgetContainerTable" style="position:relative;" class="fixedTableCss" width="295px">
									<tbody>
										<xsl:if test="n1:Invoice/cbc:InvoiceTypeCode='SGK'">
											<xsl:variable name="grossPrescriptionAmount">
												<xsl:for-each select="n1:Invoice/cbc:Note">
													<xsl:if test = "contains(.,'SGK_BRT:')">
														<xsl:value-of select="normalize-space(substring-after(.,':'))"/>
													</xsl:if>
												</xsl:for-each>
											</xsl:variable>
											<xsl:if test="$grossPrescriptionAmount != ''">
												<tr id="budgetContainerTr" align="right">
													<td id="lineTableBudgetTd" align="right" width="200px">
														<span style="font-weight:bold; ">
															<xsl:text>Toplam Brüt Reçete Tutar</xsl:text>
														</span>
													</td>
													<td id="lineTableBudgetTd" align="right" width="85px">
														<span>
															<xsl:value-of select="format-number($grossPrescriptionAmount, '###.##0,00', 'european')"/>
															<xsl:text> TL</xsl:text>
														</span>
													</td>
												</tr>
											</xsl:if>
										</xsl:if>
										<xsl:if test="not($senaryo = 'IHRACAT' or $senaryo = 'İHRACAT')">
											<tr id="budgetContainerTr" align="right">
												<td id="lineTableBudgetTd" align="right" width="200px">
													<span style="font-weight:bold; ">
														<xsl:text>Mal Hizmet Toplam Tutarı</xsl:text>
													</span>
												</td>
												<td id="lineTableBudgetTd" align="right" width="85px">
													<span>
														<xsl:for-each select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount">
															<xsl:call-template name="Curr_Type">
																<xsl:with-param name="valuePath" select="."/>
																<xsl:with-param name="format" select="'###.##0,00'"/>
															</xsl:call-template>
														</xsl:for-each>
													</span>
												</td>
											</tr>
										</xsl:if>
										<xsl:if test="$senaryo = 'IHRACAT' or $senaryo = 'İHRACAT'">
											<tr id="budgetContainerTr" align="right">
												<td id="lineTableBudgetTd" align="right" width="200px">
													<span style="font-weight:bold; ">
														<xsl:text>Mal Hizmet Toplam Tutarı</xsl:text>
													</span>
												</td>
												<td id="lineTableBudgetTd" align="right" width="85px">
													<span>
														<xsl:value-of select="format-number((//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount ), '###.##0,00', 'european')"/>
														<xsl:text> </xsl:text>
														<xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID ='TRY' or //n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID = 'TRL'">
															<xsl:text>TL</xsl:text>
														</xsl:if>
														<xsl:if test="not(//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID ='TRY' or //n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID = 'TRL')">
															<xsl:value-of select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID"/>
														</xsl:if>
													</span>
												</td>
											</tr>
											<xsl:if test="//n1:Invoice/cac:Delivery/cac:Shipment/cbc:FreeOnBoardValueAmount !='' and number(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:FreeOnBoardValueAmount)  &gt; 0 ">
												<tr id="budgetContainerTr" align="right">
													<td id="lineTableBudgetTd" align="right" width="200px">
														<span style="font-weight:bold; ">
															<xsl:text>FOB Tutar</xsl:text>
														</span>
													</td>
													<td id="lineTableBudgetTd" align="right">
														<span>
															<xsl:for-each select="//n1:Invoice/cac:Delivery/cac:Shipment/cbc:FreeOnBoardValueAmount">
																<xsl:call-template name="Curr_Type">
																	<xsl:with-param name="valuePath" select="."/>
																	<xsl:with-param name="format" select="'###.##0,00'"/>
																</xsl:call-template>
															</xsl:for-each>
														</span>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="//n1:Invoice/cac:Delivery/cac:Shipment/cbc:DeclaredForCarriageValueAmount !='' and number(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:DeclaredForCarriageValueAmount)  &gt; 0 ">
												<tr id="budgetContainerTr" align="right">
													<td id="lineTableBudgetTd" align="right" width="200px">
														<span style="font-weight:bold; ">
															<xsl:text>Nakliye Bedeli</xsl:text>
														</span>
													</td>
													<td id="lineTableBudgetTd" align="right">
														<span>
															<xsl:for-each select="//n1:Invoice/cac:Delivery/cac:Shipment/cbc:DeclaredForCarriageValueAmount">
																<xsl:call-template name="Curr_Type">
																	<xsl:with-param name="valuePath" select="."/>
																	<xsl:with-param name="format" select="'###.##0,00'"/>
																</xsl:call-template>
															</xsl:for-each>
														</span>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="//n1:Invoice/cac:Delivery/cac:Shipment/cbc:InsuranceValueAmount !='' and number(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:InsuranceValueAmount)  &gt; 0 ">
												<tr id="budgetContainerTr" align="right">
													<td id="lineTableBudgetTd" align="right" width="200px">
														<span style="font-weight:bold; ">
															<xsl:text>Sigorta Bedeli</xsl:text>
														</span>
													</td>
													<td id="lineTableBudgetTd" align="right">
														<span>
															<xsl:for-each select="//n1:Invoice/cac:Delivery/cac:Shipment/cbc:InsuranceValueAmount">
																<xsl:call-template name="Curr_Type">
																	<xsl:with-param name="valuePath" select="."/>
																	<xsl:with-param name="format" select="'###.##0,00'"/>
																</xsl:call-template>
															</xsl:for-each>
														</span>
													</td>
												</tr>
											</xsl:if>
										</xsl:if>
										<xsl:if test="n1:Invoice/cbc:InvoiceTypeCode='SGK'">
											<xsl:for-each select="//n1:Invoice/cbc:Note">
												<xsl:if test="contains(. , 'Toplam Katılım Payı :')">
													<tr id="budgetContainerTr" align="right">
														<td id="lineTableBudgetTd" align="right">
															<span style="font-weight:bold; ">
																<xsl:text>Toplam Katılım Payı</xsl:text>
															</span>
														</td>
														<td id="lineTableBudgetTd" align="right">
															<xsl:value-of select="substring-after(., ':')" />
															<xsl:text> TL</xsl:text>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
											<tr id="budgetContainerTr" align="right">
												<td id="lineTableBudgetTd" align="right" width="200px">
													<span style="font-weight:bold; ">
														<xsl:text>KDV Hariç Toplam Tutar</xsl:text>
													</span>
												</td>
												<td id="lineTableBudgetTd" style="width:81px; " align="right">
													<span>
														<xsl:for-each select="n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxExclusiveAmount">
															<xsl:call-template name="Curr_Type">
																<xsl:with-param name="valuePath" select="."/>
																<xsl:with-param name="format" select="'###.##0,00'"/>
															</xsl:call-template>
														</xsl:for-each>
													</span>
												</td>
											</tr>
										</xsl:if>
										<xsl:if test="n1:Invoice/cbc:InvoiceTypeCode!='SGK'">
											<tr id="budgetContainerTr" align="right">
												<td id="lineTableBudgetTd" align="right">
													<span style="font-weight:bold; ">
														<xsl:text>Toplam İskonto</xsl:text>
													</span>
												</td>
												<td id="lineTableBudgetTd" align="right">
													<span>
														<xsl:for-each select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount">
															<xsl:call-template name="Curr_Type">
																<xsl:with-param name="valuePath" select="."/>
																<xsl:with-param name="format" select="'###.##0,00'"/>
															</xsl:call-template>
														</xsl:for-each>
													</span>
												</td>
											</tr>
										</xsl:if>
										<xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount !='' and number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount) &gt; 0">
											<tr id="budgetContainerTr" align="right">
												<td id="lineTableBudgetTd" align="right">
													<span style="font-weight:bold; ">
														<xsl:text>Toplam Artırım</xsl:text>
													</span>
												</td>
												<td id="lineTableBudgetTd" align="right">
													<span>
														<xsl:for-each select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount">
															<xsl:call-template name="Curr_Type">
																<xsl:with-param name="valuePath" select="."/>
																<xsl:with-param name="format" select="'###.##0,00'"/>
															</xsl:call-template>
														</xsl:for-each>
													</span>
												</td>
											</tr>
										</xsl:if>
										<xsl:for-each select="//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
											<tr id="budgetContainerTr" align="right">
												<td id="lineTableBudgetTd" align="right">
													<span style="font-weight:bold; ">
														<xsl:text>Hesaplanan </xsl:text>
														<xsl:value-of select="cac:TaxCategory/cac:TaxScheme/cbc:Name"/>
														<xsl:text>(%</xsl:text>
														<xsl:value-of select="cbc:Percent"/>
														<xsl:text>)</xsl:text>
													</span>
												</td>
												<td id="lineTableBudgetTd" align="right">
													<xsl:for-each select="cac:TaxCategory/cac:TaxScheme">
														<xsl:text> </xsl:text>
														<xsl:call-template name="Curr_Type">
															<xsl:with-param name="valuePath" select="../../cbc:TaxAmount"/>
															<xsl:with-param name="format" select="'###.##0,00'"/>
														</xsl:call-template>
													</xsl:for-each>
												</td>
											</tr>
										</xsl:for-each>
										<xsl:for-each select="//n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal">
											<xsl:if test="cbc:TaxAmount != ''">
												<tr id="budgetContainerTr" align="right">
													<td id="lineTableBudgetTd" align="right">
														<span style="font-weight:bold; ">
															<xsl:text>KDV Tevkifat-[</xsl:text>
															<xsl:value-of select="cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode"/>
															<xsl:text>]-</xsl:text>
															<xsl:text>(%</xsl:text>
															<xsl:value-of select="cbc:Percent"/>
															<xsl:text>)</xsl:text>
														</span>
													</td>
													<td id="lineTableBudgetTd" align="right">
														<xsl:for-each select="cac:TaxCategory/cac:TaxScheme">
															<xsl:text> </xsl:text>
															<xsl:call-template name="Curr_Type">
																<xsl:with-param name="valuePath" select="../../cbc:TaxAmount"/>
																<xsl:with-param name="format" select="'###.##0,00'"/>
															</xsl:call-template>
														</xsl:for-each>
													</td>
												</tr>
											</xsl:if>
										</xsl:for-each>
										<xsl:if test="n1:Invoice/cbc:InvoiceTypeCode!='SGK'">
											<tr id="budgetContainerTr" align="right">
												<td id="lineTableBudgetTd" align="right">
													<span style="font-weight:bold; ">
														<xsl:text>Vergiler Dahil Toplam Tutar</xsl:text>
													</span>
												</td>
												<td id="lineTableBudgetTd" align="right">
													<xsl:for-each select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount">
														<xsl:call-template name="Curr_Type">
															<xsl:with-param name="valuePath" select="."/>
															<xsl:with-param name="format" select="'###.##0,00'"/>
														</xsl:call-template>
													</xsl:for-each>
												</td>
											</tr>
										</xsl:if>
										<xsl:if test="//n1:Invoice/cbc:ProfileID='HKS' and //n1:Invoice/cbc:InvoiceTypeCode='KOMISYONCU'">
											<tr id="budgetContainerTr" align="right">
												<td id="lineTableBudgetTd" align="right">
													<span style="font-weight:bold; ">
														<xsl:text>Toplam Masraflar</xsl:text>
													</span>
												</td>
												<td id="lineTableBudgetTd" align="right">
													<xsl:for-each
                            select="n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount">
														<xsl:call-template name="Curr_Type">
															<xsl:with-param name="valuePath" select="."/>
															<xsl:with-param name="format" select="'###.##0,00'"/>
														</xsl:call-template>
													</xsl:for-each>
												</td>
											</tr>
										</xsl:if>
										<tr id="budgetContainerTr" align="right">
											<td id="lineTableBudgetTd" align="right">
												<span style="font-weight:bold; ">
													<xsl:choose>
														<xsl:when test="//n1:Invoice/cbc:InvoiceTypeCode='SGK'">
															<xsl:text>Ödenecek Net Tutar</xsl:text>
														</xsl:when>
														<xsl:otherwise>
															<xsl:text>Ödenecek Tutar</xsl:text>
														</xsl:otherwise>
													</xsl:choose>
												</span>
											</td>
											<td id="lineTableBudgetTd" align="right">
												<xsl:for-each select="//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount">
													<xsl:call-template name="Curr_Type">
														<xsl:with-param name="valuePath" select="."/>
														<xsl:with-param name="format" select="'###.##0,00'"/>
													</xsl:call-template>
												</xsl:for-each>
											</td>
										</tr>
										<xsl:if test="not(//n1:Invoice/cbc:DocumentCurrencyCode = 'TRY' or //n1:Invoice/cbc:DocumentCurrencyCode = 'TRL')">
											<xsl:if test="not($senaryo = 'IHRACAT' or $senaryo = 'İHRACAT')">
												<xsl:if test="not(//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID ='TRY' or //n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID ='TRL')">
													<tr align="right">
														<td id="lineTableBudgetTd" align="right">
															<span style="font-weight:bold; ">
																<xsl:text>Mal Hizmet Toplam Tutarı(TL)</xsl:text>
															</span>
														</td>
														<td id="lineTableBudgetTd" align="right">
															<span>
																<xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
																<xsl:text> TL</xsl:text>
															</span>
														</td>
													</tr>
												</xsl:if>
											</xsl:if>
											<xsl:if test="$senaryo = 'IHRACAT' or $senaryo = 'İHRACAT'">
												<xsl:if test="not(//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID ='TRY' or //n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount/@currencyID ='TRL')">
													<tr align="right">
														<td id="lineTableBudgetTd" align="right">
															<span style="font-weight:bold; ">
																<xsl:text>Mal Hizmet Toplam Tutarı(TL)</xsl:text>
															</span>
														</td>
														<td id="lineTableBudgetTd" align="right">
															<span>
																<span>
																	<xsl:value-of select="format-number((//n1:Invoice/cac:LegalMonetaryTotal/cbc:LineExtensionAmount ) * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
																	<xsl:text> TL</xsl:text>
																</span>
															</span>
														</td>
													</tr>
												</xsl:if>
												<xsl:if test="//n1:Invoice/cac:Delivery/cac:Shipment/cbc:FreeOnBoardValueAmount !='' and number(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:FreeOnBoardValueAmount)  &gt; 0 ">
													<xsl:if test="not(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:FreeOnBoardValueAmount/@currencyID ='TRY' or //n1:Invoice/cac:Delivery/cac:Shipment/cbc:FreeOnBoardValueAmount/@currencyID ='TRL')">
														<tr align="right">
															<td id="lineTableBudgetTd" align="right">
																<span style="font-weight:bold; ">
																	<xsl:text>FOB Tutar(TL)</xsl:text>
																</span>
															</td>
															<td id="lineTableBudgetTd" align="right">
																<span>
																	<xsl:value-of select="format-number(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:FreeOnBoardValueAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
																	<xsl:text> TL</xsl:text>
																</span>
															</td>
														</tr>
													</xsl:if>
												</xsl:if>
												<xsl:if test="//n1:Invoice/cac:Delivery/cac:Shipment/cbc:DeclaredForCarriageValueAmount !='' and number(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:DeclaredForCarriageValueAmount)  &gt; 0 ">
													<xsl:if test="not(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:DeclaredForCarriageValueAmount/@currencyID ='TRY' or //n1:Invoice/cac:Delivery/cac:Shipment/cbc:DeclaredForCarriageValueAmount/@currencyID ='TRL')">
														<tr align="right">
															<td id="lineTableBudgetTd" align="right">
																<span style="font-weight:bold; ">
																	<xsl:text>Nakliye Bedeli(TL)</xsl:text>
																</span>
															</td>
															<td id="lineTableBudgetTd" align="right">
																<span>
																	<xsl:value-of select="format-number(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:DeclaredForCarriageValueAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
																	<xsl:text> TL</xsl:text>
																</span>
															</td>
														</tr>
													</xsl:if>
												</xsl:if>
												<xsl:if test="//n1:Invoice/cac:Delivery/cac:Shipment/cbc:InsuranceValueAmount !='' and number(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:InsuranceValueAmount)  &gt; 0 ">
													<xsl:if test="not(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:InsuranceValueAmount/@currencyID ='TRY' or //n1:Invoice/cac:Delivery/cac:Shipment/cbc:InsuranceValueAmount/@currencyID ='TRL')">
														<tr align="right">
															<td id="lineTableBudgetTd" align="right">
																<span style="font-weight:bold; ">
																	<xsl:text>Sigorta Bedeli(TL)</xsl:text>
																</span>
															</td>
															<td id="lineTableBudgetTd" align="right">
																<span>
																	<xsl:value-of select="format-number(//n1:Invoice/cac:Delivery/cac:Shipment/cbc:InsuranceValueAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
																	<xsl:text> TL</xsl:text>
																</span>
															</td>
														</tr>
													</xsl:if>
												</xsl:if>
											</xsl:if>
											<xsl:if test="n1:Invoice/cbc:InvoiceTypeCode='SGK'">
												<tr id="budgetContainerTr" align="right">
													<td id="lineTableBudgetTd" align="right">
														<span style="font-weight:bold; ">
															<xsl:text>KDV Hariç Toplam Tutar(TL)</xsl:text>
														</span>
													</td>
													<td id="lineTableBudgetTd" align="right">
														<span>
															<xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxExclusiveAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
															<xsl:text> TL</xsl:text>
														</span>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not(//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID ='TRY' or //n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount/@currencyID ='TRL')  and n1:Invoice/cbc:InvoiceTypeCode!='SGK'">
												<tr id="budgetContainerTr" align="right">
													<td id="lineTableBudgetTd" align="right">
														<span style="font-weight:bold; ">
															<xsl:text>Toplam İskonto(TL)</xsl:text>
														</span>
													</td>
													<td id="lineTableBudgetTd" align="right">
														<span>
															<xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:AllowanceTotalAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
															<xsl:text> TL</xsl:text>
														</span>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not(//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount/@currencyID ='TRY' or //n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount/@currencyID ='TRL')">
												<xsl:if test="//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount !='' and number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount) &gt; 0">
													<tr id="budgetContainerTr" align="right">
														<td id="lineTableBudgetTd" align="right">
															<span style="font-weight:bold; ">
																<xsl:text>Toplam Artırım(TL)</xsl:text>
															</span>
														</td>
														<td id="lineTableBudgetTd" align="right">
															<span>
																<xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:ChargeTotalAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
																<xsl:text> TL</xsl:text>
															</span>
														</td>
													</tr>
												</xsl:if>
											</xsl:if>
											<xsl:for-each select="//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
												<xsl:if test="not(cbc:TaxAmount/@currencyID = 'TRY' or cbc:TaxAmount/@currencyID = 'TRL')">
													<tr align="right">
														<td id="lineTableBudgetTd" align="right">
															<span style="font-weight:bold; ">
																<xsl:text>Hesaplanan </xsl:text>
																<xsl:value-of select="cac:TaxCategory/cac:TaxScheme/cbc:Name"/>
																<xsl:text>(%</xsl:text>
																<xsl:value-of select="cbc:Percent"/>
																<xsl:text>)(TL)</xsl:text>
															</span>
														</td>
														<td id="lineTableBudgetTd" align="right">
															<span>
																<xsl:value-of select="format-number(cbc:TaxAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
																<xsl:text> TL</xsl:text>
															</span>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
											<xsl:for-each select="//n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal">
												<xsl:if test="not(cbc:TaxAmount/@currencyID = 'TRY' or cbc:TaxAmount/@currencyID = 'TRL') and cbc:TaxAmount != ''">
													<tr id="budgetContainerTr" align="right">
														<td id="lineTableBudgetTd" align="right">
															<span style="font-weight:bold; ">
																<xsl:text>KDV Tevkifat-[</xsl:text>
																<xsl:value-of select="cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode"/>
																<xsl:text>]-</xsl:text>
																<xsl:text>(%</xsl:text>
																<xsl:value-of select="cbc:Percent"/>
																<xsl:text>)(TL)</xsl:text>
															</span>
														</td>
														<td id="lineTableBudgetTd" align="right">
															<xsl:for-each select="cac:TaxCategory/cac:TaxScheme">
																<xsl:text> </xsl:text>
																<xsl:value-of select="format-number(../../cbc:TaxAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
																<xsl:text> TL</xsl:text>
															</xsl:for-each>
														</td>
													</tr>
												</xsl:if>
											</xsl:for-each>
											<xsl:if test="not(//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID ='TRY' or //n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount/@currencyID ='TRL') and n1:Invoice/cbc:InvoiceTypeCode!='SGK'">
												<tr id="budgetContainerTr" align="right">
													<td id="lineTableBudgetTd" align="right">
														<span style="font-weight:bold; ">
															<xsl:text>Vergiler Dahil Toplam Tutar(TL)</xsl:text>
														</span>
													</td>
													<td id="lineTableBudgetTd" align="right">
														<xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:TaxInclusiveAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
														<xsl:text> TL</xsl:text>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="not(//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID ='TRY' or //n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount/@currencyID ='TRL')">
												<tr align="right">
													<td id="lineTableBudgetTd" align="right">
														<span style="font-weight:bold; ">
															<xsl:text>Ödenecek Tutar(TL)</xsl:text>
														</span>
													</td>
													<td id="lineTableBudgetTd" align="right">
														<xsl:value-of select="format-number(//n1:Invoice/cac:LegalMonetaryTotal/cbc:PayableAmount * //n1:Invoice/cac:PricingExchangeRate/cbc:CalculationRate, '###.##0,00', 'european')"/>
														<xsl:text> TL</xsl:text>
													</td>
												</tr>
											</xsl:if>
										</xsl:if>
									</tbody>
								</table>
							</td>
						</tr>
					</table>
				</div>
				<br/>
				<xsl:if test="//n1:Invoice/cac:BillingReference/cac:InvoiceDocumentReference/cbc:DocumentType[translate(text(),'abcçdefgğhıijklmnoöpqrsştuüvwxyz','ABCÇDEFGĞHIİJKLMNOÖPQRSŞTUÜVWXYZ')='FATURA']">
					<table id="lineTable" class="fixedTableCss" width="800">
						<thead>
							<tr id="lineTableTr">
								<td class="lineTableTd" align="center" colspan="2">
									<span style="font-weight:bold; ">İadeye Konu Olan Faturalar</span>
								</td>
							</tr>
						</thead>
						<tbody>
							<tr id="lineTableTr" align="left">
								<td class="lineTableTd">
									<span style="font-weight:bold; " align="center">&#xA0;&#xA0;&#xA0;&#xA0;&#xA0;Fatura No</span>
								</td>
								<td class="lineTableTd">
									<span style="font-weight:bold; " align="center">&#xA0;&#xA0;&#xA0;&#xA0;&#xA0;Tarih</span>
								</td>
							</tr>
							<xsl:for-each select="//n1:Invoice/cac:BillingReference/cac:InvoiceDocumentReference/cbc:DocumentType[translate(text(),'abcçdefgğhıijklmnoöpqrsştuüvwxyz','ABCÇDEFGĞHIİJKLMNOÖPQRSŞTUÜVWXYZ')='FATURA']">
								<tr id="lineTableTr" align="left">
									<td class="lineTableTd">
										&#xA0;&#xA0;&#xA0;&#xA0;&#xA0; <xsl:value-of select="../cbc:ID"/>
									</td>
									<td class="lineTableTd">
										&#xA0;&#xA0;&#xA0;&#xA0;&#xA0; <xsl:for-each select="../cbc:IssueDate">
											<xsl:apply-templates select="."/>
										</xsl:for-each>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
					<br/>
				</xsl:if>
				<xsl:if test="//n1:Invoice/cac:BillingReference/cac:AdditionalDocumentReference/cbc:DocumentTypeCode='OKCBF'">
					<table id="lineTable" class="fixedTableCss" width="800" border="1">
						<thead>
							<tr>
								<th colspan="6">ÖKC Bilgileri</th>
							</tr>
						</thead>
						<tbody>
							<tr id="okcbfHeadTr" style="font-weight:bold;">
								<td style="width:20%">
									<xsl:text>Fiş Numarası</xsl:text>
								</td>
								<td style="width:10%" align="center">
									<xsl:text>Fiş Tarihi</xsl:text>
								</td>
								<td style="width:10%" align="center">
									<xsl:text>Fiş Saati</xsl:text>
								</td>
								<td style="width:40%" align="center">
									<xsl:text>Fiş Tipi</xsl:text>
								</td>
								<td style="width:10%" align="center">
									<xsl:text>Z Rapor No</xsl:text>
								</td>
								<td style="width:10%" align="center">
									<xsl:text>ÖKC Seri No</xsl:text>
								</td>
							</tr>
						</tbody>
						<xsl:for-each select="//n1:Invoice/cac:BillingReference/cac:AdditionalDocumentReference/cbc:DocumentTypeCode[text()='OKCBF']">
							<tr>
								<td style="width:20%">
									<xsl:value-of select="../cbc:ID"/>
								</td>
								<td style="width:10%" align="center">
									<xsl:value-of select="../cbc:IssueDate"/>
								</td>
								<td style="width:10%" align="center">
									<xsl:value-of select="substring(../cac:ValidityPeriod/cbc:StartTime,1,5)"/>
								</td>
								<td style="width:40%" align="center">
									<xsl:choose>
										<xsl:when test="../cbc:DocumentDescription='AVANS'">
											<xsl:text>Ön Tahsilat(Avans) Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='YEMEK_FIS'">
											<xsl:text>Yemek Fişi/Kartı ile Yapılan Tahsilat Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='E-FATURA'">
											<xsl:text>E-Fatura Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='E-FATURA_IRSALIYE'">
											<xsl:text>İrsaliye Yerine Geçen E-Fatura Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='E-ARSIV'">
											<xsl:text>E-Arşiv Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='E-ARSIV_IRSALIYE'">
											<xsl:text>İrsaliye Yerine Geçen E-Arşiv Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='FATURA'">
											<xsl:text>Faturalı Satış Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='OTOPARK'">
											<xsl:text>Otopark Giriş Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='FATURA_TAHSILAT'">
											<xsl:text>Fatura Tahsilat Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:when test="../cbc:DocumentDescription='FATURA_TAHSILAT_KOMISYONLU'">
											<xsl:text>Komisyonlu Fatura Tahsilat Bilgi Fişi</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text> </xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td style="width:10%" align="center">
									<xsl:value-of select="../cac:Attachment/cac:ExternalReference/cbc:URI"/>
								</td>
								<td style="width:10%" align="center">
									<xsl:value-of select="../cac:IssuerParty/cbc:EndpointID"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
					<br/>
				</xsl:if>
				<xsl:if test="count(//n1:Invoice/cac:DespatchDocumentReference/cbc:ID) &gt; 1">
					<table id="despatchDocumentReferenceTable" class="fixedTableCss" width="800">
						<tr>
							<td align="left" style="padding: 4px 5px; border: 2px solid black;width:145px;">
								<span style="font-weight:bold; ">
									<xsl:text>İrsaliye No ve Tarihleri :</xsl:text>
								</span>
							</td>
							<td style="padding: 4px 5px; border: 2px solid black;">
								<xsl:for-each select="//n1:Invoice/cac:DespatchDocumentReference">
									<xsl:if test="cbc:ID !='' and cbc:IssueDate !=''">
										<xsl:value-of select="cbc:ID"/>
										<xsl:text>&#xA0;&#xA0;(</xsl:text>
										<xsl:value-of select="substring(cbc:IssueDate,9,2)"/>-<xsl:value-of select="substring(cbc:IssueDate,6,2)"/>-<xsl:value-of select="substring(cbc:IssueDate,1,4)"/>
										<xsl:text>)</xsl:text>
										<xsl:if test="position() != last()">
											<xsl:text>&#xA0;&#xA0;|&#xA0;&#xA0;</xsl:text>
										</xsl:if>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<br/>
				</xsl:if>
				<table id="notesTable" class="fixedTableCss" width="800" height="100">
					<tbody>
						<tr align="left">
							<td id="notesTableTd">
								<xsl:if test="not($senaryo = 'IHRACAT' or $senaryo = 'İHRACAT' or $senaryo = 'YOLCUBERABERFATURA' or $senaryo = 'YOLCUBERABER' or //n1:Invoice/cbc:InvoiceTypeCode = 'OZELMATRAH')">
									<xsl:choose>
										<xsl:when test="//n1:Invoice/cbc:InvoiceTypeCode = 'IHRACKAYITLI'">
											<xsl:for-each select="//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
												<xsl:if test="cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode='0015' and cac:TaxCategory/cbc:TaxExemptionReason != ''">
													<b>Vergi İstisna Muafiyet Sebebi:&#xA0;</b>
													<xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReason"/>
													<br/>
												</xsl:if>
											</xsl:for-each>
											<xsl:if test="count(//n1:Invoice/cac:InvoiceLine/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[./cbc:TaxExemptionReasonCode='701'])>0">
												3065 sayılı KDV Kanunu'nun 11/1-c maddesi hükümlerine göre ihraç edilmek şartıyla teslim edildiğinden KDV tahsil edilmemiştir.
												<br/>
											</xsl:if>
										</xsl:when>
										<xsl:otherwise>
											<xsl:for-each select="//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
												<xsl:if test="cbc:TaxAmount=0 and cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode='0015' and cac:TaxCategory/cbc:TaxExemptionReason != ''">
													<b>Vergi İstisna Muafiyet Sebebi:&#xA0;</b>
													<xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReason"/>
													<br/>
												</xsl:if>
											</xsl:for-each>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
								<xsl:if test="$senaryo = 'IHRACAT' or $senaryo = 'İHRACAT' or $senaryo = 'YOLCUBERABERFATURA' or $senaryo = 'YOLCUBERABER' or //n1:Invoice/cbc:InvoiceTypeCode = 'OZELMATRAH'">
									<xsl:for-each select="//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
										<xsl:if test="cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode='0015' and cac:TaxCategory/cbc:TaxExemptionReason != ''">
											<b>Vergi İstisna Muafiyet Sebebi:&#xA0;</b>
											<xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReason"/>
											<br/>
										</xsl:if>
									</xsl:for-each>
								</xsl:if>
								<xsl:for-each select="//n1:Invoice/cac:TaxTotal/cac:TaxSubtotal">
									<xsl:if test="starts-with(cac:TaxCategory/cac:TaxScheme/cbc:TaxTypeCode,'007') and cac:TaxCategory/cbc:TaxExemptionReason != ''">
										<b>ÖTV İstisna Muafiyet Sebebi:&#xA0;</b>
										<xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReasonCode"/>
										<xsl:text>-</xsl:text>
										<xsl:value-of select="cac:TaxCategory/cbc:TaxExemptionReason"/>
										<br/>
									</xsl:if>
								</xsl:for-each>
								<xsl:for-each select="//n1:Invoice/cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
									<xsl:if test="cbc:TaxTypeCode != '' or cbc:Name != ''">
										<b>Tevkifat Sebebi:&#xA0;</b>
										<xsl:value-of select="cbc:TaxTypeCode"/>
										<xsl:text>-</xsl:text>
										<xsl:value-of select="cbc:Name"/>
										<br/>
									</xsl:if>
								</xsl:for-each>
								<xsl:for-each select="//n1:Invoice/cbc:Note">
									<xsl:if test=".!= ''">
										<xsl:value-of select="."/>
										<br/>
									</xsl:if>
								</xsl:for-each>
								
								<br/>
								<xsl:if test="//n1:Invoice/cac:PaymentMeans/cbc:InstructionNote !='' ">
									<b>Ödeme Notu:&#xA0;</b>
									<xsl:value-of select="//n1:Invoice/cac:PaymentMeans/cbc:InstructionNote"/>
									<br/>
								</xsl:if>
								<xsl:if test="//n1:Invoice/cac:PaymentMeans/cac:PayeeFinancialAccount/cbc:PaymentNote !='' ">
									<b>Hesap Açıklaması:&#xA0;</b>
									<xsl:value-of select="//n1:Invoice/cac:PaymentMeans/cac:PayeeFinancialAccount/cbc:PaymentNote"/>
									<br/>
								</xsl:if>
								<xsl:if test="//n1:Invoice/cac:PaymentTerms/cbc:Note !='' ">
									<b>Ödeme Koşulu:&#xA0;</b>
									<xsl:value-of select="//n1:Invoice/cac:PaymentTerms/cbc:Note"/>
									<br/>
								</xsl:if>
							</td>
						</tr>
					</tbody>
				</table>
				<xsl:variable name="hasBankInfo"><span style="font-weight: bold;">TR69 0020 5000 0089 7275 5000 01 - KUVEYTTÜRK KATILIM BANKASI</span><div style=""><b>TR55 0021 0000 0009 8422 8000 01 - VAKIF KATILIM BANKASI<br /></b><div style="font-weight: normal;"><span style="font-weight: bold;">TR42 0001 0025 2836 9862 8750 02 - ZİRAAT BANKASI</span></div></div></xsl:variable>
				<xsl:if test="$hasBankInfo">
					<table id="hesapBilgileri" style="padding: 5px 0px; width:100%; margin-top:5px;width:800px;">
						<tbody>
							<tr>
								<td style="width:100%">
									<fieldset style="padding: 3px; margin-left: -1px;border: 1px solid black;">
										<legend style="background-color:white">
											<b>Hesap Bilgileri</b>
										</legend>
										<span style="font-weight: bold;">TR69 0020 5000 0089 7275 5000 01 - KUVEYTTÜRK KATILIM BANKASI</span><div style=""><b>TR55 0021 0000 0009 8422 8000 01 - VAKIF KATILIM BANKASI<br /></b><div style="font-weight: normal;"><span style="font-weight: bold;">TR42 0001 0025 2836 9862 8750 02 - ZİRAAT BANKASI</span></div></div>
									</fieldset>
								</td>
							</tr>
						</tbody>
					</table>
				</xsl:if>
				<xsl:variable name="hasAddUseAsDespatchNote">True</xsl:variable>
				<xsl:if test="boolean($hasAddUseAsDespatchNote='True')">
					<table style="width:800px;">
						<tbody>
							<tr>
								<td style="font-weight: bold; font-size: 12px; text-align:right;padding-top:10px;padding-bottom:10px;">İRSALİYE YERİNE GEÇER.</td>
							</tr>
						</tbody>
					</table>
				</xsl:if>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="dateFormatter">
		<xsl:value-of select="substring(.,9,2)"/>-<xsl:value-of select="substring(.,6,2)"/>-<xsl:value-of select="substring(.,1,4)"/>
	</xsl:template>
	<xsl:template match="//n1:Invoice/cac:InvoiceLine">
		<tr id="lineTableTr">
			<td class="lineTableTd">
				<xsl:text> </xsl:text>
				<xsl:value-of select="./cbc:ID"/>
			</td>
			<td class="lineTableTd">
				<xsl:text> </xsl:text>
				<xsl:value-of select="./cac:Item/cbc:Name"/>
			</td>
			<xsl:if test="count(//n1:Invoice/cac:InvoiceLine/cac:Item/cac:SellersItemIdentification/cbc:ID[. != '']) &gt; 0">
				<td class="lineTableTd">
					<xsl:text>&#160;</xsl:text>
					<xsl:value-of select="./cac:Item/cac:SellersItemIdentification/cbc:ID"/>
				</td>
			</xsl:if>
			<xsl:if test="count(//n1:Invoice/cac:InvoiceLine/cac:Item/cac:BuyersItemIdentification/cbc:ID[. != '']) &gt; 0">
				<td class="lineTableTd">
					<xsl:text>&#160;</xsl:text>
					<xsl:value-of select="./cac:Item/cac:BuyersItemIdentification/cbc:ID"/>
				</td>
			</xsl:if>
			<td class="lineTableTd" align="right">
				<xsl:value-of select="format-number(./cbc:InvoicedQuantity, '###.##0,####', 'european')"/>
				<xsl:if test="./cbc:InvoicedQuantity/@unitCode">
					<xsl:for-each select="./cbc:InvoicedQuantity">
						<xsl:text/>
						<xsl:choose>
							<xsl:when test="@unitCode  = 'C62'">
								<span>
									<xsl:text> Adet</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'NIU'">
								<span>
									<xsl:text> Adet</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'AS'">
								<span>
									<xsl:text> Asorti</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MON'">
								<span>
									<xsl:text> Ay</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'FOT'">
								<span>
									<xsl:text> Ayak</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'D92'">
								<span>
									<xsl:text> Bant</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'BAR'">
								<span>
									<xsl:text> Bar</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'BR'">
								<span>
									<xsl:text> Bar</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'EA'">
								<span>
									<xsl:text> Beher</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = '2W'">
								<span>
									<xsl:text> Bidon</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = '4A'">
								<span>
									<xsl:text> Bobin</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CL'">
								<span>
									<xsl:text> Bobin</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'GRO'">
								<span>
									<xsl:text> Brüt</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'E4'">
								<span>
									<xsl:text> Brüt Kg</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'GT'">
								<span>
									<xsl:text> Brüt Ton</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'GD'">
								<span>
									<xsl:text> Brüt Varil</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'AD'">
								<span>
									<xsl:text> Byte</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CGM'">
								<span>
									<xsl:text> Cgm</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'PR'">
								<span>
									<xsl:text> Çift</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'HA'">
								<span>
									<xsl:text> Çile</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CLT'">
								<span>
									<xsl:text> Clt.</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CMT'">
								<span>
									<xsl:text> Cm</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CMK'">
								<span>
									<xsl:text> Cm²</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CMQ'">
								<span>
									<xsl:text> Cm³</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'RD'">
								<span>
									<xsl:text> Çubuk</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'SA'">
								<span>
									<xsl:text> Çuval</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'D79'">
								<span>
									<xsl:text> Demet</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'A49'">
								<span>
									<xsl:text> Denye</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'DC'">
								<span>
									<xsl:text> Disk</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'D61'">
								<span>
									<xsl:text> Dk.</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MIN'">
								<span>
									<xsl:text> Dk.</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'DLT'">
								<span>
									<xsl:text> Dlt.</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'DMK'">
								<span>
									<xsl:text> Dm²</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'DMT'">
								<span>
									<xsl:text> Dm</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'DPC'">
								<span>
									<xsl:text> Düzine</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'DPR'">
								<span>
									<xsl:text> Düzine</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'DRL'">
								<span>
									<xsl:text> Düzine</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'DZN'">
								<span>
									<xsl:text> Düzine</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'DZP'">
								<span>
									<xsl:text> Düzine</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = '5H'">
								<span>
									<xsl:text> Faz</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'Z3'">
								<span>
									<xsl:text> Fıçı</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'BH'">
								<span>
									<xsl:text> Fırça</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'A76'">
								<span>
									<xsl:text> Gal.</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'GB'">
								<span>
									<xsl:text> Galon</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'GLI'">
								<span>
									<xsl:text> Galon</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'GLL'">
								<span>
									<xsl:text> Galon</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'GRM'">
								<span>
									<xsl:text> gr.</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'GN'">
								<span>
									<xsl:text> Gross Galon</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = '10'">
								<span>
									<xsl:text> Grup</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'DAY'">
								<span>
									<xsl:text> Gün</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'RG'">
								<span>
									<xsl:text> Halka</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'INH'">
								<span>
									<xsl:text> İnç</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = '4B'">
								<span>
									<xsl:text> Kap</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'NCR'">
								<span>
									<xsl:text> Karat</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CTM'">
								<span>
									<xsl:text> Karat</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'Z2'">
								<span>
									<xsl:text> Kasa/Sandık</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'D66'">
								<span>
									<xsl:text> Kaset</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'KGM'">
								<span>
									<xsl:text> Kg.</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = '2P'">
								<span>
									<xsl:text> Kilobyte</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'IE'">
								<span>
									<xsl:text> Kişi</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'KJO'">
								<span>
									<xsl:text> KJO</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'K6'">
								<span>
									<xsl:text> Klt.</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'KTM'">
								<span>
									<xsl:text> Km</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'KMK'">
								<span>
									<xsl:text> Km²</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'AB'">
								<span>
									<xsl:text> Koli</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CT'">
								<span>
									<xsl:text> Koli(Karton)</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CH'">
								<span>
									<xsl:text> Konteyner</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'BJ'">
								<span>
									<xsl:text> Kova</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'PL'">
								<span>
									<xsl:text> Kova</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CU'">
								<span>
									<xsl:text> Kupa</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'BX'">
								<span>
									<xsl:text> Kutu</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CA'">
								<span>
									<xsl:text> Kutu</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CS'">
								<span>
									<xsl:text> Kutu</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'B5'">
								<span>
									<xsl:text> Kütük</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'B55'">
								<span>
									<xsl:text> KVM</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'KWH'">
								<span>
									<xsl:text> Kwh</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'KWT'">
								<span>
									<xsl:text> Kwt</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'LTR'">
								<span>
									<xsl:text> Lt.</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'RL'">
								<span>
									<xsl:text> Makara</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'SO'">
								<span>
									<xsl:text> Makara</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MAW'">
								<span>
									<xsl:text> Megawatt</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MGM'">
								<span>
									<xsl:text> Mgm.</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = '77'">
								<span>
									<xsl:text> Miliinç</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MLT'">
								<span>
									<xsl:text> Mlt</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MMT'">
								<span>
									<xsl:text> Mm</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MMQ'">
								<span>
									<xsl:text> Mm³</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MTR'">
								<span>
									<xsl:text> Mt</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MTK'">
								<span>
									<xsl:text> Mt²</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MTQ'">
								<span>
									<xsl:text> Mt³</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'MWH'">
								<span>
									<xsl:text> Mwh</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'NT'">
								<span>
									<xsl:text> Net Ton</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'PA'">
								<span>
									<xsl:text> Paket</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'D97'">
								<span>
									<xsl:text> Palet</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'PF'">
								<span>
									<xsl:text> Palet</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'BD'">
								<span>
									<xsl:text> Pano</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'PG'">
								<span>
									<xsl:text> Plaka</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'RO'">
								<span>
									<xsl:text> Rulo</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'HUR'">
								<span>
									<xsl:text> Saat</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'ST'">
								<span>
									<xsl:text> Sayfa</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'BK'">
								<span>
									<xsl:text> Sepet</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'SET'">
								<span>
									<xsl:text> Set</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'CY'">
								<span>
									<xsl:text> Silindir</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'BO'">
								<span>
									<xsl:text> Şişe</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'D62'">
								<span>
									<xsl:text> Sn.</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'LR'">
								<span>
									<xsl:text> Tabaka</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'TN'">
								<span>
									<xsl:text> Teneke</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = '26'">
								<span>
									<xsl:text> Ton</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'AA'">
								<span>
									<xsl:text> Top</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'BG'">
								<span>
									<xsl:text> Torba/Poşet</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'TU'">
								<span>
									<xsl:text> Tüp</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'BLD'">
								<span>
									<xsl:text> Varil</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'DR'">
								<span>
									<xsl:text> Varil</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'ANN'">
								<span>
									<xsl:text> Yıl</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'EV'">
								<span>
									<xsl:text> Zarf</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'LM'">
								<span>
									<xsl:text> Metretül</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'TNE'">
								<span>
									<xsl:text> Metrik Ton</xsl:text>
								</span>
							</xsl:when>
							<xsl:when test="@unitCode  = 'B32'">
								<span>
									<xsl:text> kg.m2</xsl:text>
								</span>
							</xsl:when>
						</xsl:choose>
					</xsl:for-each>
				</xsl:if>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text> </xsl:text>
				<xsl:call-template name="Curr_Type">
					<xsl:with-param name="valuePath" select="./cac:Price/cbc:PriceAmount"/>
					<xsl:with-param name="format" select="'###.##0,00'"/>
				</xsl:call-template>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text> </xsl:text>
				<xsl:for-each select="(./cac:AllowanceCharge[translate(cbc:ChargeIndicator,'abcçdefgğhıijklmnoöpqrsştuüvwxyz','ABCÇDEFGĞHIİJKLMNOÖPQRSŞTUÜVWXYZ') = 'FALSE']/cbc:MultiplierFactorNumeric)[string(number())!='NaN']">
					<xsl:text> %</xsl:text>
					<xsl:value-of select="format-number(. * 100, '###.##0,00', 'european')"/>
					<xsl:if test="not(position() = last())">
						<br/>
					</xsl:if>
				</xsl:for-each>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text> </xsl:text>
				<xsl:for-each select="(cac:AllowanceCharge[translate(cbc:ChargeIndicator,'abcçdefgğhıijklmnoöpqrsştuüvwxyz','ABCÇDEFGĞHIİJKLMNOÖPQRSŞTUÜVWXYZ') = 'FALSE']/cbc:Amount)[string(number())!='NaN']">
					<xsl:call-template name="Curr_Type">
						<xsl:with-param name="valuePath" select="."/>
						<xsl:with-param name="format" select="'###.##0,00'"/>
					</xsl:call-template>
					<xsl:if test="not(position() = last())">
						<br/>
					</xsl:if>
				</xsl:for-each>
			</td>
			<xsl:if test="contains($hasAnyFalseChangeIndicator,'TRUE')">
				<td class="lineTableTd" align="right">
					<xsl:text> </xsl:text>
					<xsl:for-each select="(cac:AllowanceCharge[translate(cbc:ChargeIndicator,'abcçdefgğhıijklmnoöpqrsştuüvwxyz','ABCÇDEFGĞHIİJKLMNOÖPQRSŞTUÜVWXYZ') = 'TRUE']/cbc:Amount)[string(number())!='NaN']">
						<xsl:call-template name="Curr_Type">
							<xsl:with-param name="valuePath" select="."/>
							<xsl:with-param name="format" select="'###.##0,00'"/>
						</xsl:call-template>
						<xsl:if test="not(position() = last())">
							<br/>
						</xsl:if>
					</xsl:for-each>
				</td>
			</xsl:if>
			<xsl:if test="not($senaryo = 'IHRACAT' or $senaryo = 'İHRACAT')">
				<td class="lineTableTd" align="right">
					<xsl:text> </xsl:text>
					<xsl:for-each select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
						<xsl:if test="cbc:TaxTypeCode='0015' ">
							<xsl:text/>
							<xsl:if test="../../cbc:Percent">
								<xsl:text> %</xsl:text>
								<xsl:value-of select="format-number(../../cbc:Percent, '###.##0,00', 'european')"/>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text> </xsl:text>
					<xsl:for-each select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
						<xsl:if test="cbc:TaxTypeCode='0015' ">
							<xsl:text/>
							<xsl:call-template name="Curr_Type">
								<xsl:with-param name="valuePath" select="../../cbc:TaxAmount"/>
								<xsl:with-param name="format" select="'###.##0,00'"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" style="font-size: xx-small" align="right">
					<xsl:text> </xsl:text>
					<xsl:for-each select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
						<xsl:if test="cbc:TaxTypeCode!='0015' ">
							<xsl:text> </xsl:text>
							<xsl:value-of select="cbc:Name"/>
							<xsl:if test="../../cbc:Percent">
								<xsl:text> (%</xsl:text>
								<xsl:value-of select="format-number(../../cbc:Percent, '###.##0,00', 'european')"/>
								<xsl:text>)=</xsl:text>
							</xsl:if>
							<xsl:for-each select="../../cbc:TaxAmount">
								<xsl:call-template name="Curr_Type">
									<xsl:with-param name="valuePath" select="."/>
									<xsl:with-param name="format" select="'###.##0,00'"/>
								</xsl:call-template>
							</xsl:for-each>
							<br/>
						</xsl:if>
					</xsl:for-each>
					<xsl:for-each select="./cac:WithholdingTaxTotal/cac:TaxSubtotal/cac:TaxCategory/cac:TaxScheme">
						<xsl:text> KDV TEVKİFAT</xsl:text>
						<xsl:if test="../../cbc:Percent">
							<xsl:text> (%</xsl:text>
							<xsl:value-of select="format-number(../../cbc:Percent, '###.##0,00', 'european')"/>
							<xsl:text>)=</xsl:text>
						</xsl:if>
						<xsl:for-each select="../../cbc:TaxAmount">
							<xsl:call-template name="Curr_Type">
								<xsl:with-param name="valuePath" select="."/>
								<xsl:with-param name="format" select="'###.##0,00'"/>
							</xsl:call-template>
						</xsl:for-each>
						<xsl:if test="not(position() = last())">
							<br/>
						</xsl:if>
					</xsl:for-each>
				</td>
			</xsl:if>
			<td class="lineTableTd" align="right">
				<xsl:text> </xsl:text>
				<xsl:call-template name="Curr_Type">
					<xsl:with-param name="valuePath" select="./cbc:LineExtensionAmount"/>
					<xsl:with-param name="format" select="'###.##0,00'"/>
				</xsl:call-template>
			</td>
			<xsl:if test="//n1:Invoice/cbc:InvoiceTypeCode='OZELMATRAH' and count(//n1:Invoice/cac:InvoiceLine/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[./cbc:TaxExemptionReasonCode !='' and ./cac:TaxScheme/cbc:TaxTypeCode='0015']) > 0">
				<td class="lineTableTd" align="right">
					<xsl:if test="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[./cbc:TaxExemptionReasonCode !='' and ./cac:TaxScheme/cbc:TaxTypeCode='0015']">
						<xsl:value-of select="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[./cac:TaxScheme/cbc:TaxTypeCode='0015']/cbc:TaxExemptionReasonCode"/>
					</xsl:if>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:if test="./cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[./cbc:TaxExemptionReasonCode !='' and ./cac:TaxScheme/cbc:TaxTypeCode='0015']">
						<xsl:text> </xsl:text>
						<xsl:call-template name="Curr_Type">
							<xsl:with-param name="valuePath" select="./cac:TaxTotal/cac:TaxSubtotal/cbc:TaxableAmount"/>
							<xsl:with-param name="format" select="'###.##0,00'"/>
						</xsl:call-template>
					</xsl:if>
				</td>
			</xsl:if>
			<xsl:if test="(//n1:Invoice/cbc:InvoiceTypeCode='SGK') and (//n1:Invoice/cbc:AccountingCost='SAGLIK_OPT')">
				<td class="lineTableTd" align="right">
					<xsl:text> </xsl:text>
					<xsl:variable name="name" select="./cac:Item/cbc:Name" />
					<xsl:for-each select="//n1:Invoice/cbc:Note">
						<xsl:if test="contains(. , $name)">
							<xsl:if test="contains(.,'Toplam Katılım Payı')">
								<xsl:text>-</xsl:text>
							</xsl:if>
							<xsl:value-of select="normalize-space(substring-after(., ':'))" />
							<xsl:text> TL</xsl:text>
						</xsl:if>
					</xsl:for-each>
				</td>
			</xsl:if>
			<xsl:if test="//n1:Invoice/cbc:ProfileID='HKS'">
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
					<xsl:for-each select="cac:Item/cac:AdditionalItemIdentification/cbc:ID[@schemeID='KUNYENO']">
						<xsl:text>&#160;</xsl:text>
						<xsl:apply-templates/>
					</xsl:for-each>
				</td>
			</xsl:if>
			<xsl:if test="//n1:Invoice/cbc:ProfileID='HKS' and /n1:Invoice/cbc:InvoiceTypeCode='SATIS'">
				<td class="lineTableTd" align="right">
					<xsl:for-each select="cac:Item/cac:AdditionalItemIdentification/cbc:ID[@schemeID='MALSAHIBIVKNTCKN']">
						<xsl:apply-templates/>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#160;</xsl:text>
					<xsl:for-each select="cac:Item/cac:AdditionalItemIdentification/cbc:ID[@schemeID='MALSAHIBIADSOYADUNVAN']">
						<xsl:text>&#160;</xsl:text>
						<xsl:apply-templates/>
					</xsl:for-each>
				</td>
			</xsl:if>
			<xsl:if test="$senaryo = 'IHRACAT' or $senaryo = 'İHRACAT'">
				<td class="lineTableTd" align="right">
					<xsl:text> </xsl:text>
					<xsl:for-each select="cac:Delivery/cac:DeliveryTerms/cbc:ID[@schemeID='INCOTERMS']">
						<xsl:apply-templates/>
						<xsl:text> </xsl:text>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:for-each select="cac:Delivery/cac:Shipment/cac:TransportHandlingUnit/cac:ActualPackage/cbc:PackagingTypeCode">
						<xsl:call-template name="PackagingType">
							<xsl:with-param name="Packaging">
								<xsl:value-of select="."/>
							</xsl:with-param>
						</xsl:call-template>
						<xsl:if test="position() != last()">
							<xsl:text>- </xsl:text>
						</xsl:if>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:for-each select="cac:Delivery/cac:Shipment/cac:TransportHandlingUnit/cac:ActualPackage/cbc:ID">
						<xsl:value-of select="."/>
						<xsl:if test="position() != last()">
							<xsl:text>- </xsl:text>
						</xsl:if>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:for-each select="cac:Delivery/cac:Shipment/cac:TransportHandlingUnit/cac:ActualPackage/cbc:Quantity">
						<xsl:value-of select="."/>
						<xsl:if test="position() != last()">
							<xsl:text>- </xsl:text>
						</xsl:if>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:for-each select="cac:Delivery/cac:DeliveryAddress">
						<xsl:if test="cbc:StreetName !=''">
							<xsl:value-of select="cbc:StreetName"/>
							<xsl:text> </xsl:text>
						</xsl:if>
						<xsl:if test="cbc:BuildingName !=''">
							<xsl:value-of select="cbc:BuildingName"/>
							<xsl:text> </xsl:text>
						</xsl:if>
						<xsl:if test="cbc:BuildingNumber !=''">
							<xsl:value-of select="cbc:BuildingNumber"/>
							<xsl:text> </xsl:text>
						</xsl:if>
						<xsl:if test="cbc:Room !=''">
							<xsl:value-of select="cbc:Room"/>
							<xsl:text> </xsl:text>
						</xsl:if>
						<xsl:if test="cbc:PostalZone !=''">
							<xsl:value-of select="cbc:PostalZone"/>
							<xsl:text> </xsl:text>
						</xsl:if>
						<xsl:if test="cbc:District !=''">
							<xsl:value-of select="cbc:District"/>
							<xsl:text> </xsl:text>
						</xsl:if>
						<xsl:if test="cbc:CitySubdivisionName !=''">
							<xsl:value-of select="cbc:CitySubdivisionName"/>
							<xsl:text> </xsl:text>
						</xsl:if>
						<xsl:if test="cbc:CityName !=''">
							<xsl:value-of select="cbc:CityName"/>
							<xsl:text> </xsl:text>
						</xsl:if>
						<xsl:if test="cbc:Region !=''">
							<xsl:value-of select="cbc:Region"/>
							<xsl:text> </xsl:text>
						</xsl:if>
						<xsl:if test="cac:Country/cbc:Name !=''">
							<xsl:value-of select="cac:Country/cbc:Name"/>
							<xsl:text> </xsl:text>
						</xsl:if>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:for-each select="cac:Delivery/cac:Shipment/cac:ShipmentStage/cbc:TransportModeCode">
						<xsl:text> </xsl:text>
						<xsl:call-template name="TransportMode">
							<xsl:with-param name="TransportModeType">
								<xsl:value-of select="."/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text> </xsl:text>
					<xsl:value-of select="cac:Delivery/cac:Shipment/cac:GoodsItem/cbc:RequiredCustomsID"/>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
	<xsl:template match="//n1:Invoice">
		<tr class="lineTableTr">
			<td class="lineTableTd">
				<xsl:text>&#xA0;</xsl:text>
			</td>
			<td class="lineTableTd">
				<xsl:text>&#xA0;</xsl:text>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#xA0;</xsl:text>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#xA0;</xsl:text>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#xA0;</xsl:text>
			</td>
			<td class="lineTableTd" align="right">
				<xsl:text>&#xA0;</xsl:text>
			</td>
			<xsl:if test="contains($hasAnyFalseChangeIndicator,'TRUE')">
				<td class="lineTableTd" align="right">
					<xsl:text>&#xA0;</xsl:text>
				</td>
			</xsl:if>
			<xsl:if test="not($senaryo = 'IHRACAT' or $senaryo = 'İHRACAT')">
				<td class="lineTableTd" align="right">
					<xsl:text>&#xA0;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#xA0;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#xA0;</xsl:text>
				</td>
			</xsl:if>
			<td class="lineTableTd" align="right">
				<xsl:text>&#xA0;</xsl:text>
			</td>
			<xsl:if test="$senaryo = 'IHRACAT' or $senaryo = 'İHRACAT'">
				<td class="lineTableTd" align="right">
					<xsl:text>&#xA0;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#xA0;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#xA0;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#xA0;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#xA0;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#xA0;</xsl:text>
				</td>
				<td class="lineTableTd" align="right">
					<xsl:text>&#xA0;</xsl:text>
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
	<xsl:template name="Party_Title">
		<xsl:param name="PartyType"/>
		<td align="left">
			<xsl:if test="cac:PartyName !=''">
				<xsl:value-of select="cac:PartyName/cbc:Name"/>
				<br/>
			</xsl:if>
			<xsl:for-each select="cac:Person">
				<xsl:for-each select="cbc:Title">
					<xsl:if test=". !=''">
						<xsl:apply-templates/>
						<xsl:text>&#xA0;</xsl:text>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="cbc:FirstName">
					<xsl:if test=". !=''">
						<xsl:apply-templates/>
						<xsl:text>&#xA0;</xsl:text>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="cbc:MiddleName">
					<xsl:if test=". !=''">
						<xsl:apply-templates/>
						<xsl:text>&#xA0; </xsl:text>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="cbc:FamilyName">
					<xsl:if test=". !=''">
						<xsl:apply-templates/>
						<xsl:text>&#xA0;</xsl:text>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="cbc:NameSuffix">
					<xsl:apply-templates/>
				</xsl:for-each>
				<xsl:if test="$PartyType='TAXFREE'">
					<br/>
					<xsl:if test="cac:IdentityDocumentReference/cbc:ID != ''">
						<xsl:text>Pasaport No: </xsl:text>
						<xsl:value-of select="cac:IdentityDocumentReference/cbc:ID"/>
						<br/>
					</xsl:if>
					<xsl:if test="cbc:NationalityID != ''">
						<xsl:text>Ülkesi: </xsl:text>
						<xsl:for-each select="cbc:NationalityID">
							<xsl:call-template name="Country">
								<xsl:with-param name="CountryType">
									<xsl:value-of select="."/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</td>
	</xsl:template>
	<xsl:template name="Party_Adress">
		<xsl:param name="PartyType"/>
		<td align="left">
			<xsl:for-each select="cac:PostalAddress">
				<xsl:for-each select="cbc:StreetName">
					<xsl:if test=". != ''">
						<xsl:apply-templates/>
						<xsl:text>&#xA0;</xsl:text>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="cbc:BuildingName">
					<xsl:if test=".!= ''">
						<xsl:apply-templates/>
						<xsl:text>&#xA0;</xsl:text>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="cbc:BuildingNumber">
					<xsl:if test=".!= ''">
						<xsl:text>No:</xsl:text>
						<xsl:apply-templates/>
						<xsl:text>&#xA0;</xsl:text>
					</xsl:if>
				</xsl:for-each>
				<xsl:if test="cbc:StreetName !='' or cbc:BuildingName !='' or cbc:BuildingNumber !=''">
					<br/>
				</xsl:if>
				<xsl:for-each select="cbc:Room">
					<xsl:if test=".!=''">
						<xsl:text>Kapı No:</xsl:text>
						<xsl:apply-templates/>
						<xsl:text>&#xA0;</xsl:text>
						<br/>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="cbc:PostalZone">
					<xsl:if test=". != ''">
						<xsl:apply-templates/>
						<xsl:text>&#xA0;</xsl:text>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="cbc:District">
					<xsl:if test=". !=''">
						<xsl:apply-templates/>
						<xsl:text>&#xA0;</xsl:text>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="cbc:CitySubdivisionName">
					<xsl:apply-templates/>
				</xsl:for-each>
				<xsl:if test="cbc:CitySubdivisionName and cbc:CityName != ''">
					<xsl:text>/ </xsl:text>
				</xsl:if>
				<xsl:for-each select="cbc:CityName">
					<xsl:if test=". != ''">
						<xsl:apply-templates/>
						<xsl:text>&#xA0;</xsl:text>
					</xsl:if>
				</xsl:for-each>
				<xsl:if test="cac:Country/cbc:Name != ''">
					<br/>
					<xsl:value-of select="cac:Country/cbc:Name"/>
				</xsl:if>
			</xsl:for-each>
			<xsl:if test="$PartyType='EXPORT'">
				<xsl:for-each select="cac:PartyLegalEntity">
					<xsl:for-each select="cbc:CompanyID">
						<xsl:if test=". != ''">
							<br/>
							<xsl:text>Ülkesindeki VKN: </xsl:text>
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
					<xsl:for-each select="cbc:RegistrationName">
						<xsl:if test=". != ''">
							<br/>
							<xsl:text>Resmi Unvan: </xsl:text>
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:if>
		</td>
	</xsl:template>
	<xsl:template name="Party_Other">
		<xsl:param name="PartyType"/>
		<xsl:for-each select="cbc:WebsiteURI">
			<xsl:if test=". !=''">
				<tr align="left">
					<td>
						<xsl:text>Web Sitesi: </xsl:text>
						<xsl:value-of select="."/>
					</td>
				</tr>
			</xsl:if>
		</xsl:for-each>
		<xsl:for-each select="cac:Contact/cbc:ElectronicMail">
			<xsl:if test=". !=''">
				<tr align="left">
					<td>
						<xsl:text>E-Posta: </xsl:text>
						<xsl:value-of select="."/>
					</td>
				</tr>
			</xsl:if>
		</xsl:for-each>
		<xsl:for-each select="cac:Contact">
			<xsl:if test="cbc:Telephone != '' or cbc:Telefax != ''">
				<tr align="left">
					<td align="left">
						<xsl:for-each select="cbc:Telephone">
							<xsl:if test=". !=''">
								<xsl:text>Tel: </xsl:text>
								<xsl:apply-templates/>
							</xsl:if>
						</xsl:for-each>
						<xsl:for-each select="cbc:Telefax">
							<xsl:if test=". !=''">
								<xsl:text> Fax: </xsl:text>
								<xsl:apply-templates/>
							</xsl:if>
						</xsl:for-each>
						<xsl:text>&#xA0;</xsl:text>
					</td>
				</tr>
			</xsl:if>
		</xsl:for-each>
		<xsl:if test="$PartyType!='TAXFREE' and $PartyType!='EXPORT'">
			<xsl:for-each select="cac:PartyTaxScheme/cac:TaxScheme/cbc:Name">
				<xsl:if test=". !=''">
					<tr align="left">
						<td>
							<xsl:text>Vergi Dairesi: </xsl:text>
							<xsl:apply-templates/>
						</td>
					</tr>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
		<xsl:for-each select="cac:PartyIdentification">
			<xsl:if test="cbc:ID != '' and not(contains(cbc:ID/@schemeID,'PARTYTYPE'))">
				<tr align="left">
					<td>
						<xsl:value-of select="cbc:ID/@schemeID"/>
						<xsl:text>: </xsl:text>
						<xsl:value-of select="cbc:ID"/>
					</td>
				</tr>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="TransportMode">
		<xsl:param name="TransportModeType"/>
		<xsl:choose>
			<xsl:when test="$TransportModeType=1">Deniz Taşımacılığı</xsl:when>
			<xsl:when test="$TransportModeType=2">Demiryolu Taşımacılığı</xsl:when>
			<xsl:when test="$TransportModeType=3">Karayolu Taşımacılığı</xsl:when>
			<xsl:when test="$TransportModeType=4">Hava Taşımacılığı</xsl:when>
			<xsl:when test="$TransportModeType=5">Posta</xsl:when>
			<xsl:when test="$TransportModeType=6">Kombine Taşımacılık</xsl:when>
			<xsl:when test="$TransportModeType=7">Sabit Nakliyat</xsl:when>
			<xsl:when test="$TransportModeType=8">Ülke İçi Su Taşımacılığı</xsl:when>
			<xsl:when test="$TransportModeType=9">Uygun Olmayan Taşıma Şekli</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$TransportModeType"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="PackagingType">
		<xsl:param name="Packaging"/>
		<xsl:choose>
			<xsl:when test="$Packaging='TD'">Açılır Kapanır Tüp / Portatif Tüp</xsl:when>
			<xsl:when test="$Packaging='AE'">Aerosol</xsl:when>
			<xsl:when test="$Packaging='NT'">Ağ</xsl:when>
			<xsl:when test="$Packaging='CK'">Ahşap Varil</xsl:when>
			<xsl:when test="$Packaging='PK'">Ambalaj</xsl:when>
			<xsl:when test="$Packaging='CE'">Balık Sepeti</xsl:when>
			<xsl:when test="$Packaging='SU'">Bavul</xsl:when>
			<xsl:when test="$Packaging='CB'">Bira Kasası</xsl:when>
			<xsl:when test="$Packaging='BB'">Bobin</xsl:when>
			<xsl:when test="$Packaging='BE'">Bohça</xsl:when>
			<xsl:when test="$Packaging='PI'">Boru</xsl:when>
			<xsl:when test="$Packaging='TR'">Büyük Eşya Sandığı</xsl:when>
			<xsl:when test="$Packaging='BU'">Büyük Fıçı</xsl:when>
			<xsl:when test="$Packaging='TO'">Büyük Fıçı (250 Galonluk)</xsl:when>
			<xsl:when test="$Packaging='HG'">Büyük Fıçı (250 Lt'lik)</xsl:when>
			<xsl:when test="$Packaging='VI'">Cam Şişe</xsl:when>
			<xsl:when test="$Packaging='BT'">Civata</xsl:when>
			<xsl:when test="$Packaging='CZ'">Çatır Bezi</xsl:when>
			<xsl:when test="$Packaging='BG'">Çanta</xsl:when>
			<xsl:when test="$Packaging='TC'">Çay Sandığı</xsl:when>
			<xsl:when test="$Packaging='SW'">Çekme - Sarma</xsl:when>
			<xsl:when test="$Packaging='FR'">Çerçeve</xsl:when>
			<xsl:when test="$Packaging='FD'">Çerçeveli Kasa</xsl:when>
			<xsl:when test="$Packaging='MB'">Çok Gözlü Çanta</xsl:when>
			<xsl:when test="$Packaging='PT'">Çömlek</xsl:when>
			<xsl:when test="$Packaging='BR'">Çubuk</xsl:when>
			<xsl:when test="$Packaging='SA'">Çuval</xsl:when>
			<xsl:when test="$Packaging='FL'">Dar Boyunlu Küçük Şişe</xsl:when>
			<xsl:when test="$Packaging='SC'">Dar Kasa</xsl:when>
			<xsl:when test="$Packaging='DR'">Davul</xsl:when>
			<xsl:when test="$Packaging='JC'">Dikdörtgen Bidon (20Lt'lik)</xsl:when>
			<xsl:when test="$Packaging='CA'">Dikdörtgen Madeni Kap</xsl:when>
			<xsl:when test="$Packaging='TK'">Dikdörtgen Tank</xsl:when>
			<xsl:when test="$Packaging='CU'">Fincan</xsl:when>
			<xsl:when test="$Packaging='FP'">Fotoğraf Filmleri Paketi</xsl:when>
			<xsl:when test="$Packaging='GB'">Gaz Şişesi</xsl:when>
			<xsl:when test="$Packaging='GE'">Gemici Sandığı</xsl:when>
			<xsl:when test="$Packaging='SE'">Gemici Sandığı</xsl:when>
			<xsl:when test="$Packaging='TB'">Gerdel</xsl:when>
			<xsl:when test="$Packaging='PL'">Gerdel</xsl:when>
			<xsl:when test="$Packaging='VG'">Hacim, Gaz (1031 M Bar Ve 15C)</xsl:when>
			<xsl:when test="$Packaging='VR'">Hacim, Katı, Granül Parçacıkları ('Taneler')</xsl:when>
			<xsl:when test="$Packaging='VY'">Hacim, Katı, İnce Parçacıkları ('Toz')</xsl:when>
			<xsl:when test="$Packaging='VQ'">Hacim, Sıvı Hale Getirilmiş Gaz (Anormal Isı/Basınç)</xsl:when>
			<xsl:when test="$Packaging='RG'">Halka (Çember)</xsl:when>
			<xsl:when test="$Packaging='MT'">Hasır</xsl:when>
			<xsl:when test="$Packaging='PH'">İbrik</xsl:when>
			<xsl:when test="$Packaging='SD'">İğ</xsl:when>
			<xsl:when test="$Packaging='SK'">İskelet Kasa</xsl:when>
			<xsl:when test="$Packaging='JT'">Jüt (Kenevir) Torba</xsl:when>
			<xsl:when test="$Packaging='CG'">Kafes</xsl:when>
			<xsl:when test="$Packaging='PN'">Kalas</xsl:when>
			<xsl:when test="$Packaging='CL'">Kangal</xsl:when>
			<xsl:when test="$Packaging='BI'">Kap</xsl:when>
			<xsl:when test="$Packaging='HR'">Kapaklı Sepet</xsl:when>
			<xsl:when test="$Packaging='CV'">Kapalı</xsl:when>
			<xsl:when test="$Packaging='CR'">Kasa</xsl:when>
			<xsl:when test="$Packaging='JR'">Kavanoz</xsl:when>
			<xsl:when test="$Packaging='PO'">Kese</xsl:when>
			<xsl:when test="$Packaging='MX'">Kibrit Kutusu</xsl:when>
			<xsl:when test="$Packaging='GI'">Kiriş</xsl:when>
			<xsl:when test="$Packaging='TS'">Kiriş</xsl:when>
			<xsl:when test="$Packaging='SH'">Koku Yastığı</xsl:when>
			<xsl:when test="$Packaging='PC'">Koli</xsl:when>
			<xsl:when test="$Packaging='KN'">Konteyner</xsl:when>
			<xsl:when test="$Packaging='DJ'">Korumalı, Hasır Büyük Şişe</xsl:when>
			<xsl:when test="$Packaging='BV'">Korumalı, Soğan Şeklinde Şişe</xsl:when>
			<xsl:when test="$Packaging='AM'">Korumalı Ampül</xsl:when>
			<xsl:when test="$Packaging='BP'">Korumalı Balon</xsl:when>
			<xsl:when test="$Packaging='CP'">Korumalı Damacana</xsl:when>
			<xsl:when test="$Packaging='BQ'">Korumalı Silindirik Şişe</xsl:when>
			<xsl:when test="$Packaging='DP'">Korumasız, Hasırlı Büyük Şişe</xsl:when>
			<xsl:when test="$Packaging='BS'">Korumasız, Soğan Şeklinde Şişe</xsl:when>
			<xsl:when test="$Packaging='AP'">Korumasız Ampül</xsl:when>
			<xsl:when test="$Packaging='BF'">Korumasız Balon</xsl:when>
			<xsl:when test="$Packaging='CO'">Korumasız Damacana</xsl:when>
			<xsl:when test="$Packaging='BO'">Korumasız Silindirik Şişe</xsl:when>
			<xsl:when test="$Packaging='BJ'">Kova</xsl:when>
			<xsl:when test="$Packaging='BX'">Kutu</xsl:when>
			<xsl:when test="$Packaging='KG'">Küçük Fıçı</xsl:when>
			<xsl:when test="$Packaging='FO'">Küçük Sandık</xsl:when>
			<xsl:when test="$Packaging='LG'">Kütük</xsl:when>
			<xsl:when test="$Packaging='RL'">Makara</xsl:when>
			<xsl:when test="$Packaging='FC'">Meyve Kasası</xsl:when>
			<xsl:when test="$Packaging='CT'">Mukavva Kutu</xsl:when>
			<xsl:when test="$Packaging='PA'">Paket</xsl:when>
			<xsl:when test="$Packaging='NE'">Paketlenmemiş Veya Ambalajlanmamış</xsl:when>
			<xsl:when test="$Packaging='AT'">Püskürgeç</xsl:when>
			<xsl:when test="$Packaging='RO'">Rulo</xsl:when>
			<xsl:when test="$Packaging='SM'">Sac</xsl:when>
			<xsl:when test="$Packaging='CH'">Sandık</xsl:when>
			<xsl:when test="$Packaging='CF'">Sandık</xsl:when>
			<xsl:when test="$Packaging='BK'">Sepet</xsl:when>
			<xsl:when test="$Packaging='WB'">Sepet Şişe</xsl:when>
			<xsl:when test="$Packaging='BN'">Sıkıştırılmamış Balya</xsl:when>
			<xsl:when test="$Packaging='BL'">Sıkıştırılmış Balya</xsl:when>
			<xsl:when test="$Packaging='CY'">Silindirik</xsl:when>
			<xsl:when test="$Packaging='JY'">Silindirik Bidon (20Lt'lik)</xsl:when>
			<xsl:when test="$Packaging='TY'">Silindirik Tank</xsl:when>
			<xsl:when test="$Packaging='CX'">Silindirik Teneke Kutu</xsl:when>
			<xsl:when test="$Packaging='RD'">Sopa</xsl:when>
			<xsl:when test="$Packaging='JG'">Sürahi</xsl:when>
			<xsl:when test="$Packaging='BC'">Şişe Kasası</xsl:when>
			<xsl:when test="$Packaging='ST'">Tabaka</xsl:when>
			<xsl:when test="$Packaging='PG'">Tabla</xsl:when>
			<xsl:when test="$Packaging='PU'">Tabla Paketi / Tabla</xsl:when>
			<xsl:when test="$Packaging='CJ'">Tabut</xsl:when>
			<xsl:when test="$Packaging='BD'">Tahta</xsl:when>
			<xsl:when test="$Packaging='VA'">Tekne</xsl:when>
			<xsl:when test="$Packaging='TN'">Teneke Kutu</xsl:when>
			<xsl:when test="$Packaging='TU'">Küp</xsl:when>
			<xsl:when test="$Packaging='FI'">Ufak Yağ Fıçısı</xsl:when>
			<xsl:when test="$Packaging='VP'">Vakumlu Paket</xsl:when>
			<xsl:when test="$Packaging='BA'">Varil</xsl:when>
			<xsl:when test="$Packaging='CC'">Yayık</xsl:when>
			<xsl:when test="$Packaging='NS'">Yuva</xsl:when>
			<xsl:when test="$Packaging='EN'">Zarf</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$Packaging"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Country">
		<xsl:param name="CountryType"/>
		<xsl:choose>
			<xsl:when test="$CountryType='AF'">Afganistan</xsl:when>
			<xsl:when test="$CountryType='DE'">Almanya</xsl:when>
			<xsl:when test="$CountryType='AD'">Andorra</xsl:when>
			<xsl:when test="$CountryType='AO'">Angola</xsl:when>
			<xsl:when test="$CountryType='AG'">Antigua ve Barbuda</xsl:when>
			<xsl:when test="$CountryType='AR'">Arjantin</xsl:when>
			<xsl:when test="$CountryType='AL'">Arnavutluk</xsl:when>
			<xsl:when test="$CountryType='AW'">Aruba</xsl:when>
			<xsl:when test="$CountryType='AU'">Avustralya</xsl:when>
			<xsl:when test="$CountryType='AT'">Avusturya</xsl:when>
			<xsl:when test="$CountryType='AZ'">Azerbaycan</xsl:when>
			<xsl:when test="$CountryType='BS'">Bahamalar</xsl:when>
			<xsl:when test="$CountryType='BH'">Bahreyn</xsl:when>
			<xsl:when test="$CountryType='BD'">Bangladeş</xsl:when>
			<xsl:when test="$CountryType='BB'">Barbados</xsl:when>
			<xsl:when test="$CountryType='EH'">Batı Sahra (MA)</xsl:when>
			<xsl:when test="$CountryType='BE'">Belçika</xsl:when>
			<xsl:when test="$CountryType='BZ'">Belize</xsl:when>
			<xsl:when test="$CountryType='BJ'">Benin</xsl:when>
			<xsl:when test="$CountryType='BM'">Bermuda</xsl:when>
			<xsl:when test="$CountryType='BY'">Beyaz Rusya</xsl:when>
			<xsl:when test="$CountryType='BT'">Bhutan</xsl:when>
			<xsl:when test="$CountryType='AE'">Birleşik Arap Emirlikleri</xsl:when>
			<xsl:when test="$CountryType='US'">Birleşik Devletler</xsl:when>
			<xsl:when test="$CountryType='GB'">Birleşik Krallık</xsl:when>
			<xsl:when test="$CountryType='BO'">Bolivya</xsl:when>
			<xsl:when test="$CountryType='BA'">Bosna-Hersek</xsl:when>
			<xsl:when test="$CountryType='BW'">Botsvana</xsl:when>
			<xsl:when test="$CountryType='BR'">Brezilya</xsl:when>
			<xsl:when test="$CountryType='BN'">Bruney</xsl:when>
			<xsl:when test="$CountryType='BG'">Bulgaristan</xsl:when>
			<xsl:when test="$CountryType='BF'">Burkina Faso</xsl:when>
			<xsl:when test="$CountryType='BI'">Burundi</xsl:when>
			<xsl:when test="$CountryType='TD'">Çad</xsl:when>
			<xsl:when test="$CountryType='KY'">Cayman Adaları</xsl:when>
			<xsl:when test="$CountryType='GI'">Cebelitarık (GB)</xsl:when>
			<xsl:when test="$CountryType='CZ'">Çek Cumhuriyeti</xsl:when>
			<xsl:when test="$CountryType='DZ'">Cezayir</xsl:when>
			<xsl:when test="$CountryType='DJ'">Cibuti</xsl:when>
			<xsl:when test="$CountryType='CN'">Çin</xsl:when>
			<xsl:when test="$CountryType='DK'">Danimarka</xsl:when>
			<xsl:when test="$CountryType='CD'">Demokratik Kongo Cumhuriyeti</xsl:when>
			<xsl:when test="$CountryType='TL'">Doğu Timor</xsl:when>
			<xsl:when test="$CountryType='DO'">Dominik Cumhuriyeti</xsl:when>
			<xsl:when test="$CountryType='DM'">Dominika</xsl:when>
			<xsl:when test="$CountryType='EC'">Ekvador</xsl:when>
			<xsl:when test="$CountryType='GQ'">Ekvator Ginesi</xsl:when>
			<xsl:when test="$CountryType='SV'">El Salvador</xsl:when>
			<xsl:when test="$CountryType='ID'">Endonezya</xsl:when>
			<xsl:when test="$CountryType='ER'">Eritre</xsl:when>
			<xsl:when test="$CountryType='AM'">Ermenistan</xsl:when>
			<xsl:when test="$CountryType='MF'">Ermiş Martin (FR)</xsl:when>
			<xsl:when test="$CountryType='EE'">Estonya</xsl:when>
			<xsl:when test="$CountryType='ET'">Etiyopya</xsl:when>
			<xsl:when test="$CountryType='FK'">Falkland Adaları</xsl:when>
			<xsl:when test="$CountryType='FO'">Faroe Adaları (DK)</xsl:when>
			<xsl:when test="$CountryType='MA'">Fas</xsl:when>
			<xsl:when test="$CountryType='FJ'">Fiji</xsl:when>
			<xsl:when test="$CountryType='CI'">Fildişi Sahili</xsl:when>
			<xsl:when test="$CountryType='PH'">Filipinler</xsl:when>
			<xsl:when test="$CountryType='FI'">Finlandiya</xsl:when>
			<xsl:when test="$CountryType='FR'">Fransa</xsl:when>
			<xsl:when test="$CountryType='GF'">Fransız Guyanası (FR)</xsl:when>
			<xsl:when test="$CountryType='PF'">Fransız Polinezyası (FR)</xsl:when>
			<xsl:when test="$CountryType='GA'">Gabon</xsl:when>
			<xsl:when test="$CountryType='GM'">Gambiya</xsl:when>
			<xsl:when test="$CountryType='GH'">Gana</xsl:when>
			<xsl:when test="$CountryType='GN'">Gine</xsl:when>
			<xsl:when test="$CountryType='GW'">Gine Bissau</xsl:when>
			<xsl:when test="$CountryType='GD'">Grenada</xsl:when>
			<xsl:when test="$CountryType='GL'">Grönland (DK)</xsl:when>
			<xsl:when test="$CountryType='GP'">Guadeloupe (FR)</xsl:when>
			<xsl:when test="$CountryType='GT'">Guatemala</xsl:when>
			<xsl:when test="$CountryType='GG'">Guernsey (GB)</xsl:when>
			<xsl:when test="$CountryType='ZA'">Güney Afrika</xsl:when>
			<xsl:when test="$CountryType='KR'">Güney Kore</xsl:when>
			<xsl:when test="$CountryType='GE'">Gürcistan</xsl:when>
			<xsl:when test="$CountryType='GY'">Guyana</xsl:when>
			<xsl:when test="$CountryType='HT'">Haiti</xsl:when>
			<xsl:when test="$CountryType='IN'">Hindistan</xsl:when>
			<xsl:when test="$CountryType='HR'">Hırvatistan</xsl:when>
			<xsl:when test="$CountryType='NL'">Hollanda</xsl:when>
			<xsl:when test="$CountryType='HN'">Honduras</xsl:when>
			<xsl:when test="$CountryType='HK'">Hong Kong (CN)</xsl:when>
			<xsl:when test="$CountryType='VG'">İngiliz Virjin Adaları</xsl:when>
			<xsl:when test="$CountryType='IQ'">Irak</xsl:when>
			<xsl:when test="$CountryType='IR'">İran</xsl:when>
			<xsl:when test="$CountryType='IE'">İrlanda</xsl:when>
			<xsl:when test="$CountryType='ES'">İspanya</xsl:when>
			<xsl:when test="$CountryType='IL'">İsrail</xsl:when>
			<xsl:when test="$CountryType='SE'">İsveç</xsl:when>
			<xsl:when test="$CountryType='CH'">İsviçre</xsl:when>
			<xsl:when test="$CountryType='IT'">İtalya</xsl:when>
			<xsl:when test="$CountryType='IS'">İzlanda</xsl:when>
			<xsl:when test="$CountryType='JM'">Jamaika</xsl:when>
			<xsl:when test="$CountryType='JP'">Japonya</xsl:when>
			<xsl:when test="$CountryType='JE'">Jersey (GB)</xsl:when>
			<xsl:when test="$CountryType='KH'">Kamboçya</xsl:when>
			<xsl:when test="$CountryType='CM'">Kamerun</xsl:when>
			<xsl:when test="$CountryType='CA'">Kanada</xsl:when>
			<xsl:when test="$CountryType='ME'">Karadağ</xsl:when>
			<xsl:when test="$CountryType='QA'">Katar</xsl:when>
			<xsl:when test="$CountryType='KZ'">Kazakistan</xsl:when>
			<xsl:when test="$CountryType='KE'">Kenya</xsl:when>
			<xsl:when test="$CountryType='CY'">Kıbrıs</xsl:when>
			<xsl:when test="$CountryType='KG'">Kırgızistan</xsl:when>
			<xsl:when test="$CountryType='KI'">Kiribati</xsl:when>
			<xsl:when test="$CountryType='CO'">Kolombiya</xsl:when>
			<xsl:when test="$CountryType='KM'">Komorlar</xsl:when>
			<xsl:when test="$CountryType='CG'">Kongo Cumhuriyeti</xsl:when>
			<xsl:when test="$CountryType='KV'">Kosova (RS)</xsl:when>
			<xsl:when test="$CountryType='CR'">Kosta Rika</xsl:when>
			<xsl:when test="$CountryType='CU'">Küba</xsl:when>
			<xsl:when test="$CountryType='KW'">Kuveyt</xsl:when>
			<xsl:when test="$CountryType='KP'">Kuzey Kore</xsl:when>
			<xsl:when test="$CountryType='LA'">Laos</xsl:when>
			<xsl:when test="$CountryType='LS'">Lesoto</xsl:when>
			<xsl:when test="$CountryType='LV'">Letonya</xsl:when>
			<xsl:when test="$CountryType='LR'">Liberya</xsl:when>
			<xsl:when test="$CountryType='LY'">Libya</xsl:when>
			<xsl:when test="$CountryType='LI'">Lihtenştayn</xsl:when>
			<xsl:when test="$CountryType='LT'">Litvanya</xsl:when>
			<xsl:when test="$CountryType='LB'">Lübnan</xsl:when>
			<xsl:when test="$CountryType='LU'">Lüksemburg</xsl:when>
			<xsl:when test="$CountryType='HU'">Macaristan</xsl:when>
			<xsl:when test="$CountryType='MG'">Madagaskar</xsl:when>
			<xsl:when test="$CountryType='MO'">Makao (CN)</xsl:when>
			<xsl:when test="$CountryType='MK'">Makedonya</xsl:when>
			<xsl:when test="$CountryType='MW'">Malavi</xsl:when>
			<xsl:when test="$CountryType='MV'">Maldivler</xsl:when>
			<xsl:when test="$CountryType='MY'">Malezya</xsl:when>
			<xsl:when test="$CountryType='ML'">Mali</xsl:when>
			<xsl:when test="$CountryType='MT'">Malta</xsl:when>
			<xsl:when test="$CountryType='IM'">Man Adası (GB)</xsl:when>
			<xsl:when test="$CountryType='MH'">Marshall Adaları</xsl:when>
			<xsl:when test="$CountryType='MQ'">Martinique (FR)</xsl:when>
			<xsl:when test="$CountryType='MU'">Mauritius</xsl:when>
			<xsl:when test="$CountryType='YT'">Mayotte (FR)</xsl:when>
			<xsl:when test="$CountryType='MX'">Meksika</xsl:when>
			<xsl:when test="$CountryType='FM'">Mikronezya</xsl:when>
			<xsl:when test="$CountryType='EG'">Mısır</xsl:when>
			<xsl:when test="$CountryType='MN'">Moğolistan</xsl:when>
			<xsl:when test="$CountryType='MD'">Moldova</xsl:when>
			<xsl:when test="$CountryType='MC'">Monako</xsl:when>
			<xsl:when test="$CountryType='MR'">Moritanya</xsl:when>
			<xsl:when test="$CountryType='MZ'">Mozambik</xsl:when>
			<xsl:when test="$CountryType='MM'">Myanmar</xsl:when>
			<xsl:when test="$CountryType='NA'">Namibya</xsl:when>
			<xsl:when test="$CountryType='NR'">Nauru</xsl:when>
			<xsl:when test="$CountryType='NP'">Nepal</xsl:when>
			<xsl:when test="$CountryType='NE'">Nijer</xsl:when>
			<xsl:when test="$CountryType='NG'">Nijerya</xsl:when>
			<xsl:when test="$CountryType='NI'">Nikaragua</xsl:when>
			<xsl:when test="$CountryType='NO'">Norveç</xsl:when>
			<xsl:when test="$CountryType='CF'">Orta Afrika Cumhuriyeti</xsl:when>
			<xsl:when test="$CountryType='UZ'">Özbekistan</xsl:when>
			<xsl:when test="$CountryType='PK'">Pakistan</xsl:when>
			<xsl:when test="$CountryType='PW'">Palau</xsl:when>
			<xsl:when test="$CountryType='PA'">Panama</xsl:when>
			<xsl:when test="$CountryType='PG'">Papua Yeni Gine</xsl:when>
			<xsl:when test="$CountryType='PY'">Paraguay</xsl:when>
			<xsl:when test="$CountryType='PE'">Peru</xsl:when>
			<xsl:when test="$CountryType='PL'">Polonya</xsl:when>
			<xsl:when test="$CountryType='PT'">Portekiz</xsl:when>
			<xsl:when test="$CountryType='PR'">Porto Riko (US)</xsl:when>
			<xsl:when test="$CountryType='RE'">Réunion (FR)</xsl:when>
			<xsl:when test="$CountryType='RO'">Romanya</xsl:when>
			<xsl:when test="$CountryType='RW'">Ruanda</xsl:when>
			<xsl:when test="$CountryType='RU'">Rusya</xsl:when>
			<xsl:when test="$CountryType='BL'">Saint Barthélemy (FR)</xsl:when>
			<xsl:when test="$CountryType='KN'">Saint Kitts ve Nevis</xsl:when>
			<xsl:when test="$CountryType='LC'">Saint Lucia</xsl:when>
			<xsl:when test="$CountryType='PM'">Saint Pierre ve Miquelon (FR)</xsl:when>
			<xsl:when test="$CountryType='VC'">Saint Vincent ve Grenadinler</xsl:when>
			<xsl:when test="$CountryType='WS'">Samoa</xsl:when>
			<xsl:when test="$CountryType='SM'">San Marino</xsl:when>
			<xsl:when test="$CountryType='ST'">São Tomé ve Príncipe</xsl:when>
			<xsl:when test="$CountryType='SN'">Senegal</xsl:when>
			<xsl:when test="$CountryType='SC'">Seyşeller</xsl:when>
			<xsl:when test="$CountryType='SL'">Sierra Leone</xsl:when>
			<xsl:when test="$CountryType='CL'">Şili</xsl:when>
			<xsl:when test="$CountryType='SG'">Singapur</xsl:when>
			<xsl:when test="$CountryType='RS'">Sırbistan</xsl:when>
			<xsl:when test="$CountryType='SK'">Slovakya Cumhuriyeti</xsl:when>
			<xsl:when test="$CountryType='SI'">Slovenya</xsl:when>
			<xsl:when test="$CountryType='SB'">Solomon Adaları</xsl:when>
			<xsl:when test="$CountryType='SO'">Somali</xsl:when>
			<xsl:when test="$CountryType='SS'">South Sudan</xsl:when>
			<xsl:when test="$CountryType='SJ'">Spitsbergen (NO)</xsl:when>
			<xsl:when test="$CountryType='LK'">Sri Lanka</xsl:when>
			<xsl:when test="$CountryType='SD'">Sudan</xsl:when>
			<xsl:when test="$CountryType='SR'">Surinam</xsl:when>
			<xsl:when test="$CountryType='SY'">Suriye</xsl:when>
			<xsl:when test="$CountryType='SA'">Suudi Arabistan</xsl:when>
			<xsl:when test="$CountryType='SZ'">Svaziland</xsl:when>
			<xsl:when test="$CountryType='TJ'">Tacikistan</xsl:when>
			<xsl:when test="$CountryType='TZ'">Tanzanya</xsl:when>
			<xsl:when test="$CountryType='TH'">Tayland</xsl:when>
			<xsl:when test="$CountryType='TW'">Tayvan</xsl:when>
			<xsl:when test="$CountryType='TG'">Togo</xsl:when>
			<xsl:when test="$CountryType='TO'">Tonga</xsl:when>
			<xsl:when test="$CountryType='TT'">Trinidad ve Tobago</xsl:when>
			<xsl:when test="$CountryType='TN'">Tunus</xsl:when>
			<xsl:when test="$CountryType='TR'">Türkiye</xsl:when>
			<xsl:when test="$CountryType='TM'">Türkmenistan</xsl:when>
			<xsl:when test="$CountryType='TC'">Turks ve Caicos</xsl:when>
			<xsl:when test="$CountryType='TV'">Tuvalu</xsl:when>
			<xsl:when test="$CountryType='UG'">Uganda</xsl:when>
			<xsl:when test="$CountryType='UA'">Ukrayna</xsl:when>
			<xsl:when test="$CountryType='OM'">Umman</xsl:when>
			<xsl:when test="$CountryType='JO'">Ürdün</xsl:when>
			<xsl:when test="$CountryType='UY'">Uruguay</xsl:when>
			<xsl:when test="$CountryType='VU'">Vanuatu</xsl:when>
			<xsl:when test="$CountryType='VA'">Vatikan</xsl:when>
			<xsl:when test="$CountryType='VE'">Venezuela</xsl:when>
			<xsl:when test="$CountryType='VN'">Vietnam</xsl:when>
			<xsl:when test="$CountryType='WF'">Wallis ve Futuna (FR)</xsl:when>
			<xsl:when test="$CountryType='YE'">Yemen</xsl:when>
			<xsl:when test="$CountryType='NC'">Yeni Kaledonya (FR)</xsl:when>
			<xsl:when test="$CountryType='NZ'">Yeni Zelanda</xsl:when>
			<xsl:when test="$CountryType='CV'">Yeşil Burun Adaları</xsl:when>
			<xsl:when test="$CountryType='GR'">Yunanistan</xsl:when>
			<xsl:when test="$CountryType='ZM'">Zambiya</xsl:when>
			<xsl:when test="$CountryType='ZW'">Zimbabve</xsl:when>
			<xsl:when test="$CountryType='AI'">Anguilla</xsl:when>
			<xsl:when test="$CountryType='AQ'">Antartika</xsl:when>
			<xsl:when test="$CountryType='AS'">Amerikan Samoa</xsl:when>
			<xsl:when test="$CountryType='AX'">Aland Adaları</xsl:when>
			<xsl:when test="$CountryType='BV'">Bouvet Adası</xsl:when>
			<xsl:when test="$CountryType='CK'">Cook Adaları</xsl:when>
			<xsl:when test="$CountryType='CX'">Christmas Adası</xsl:when>
			<xsl:when test="$CountryType='CW'">Curaçao</xsl:when>
			<xsl:when test="$CountryType='CC'">Cocos Adaları</xsl:when>
			<xsl:when test="$CountryType='BQ'">Bonaire, Sint Eustatius and Saba</xsl:when>
			<xsl:when test="$CountryType='GS'">Güney Gürcistan ve Güney Sandviç Adaları</xsl:when>
			<xsl:when test="$CountryType='GU'">Guam</xsl:when>
			<xsl:when test="$CountryType='HM'">Heard Adası and McDonald Adaları</xsl:when>
			<xsl:when test="$CountryType='IO'">Britanya Hindistan Okyanus Bölgesi</xsl:when>
			<xsl:when test="$CountryType='MP'">Kuzey Mariana Adaları</xsl:when>
			<xsl:when test="$CountryType='MS'">Montserrat</xsl:when>
			<xsl:when test="$CountryType='NF'">Norfolk Adası</xsl:when>
			<xsl:when test="$CountryType='NU'">Niue</xsl:when>
			<xsl:when test="$CountryType='PN'">Pitcairn</xsl:when>
			<xsl:when test="$CountryType='PS'">Filistin Devleti</xsl:when>
			<xsl:when test="$CountryType='SH'">Saint Helena, Ascension and Tristan Da Cunha</xsl:when>
			<xsl:when test="$CountryType='SX'">Sint Maarten (Dutch Part)</xsl:when>
			<xsl:when test="$CountryType='TF'">French Southern Territories</xsl:when>
			<xsl:when test="$CountryType='TK'">Tokelau</xsl:when>
			<xsl:when test="$CountryType='UM'">United States Minor Outlying Islands</xsl:when>
			<xsl:when test="$CountryType='VI'">Virgin Islands, U.S.</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$CountryType"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Curr_Type">
		<xsl:param name="format"/>
		<xsl:param name="valuePath"/>
		<xsl:value-of select="format-number($valuePath, $format, 'european')"/>
		<xsl:if test="$valuePath/@currencyID">
			<xsl:text> </xsl:text>
			<xsl:choose>
				<xsl:when test="$valuePath/@currencyID = 'TRL' or $valuePath/@currencyID = 'TRY'">
					<xsl:text>TL</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$valuePath/@currencyID"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>